/*
 * Decompiled with CFR 0.152.
 */
package xyz.imcodist.quickmenu.ui.popups;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import xyz.imcodist.quickmenu.data.command_actions.BaseActionData;
import xyz.imcodist.quickmenu.data.command_actions.CommandActionData;
import xyz.imcodist.quickmenu.data.command_actions.KeybindActionData;
import xyz.imcodist.quickmenu.ui.surfaces.SwitcherSurface;

public class ActionPickerUI
extends OverlayContainer<FlowLayout> {
    public Consumer<BaseActionData> onSelectedAction;
    private final ArrayList<ArrayList<String>> listData = new ArrayList();

    public ActionPickerUI() {
        super((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)));
        FlowLayout rootComponent = (FlowLayout)this.child;
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.fixed((int)180), (Sizing)Sizing.fixed((int)120));
        mainLayout.surface((Surface)new SwitcherSurface()).padding(Insets.of((int)10));
        rootComponent.child((Component)mainLayout);
        FlowLayout actionsLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        ScrollContainer itemsScrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100), (Component)actionsLayout);
        mainLayout.child((Component)itemsScrollContainer);
        this.addListData("command", "Command", "Runs a chat command.");
        this.addListData("keybind", "Keybind", "Activates a keybind.");
        for (ArrayList<String> data : this.listData) {
            actionsLayout.child((Component)this.createActionLayout(data));
        }
    }

    private void addListData(String type, String name, String description) {
        this.listData.add(new ArrayList<String>(List.of(type, name, description)));
    }

    private FlowLayout createActionLayout(ArrayList<String> data) {
        String type = data.get(0);
        String name = data.get(1);
        String description = data.get(2);
        FlowLayout layout = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        layout.padding(Insets.of((int)0, (int)8, (int)0, (int)4)).alignment(HorizontalAlignment.RIGHT, VerticalAlignment.CENTER);
        class_5250 labelText = class_2561.method_43470((String)name).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)description).method_27692(class_124.field_1056));
        LabelComponent label = Components.label((class_2561)labelText);
        label.positioning(Positioning.relative((int)0, (int)50));
        layout.child((Component)label);
        ButtonComponent addButton = Components.button((class_2561)class_2561.method_43470((String)" + "), buttonComponent -> {
            this.onSelectedAction.accept(this.getActionFromType(type));
            this.remove();
        });
        addButton.margins(Insets.of((int)0, (int)0, (int)0, (int)0));
        layout.child((Component)addButton);
        return layout;
    }

    private BaseActionData getActionFromType(String type) {
        switch (type) {
            case "command": {
                return new CommandActionData();
            }
            case "keybind": {
                return new KeybindActionData();
            }
        }
        return null;
    }
}

