/*
 * Decompiled with CFR 0.152.
 */
package xyz.imcodist.quickmenu.ui;

import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import xyz.imcodist.quickmenu.QuickMenu;
import xyz.imcodist.quickmenu.data.ActionButtonData;
import xyz.imcodist.quickmenu.other.ActionButtonDataHandler;
import xyz.imcodist.quickmenu.other.ModKeybindings;
import xyz.imcodist.quickmenu.ui.ActionEditorUI;
import xyz.imcodist.quickmenu.ui.components.QuickMenuButton;
import xyz.imcodist.quickmenu.ui.surfaces.SwitcherSurface;

public class MainUI
extends BaseOwoScreen<FlowLayout> {
    public boolean editMode = false;
    private FlowLayout editorLayout;
    private ActionButtonData hoveredData;

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        int mainLayoutHeight = QuickMenu.CONFIG.menuHeight();
        FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.fixed((int)QuickMenu.CONFIG.menuWidth()), (Sizing)Sizing.fixed((int)mainLayoutHeight));
        mainLayout.surface((Surface)new SwitcherSurface());
        rootComponent.child((Component)mainLayout);
        this.editorLayout = Containers.horizontalFlow((Sizing)Sizing.fixed((int)0), (Sizing)Sizing.fixed((int)0));
        this.editorLayout.padding(Insets.of((int)6));
        rootComponent.child((Component)this.editorLayout);
        int headerLayoutHeight = 24;
        FlowLayout headerLayout = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)headerLayoutHeight));
        headerLayout.surface((Surface)new SwitcherSurface(true)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        mainLayout.child((Component)headerLayout);
        LabelComponent headerLabel = Components.label((class_2561)class_2561.method_43471((String)"menu.main.title"));
        headerLabel.shadow(true);
        headerLayout.child((Component)headerLabel);
        if (!QuickMenu.CONFIG.hideEditIcon()) {
            ButtonComponent headerEditButton = Components.button((class_2561)class_2561.method_43470((String)"\u270e"), buttonComponent -> {
                this.editMode = !this.editMode;
                this.updateEditorLayout();
            });
            headerEditButton.textShadow(true).renderer(ButtonComponent.Renderer.flat((int)0, (int)0, (int)0)).margins(Insets.of((int)0, (int)0, (int)5, (int)0)).horizontalSizing(Sizing.fixed((int)10));
            headerLayout.child((Component)headerEditButton);
        }
        FlowLayout actionFlowLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        int actionLayoutHeight = mainLayoutHeight - headerLayoutHeight;
        ScrollContainer actionLayout = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)actionLayoutHeight), (Component)actionFlowLayout);
        actionLayout.padding(Insets.of((int)2, (int)5, (int)2, (int)2));
        mainLayout.child((Component)actionLayout);
        this.createActionButtons(actionFlowLayout);
        ButtonComponent newButton = Components.button((class_2561)class_2561.method_43471((String)"menu.main.button.add_action"), buttonComponent -> this.gotoActionEditor(null));
        this.editorLayout.child((Component)newButton);
        this.editorLayout.gap(5);
        ButtonComponent configButton = Components.button((class_2561)class_2561.method_43471((String)"menu.main.button.config"), buttonComponent -> {
            if (this.field_22787 == null) {
                return;
            }
            this.field_22787.method_1507((class_437)ConfigScreen.create((ConfigWrapper)QuickMenu.CONFIG, null));
        });
        this.editorLayout.child((Component)configButton);
        this.updateEditorLayout();
    }

    private void updateEditorLayout() {
        if (!this.editMode) {
            this.editorLayout.surface(Surface.BLANK).margins(Insets.of((int)0)).sizing(Sizing.fixed((int)0));
        } else {
            this.editorLayout.surface(Surface.DARK_PANEL).margins(Insets.of((int)10, (int)0, (int)0, (int)0)).sizing(Sizing.content());
        }
    }

    private void gotoActionEditor(ActionButtonData action) {
        ActionEditorUI actionEditor = new ActionEditorUI(action);
        actionEditor.previousScreen = this.cloneMenu();
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507((class_437)actionEditor);
    }

    private void createActionButtons(FlowLayout parent) {
        parent.clearChildren();
        double actionsCount = ActionButtonDataHandler.actions.size();
        int curAction = 0;
        double rowSize = QuickMenu.CONFIG.buttonsPerRow();
        if (actionsCount > 0.0) {
            int y = 0;
            while ((double)y < Math.ceil(actionsCount / rowSize)) {
                FlowLayout buttonRowLayout = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
                buttonRowLayout.horizontalAlignment(HorizontalAlignment.CENTER);
                int i = 0;
                while ((double)i < rowSize && !((double)curAction >= actionsCount)) {
                    ActionButtonData data = ActionButtonDataHandler.actions.get(curAction);
                    QuickMenuButton button = this.createActionButton(data);
                    buttonRowLayout.child((Component)button);
                    ++curAction;
                    ++i;
                }
                parent.child((Component)buttonRowLayout);
                ++y;
            }
        } else {
            LabelComponent label = Components.label((class_2561)class_2561.method_43471((String)"menu.main.no_actions"));
            label.horizontalTextAlignment(HorizontalAlignment.CENTER).verticalTextAlignment(VerticalAlignment.CENTER).horizontalSizing(Sizing.fill((int)100)).margins(Insets.of((int)5, (int)0, (int)0, (int)0));
            parent.child((Component)label);
        }
    }

    private QuickMenuButton createActionButton(ActionButtonData data) {
        QuickMenuButton button = new QuickMenuButton(data.icon, buttonComponent -> this.pressButton(data), quickMenuButton -> {
            if (this.editMode) {
                ActionButtonDataHandler.remove(data);
                class_310.method_1551().method_1507((class_437)this.cloneMenu());
            }
        });
        button.mouseEnter().subscribe(() -> {
            this.hoveredData = data;
        });
        button.mouseLeave().subscribe(() -> {
            this.hoveredData = null;
        });
        StringBuilder actionsText = new StringBuilder();
        if (QuickMenu.CONFIG.showActionsInTooltip()) {
            data.actions.forEach(actionData -> {
                if (actionData == null) {
                    return;
                }
                actionsText.append("\n").append(actionData.getString());
            });
        }
        class_5250 tooltip = class_2561.method_43470((String)data.name).method_10852((class_2561)class_2561.method_43470((String)actionsText.toString()).method_27692(class_124.field_1063));
        button.margins(Insets.of((int)1, (int)1, (int)2, (int)2)).tooltip((class_2561)tooltip);
        return button;
    }

    public void pressButton(ActionButtonData data) {
        if (this.editMode) {
            this.gotoActionEditor(data);
            return;
        }
        data.run();
        if (QuickMenu.CONFIG.closeOnAction()) {
            this.method_25419();
        }
    }

    public MainUI cloneMenu() {
        MainUI clone = new MainUI();
        clone.editMode = this.editMode;
        return clone;
    }

    private void closeOnKeybindRelease(int mouseButton) {
        this.closeOnKeybindRelease(true, mouseButton, 0);
    }

    private void closeOnKeybindRelease(int keyCode, int scanCode) {
        this.closeOnKeybindRelease(false, keyCode, scanCode);
    }

    private void closeOnKeybindRelease(boolean mouse, int button, int button2) {
        if (this.editMode) {
            return;
        }
        if (!QuickMenu.CONFIG.closeOnKeyReleased()) {
            return;
        }
        if (mouse && ModKeybindings.menuOpenKeybinding.method_1433(button) || !mouse && ModKeybindings.menuOpenKeybinding.method_1417(button, button2)) {
            if (this.hoveredData != null) {
                this.pressButton(this.hoveredData);
            }
            this.method_25419();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69) {
            this.editMode = !this.editMode;
            this.updateEditorLayout();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.closeOnKeybindRelease(keyCode, scanCode);
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.closeOnKeybindRelease(button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }
}

