/*
 * Decompiled with CFR 0.152.
 */
package xyz.imcodist.quickmenu.ui;

import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import xyz.imcodist.quickmenu.data.ActionButtonData;
import xyz.imcodist.quickmenu.data.command_actions.BaseActionData;
import xyz.imcodist.quickmenu.data.command_actions.CommandActionData;
import xyz.imcodist.quickmenu.data.command_actions.KeybindActionData;
import xyz.imcodist.quickmenu.other.ActionButtonDataHandler;
import xyz.imcodist.quickmenu.ui.components.QuickMenuButton;
import xyz.imcodist.quickmenu.ui.popups.ActionPickerUI;
import xyz.imcodist.quickmenu.ui.popups.ItemPickerUI;
import xyz.imcodist.quickmenu.ui.popups.KeybindPickerUI;
import xyz.imcodist.quickmenu.ui.surfaces.SwitcherSurface;

public class ActionEditorUI
extends BaseOwoScreen<FlowLayout> {
    ActionButtonData actionButtonData = new ActionButtonData();
    boolean newAction = true;
    FlowLayout actionsLayout;
    ArrayList<Component> actionsSource = new ArrayList();
    ArrayList<BaseActionData> actionArray = new ArrayList();
    private OverlayContainer<FlowLayout> pickerUI;
    private TextBoxComponent customModelDataTextBox;
    private ButtonComponent keybindButton;
    private boolean settingKeybind = false;
    private boolean boundKeybind = false;
    private ArrayList<Integer> keybind = new ArrayList();
    public BaseOwoScreen<FlowLayout> previousScreen;

    public ActionEditorUI(ActionButtonData action) {
        if (action != null) {
            this.actionButtonData = action;
            this.actionArray = new ArrayList<BaseActionData>(this.actionButtonData.actions);
            this.keybind = new ArrayList<Integer>(this.actionButtonData.keybind);
            if (this.keybind.size() >= 4) {
                this.boundKeybind = true;
            }
            this.newAction = false;
        }
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        int mainLayoutHeight = 206;
        FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.fixed((int)210), (Sizing)Sizing.fixed((int)mainLayoutHeight));
        mainLayout.surface((Surface)new SwitcherSurface());
        mainLayout.zIndex(-200);
        rootComponent.child((Component)mainLayout);
        int headerLayoutHeight = 24;
        FlowLayout headerLayout = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)headerLayoutHeight));
        headerLayout.surface((Surface)new SwitcherSurface(true)).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        mainLayout.child((Component)headerLayout);
        LabelComponent headerLabel = Components.label((class_2561)class_2561.method_43471((String)"menu.editor.title"));
        headerLayout.child((Component)headerLabel);
        FlowLayout propertiesLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        int propertiesScrollHeight = mainLayoutHeight - headerLayoutHeight;
        ScrollContainer propertiesScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)propertiesScrollHeight), (Component)propertiesLayout);
        propertiesScroll.padding(Insets.of((int)5, (int)5, (int)8, (int)3));
        mainLayout.child((Component)propertiesScroll);
        FlowLayout nameProperty = this.createNewProperty("name");
        nameProperty.padding(((Insets)nameProperty.padding().get()).withTop(0));
        TextBoxComponent nameTextBox = Components.textBox((Sizing)Sizing.fixed((int)100), (String)this.actionButtonData.name);
        nameTextBox.cursorStyle(CursorStyle.TEXT);
        nameProperty.child((Component)nameTextBox);
        propertiesLayout.child((Component)nameProperty);
        FlowLayout iconProperty = this.createNewProperty("icon");
        QuickMenuButton iconButton = new QuickMenuButton(this.actionButtonData.icon, buttonComponent -> {
            QuickMenuButton quickMenuButton = (QuickMenuButton)((Object)buttonComponent);
            ItemPickerUI itemPicker = new ItemPickerUI();
            itemPicker.selectedItem = quickMenuButton.itemIcon;
            itemPicker.customModelData = this.getCustomModelData(quickMenuButton.itemIcon);
            quickMenuButton.itemIcon = null;
            itemPicker.onSelectedItem = item -> {
                quickMenuButton.itemIcon = item;
                this.updateCustomModelData(quickMenuButton.itemIcon);
            };
            rootComponent.child((Component)itemPicker);
            this.pickerUI = itemPicker;
        }, quickMenuButton -> {});
        iconProperty.child((Component)iconButton);
        propertiesLayout.child((Component)iconProperty);
        this.createActions(propertiesLayout);
        CollapsibleContainer advancedLayout = Containers.collapsible((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content(), (class_2561)class_2561.method_43471((String)"menu.editor.advanced"), (boolean)false);
        advancedLayout.padding(Insets.of((int)4, (int)0, (int)-5, (int)5)).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout keybindProperty = this.createNewProperty("keybind", false);
        advancedLayout.child((Component)keybindProperty);
        this.keybindButton = Components.button((class_2561)class_2561.method_43471((String)"menu.editor.not_bound"), buttonComponent -> {
            this.settingKeybind = true;
            this.updateKeybindButton();
        });
        this.keybindButton.horizontalSizing(Sizing.fixed((int)80));
        keybindProperty.child((Component)this.keybindButton);
        this.updateKeybindButton();
        FlowLayout customModelDataProperty = this.createNewProperty("custommodeldata", false);
        advancedLayout.child((Component)customModelDataProperty);
        Integer customModelData = this.getCustomModelData(iconButton.itemIcon);
        String cmdText = customModelData != 0 ? customModelData.toString() : "";
        this.customModelDataTextBox = Components.textBox((Sizing)Sizing.fixed((int)75), (String)cmdText);
        this.customModelDataTextBox.cursorStyle(CursorStyle.TEXT);
        this.customModelDataTextBox.onChanged().subscribe(text -> {
            this.customModelDataTextBox.method_1852(text.replaceAll("^0+|\\D", ""));
            this.updateCustomModelData(iconButton.itemIcon);
        });
        customModelDataProperty.child((Component)this.customModelDataTextBox);
        propertiesLayout.child((Component)advancedLayout);
        customModelDataProperty.padding(((Insets)customModelDataProperty.padding().get()).add(0, 6, 0, 0));
        FlowLayout buttonsLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonsLayout.surface(Surface.DARK_PANEL).padding(Insets.of((int)6)).margins(Insets.of((int)10, (int)0, (int)0, (int)0));
        rootComponent.child((Component)buttonsLayout);
        ButtonComponent finishButton = Components.button((class_2561)class_2561.method_43471((String)"menu.editor.button.finish"), buttonComponent -> {
            this.actionButtonData.name = nameTextBox.method_1882();
            if (iconButton.itemIcon != null) {
                this.actionButtonData.icon = iconButton.itemIcon;
            }
            this.actionButtonData.actions = this.actionArray;
            this.updateActionData();
            if (!this.boundKeybind) {
                this.keybind.clear();
            }
            this.actionButtonData.keybind = this.keybind;
            if (this.newAction) {
                ActionButtonDataHandler.add(this.actionButtonData);
            } else {
                ActionButtonDataHandler.save();
            }
            this.method_25419();
        });
        ButtonComponent cancelButton = Components.button((class_2561)class_2561.method_43471((String)"menu.editor.button.cancel"), buttonComponent -> this.method_25419());
        buttonsLayout.child((Component)finishButton);
        buttonsLayout.gap(4);
        buttonsLayout.child((Component)cancelButton);
    }

    private Integer getCustomModelData(class_1799 item) {
        if (item == null) {
            return class_9280.field_49307.comp_2382();
        }
        return ((class_9280)item.method_57825(class_9334.field_49637, (Object)class_9280.field_49307)).comp_2382();
    }

    private void updateCustomModelData(class_1799 itemStack) {
        String text = this.customModelDataTextBox.method_1882();
        if (itemStack == null) {
            return;
        }
        try {
            if (!text.equals("")) {
                itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(Integer.parseInt(text)));
            } else {
                itemStack.method_57381(class_9334.field_49637);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public FlowLayout createNewProperty(String name) {
        return this.createNewProperty(name, true, true);
    }

    public FlowLayout createNewProperty(String name, boolean underline) {
        return this.createNewProperty(name, underline, true);
    }

    public FlowLayout createNewProperty(String name, boolean underline, boolean useTranslatable) {
        FlowLayout layout = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        layout.padding(Insets.of((int)4, (int)0, (int)0, (int)4)).alignment(HorizontalAlignment.RIGHT, VerticalAlignment.CENTER);
        class_5250 labelText = useTranslatable ? class_2561.method_43471((String)("menu.editor.property." + name)) : class_2561.method_43470((String)name);
        if (underline) {
            labelText.method_27692(class_124.field_1073);
        }
        LabelComponent label = Components.label((class_2561)labelText);
        label.positioning(Positioning.relative((int)0, (int)50));
        layout.child((Component)label);
        return layout;
    }

    public void createActions(FlowLayout layout) {
        this.updateActionData();
        this.actionsSource.clear();
        if (this.actionsLayout != null) {
            this.actionsLayout.remove();
        }
        this.actionsLayout = this.createActionsLayout();
        layout.child(2, (Component)this.actionsLayout);
        AtomicInteger i = new AtomicInteger();
        this.actionArray.forEach(action -> {
            String name = action.getTypeString();
            FlowLayout property = this.createNewProperty(name + " #" + (i.get() + 1), false, false);
            TextBoxComponent source = null;
            if (action instanceof CommandActionData) {
                CommandActionData commandAction = (CommandActionData)action;
                TextBoxComponent textBoxComponent = Components.textBox((Sizing)Sizing.fill((int)57));
                textBoxComponent.method_1880(10000);
                textBoxComponent.text(commandAction.command);
                property.child((Component)textBoxComponent);
                source = textBoxComponent;
            }
            if (action instanceof KeybindActionData) {
                KeybindActionData keybindAction = (KeybindActionData)action;
                ButtonComponent keybindActionButton = Components.button((class_2561)class_2561.method_43471((String)"menu.editor.not_bound"), buttonComponent -> {
                    KeybindPickerUI keybindPicker = new KeybindPickerUI();
                    keybindPicker.onSelectedKeybind = item -> {
                        keybindAction.keybindTranslationKey = item.method_1431();
                        this.updateActionKeybindMessage((ButtonComponent)buttonComponent, keybindAction);
                    };
                    FlowLayout rootComponent = (FlowLayout)layout.root();
                    rootComponent.child((Component)keybindPicker);
                    this.pickerUI = keybindPicker;
                });
                keybindActionButton.horizontalSizing(Sizing.fill((int)57));
                this.updateActionKeybindMessage(keybindActionButton, keybindAction);
                property.child((Component)keybindActionButton);
            }
            ButtonComponent removeActionButton = Components.button((class_2561)class_2561.method_43470((String)" - "), buttonComponent -> {
                int currentIndex = this.actionArray.indexOf(action);
                this.actionsSource.remove(currentIndex);
                this.actionArray.remove(action);
                assert (this.actionsLayout.parent() != null);
                this.createActions((FlowLayout)this.actionsLayout.parent());
            });
            removeActionButton.margins(Insets.of((int)0, (int)0, (int)4, (int)0));
            property.child((Component)removeActionButton);
            this.actionsLayout.child((Component)property);
            this.actionsSource.add((Component)source);
            i.addAndGet(1);
        });
        FlowLayout actionLayout = this.createNewProperty("new_action", false);
        actionLayout.padding(((Insets)actionLayout.padding().get()).add(0, 6, 0, 0));
        ButtonComponent newActionButton = Components.button((class_2561)class_2561.method_43470((String)" + "), buttonComponent -> {
            ActionPickerUI actionPicker = new ActionPickerUI();
            actionPicker.onSelectedAction = action -> {
                this.actionArray.add((BaseActionData)action);
                this.createActions((FlowLayout)this.actionsLayout.parent());
            };
            FlowLayout rootComponent = (FlowLayout)layout.root();
            rootComponent.child((Component)actionPicker);
            this.pickerUI = actionPicker;
        });
        actionLayout.child((Component)newActionButton);
        this.actionsLayout.child((Component)actionLayout);
    }

    public FlowLayout createActionsLayout() {
        CollapsibleContainer layout = Containers.collapsible((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content(), (class_2561)class_2561.method_43471((String)"menu.editor.actions"), (boolean)true);
        layout.padding(Insets.of((int)4, (int)0, (int)-5, (int)5)).verticalAlignment(VerticalAlignment.CENTER);
        return layout;
    }

    public void updateActionData() {
        if (this.actionsSource.isEmpty()) {
            return;
        }
        AtomicInteger i = new AtomicInteger();
        this.actionArray.forEach(action -> {
            if (this.actionsSource.size() <= i.get()) {
                return;
            }
            Component source = this.actionsSource.get(i.get());
            if (action instanceof CommandActionData) {
                CommandActionData commandAction = (CommandActionData)action;
                TextBoxComponent textBoxSource = (TextBoxComponent)source;
                commandAction.command = textBoxSource.method_1882();
            }
            i.addAndGet(1);
        });
    }

    public void updateKeybindButton() {
        Object message;
        if (!this.boundKeybind) {
            message = "Not Bound";
        } else {
            boolean isMouse;
            boolean bl = isMouse = this.keybind.get(3) == 1;
            if (!isMouse) {
                message = class_3675.method_15985((int)this.keybind.get(0), (int)this.keybind.get(1)).method_27445().getString();
            } else {
                switch (this.keybind.get(0)) {
                    case 0: {
                        Object object = "Left Button";
                        break;
                    }
                    case 1: {
                        Object object = "Right Button";
                        break;
                    }
                    case 2: {
                        Object object = "Middle Button";
                        break;
                    }
                    default: {
                        Object object = message = "Mouse " + String.valueOf(this.keybind.get(0));
                    }
                }
            }
        }
        if (this.settingKeybind) {
            message = "> " + (String)message + " <";
        }
        this.keybindButton.method_25355(class_2561.method_30163((String)message));
    }

    private void updateActionKeybindMessage(ButtonComponent button, KeybindActionData actionData) {
        if (!actionData.keybindTranslationKey.equals("")) {
            Object textString = class_2561.method_43471((String)actionData.keybindTranslationKey).getString();
            int maxLength = 14;
            button.tooltip((class_2561)class_2561.method_43470((String)""));
            if (((String)textString).length() > maxLength) {
                textString = ((String)textString).substring(0, maxLength) + "...";
            }
            button.method_25355((class_2561)class_2561.method_43470((String)textString));
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean wasEscape = false;
        if (this.settingKeybind) {
            if (keyCode != 256) {
                this.boundKeybind = true;
                this.keybind.clear();
                this.keybind.add(keyCode);
                this.keybind.add(scanCode);
                this.keybind.add(modifiers);
                this.keybind.add(0);
            } else {
                this.boundKeybind = false;
                wasEscape = true;
            }
            this.settingKeybind = false;
            this.updateKeybindButton();
        }
        if (!wasEscape) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean keybindSet = false;
        if (this.settingKeybind) {
            keybindSet = true;
            this.keybind.clear();
            if (button <= 2) {
                this.boundKeybind = true;
                this.keybind.add(button);
                this.keybind.add(0);
                this.keybind.add(0);
                this.keybind.add(1);
            } else {
                this.boundKeybind = false;
            }
            this.settingKeybind = false;
            this.updateKeybindButton();
        }
        if (!keybindSet) {
            return super.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public void method_25419() {
        if (this.pickerUI != null && this.pickerUI.parent() != null) {
            this.pickerUI.remove();
            this.pickerUI = null;
            return;
        }
        if (this.previousScreen != null) {
            class_310.method_1551().method_1507(this.previousScreen);
        } else {
            super.method_25419();
        }
    }

    public boolean method_25421() {
        return false;
    }
}

