/*
 * Decompiled with CFR 0.152.
 */
package xyz.imcodist.quickmenu.other;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import xyz.imcodist.quickmenu.data.ActionButtonData;
import xyz.imcodist.quickmenu.data.ActionButtonDataJSON;

public class ActionButtonDataHandler {
    public static List<ActionButtonData> actions = new ArrayList<ActionButtonData>();

    public static void initialize() {
        ActionButtonDataHandler.load();
    }

    public static void add(ActionButtonData action) {
        actions.add(action);
        ActionButtonDataHandler.save();
    }

    public static void remove(ActionButtonData action) {
        actions.remove(action);
        ActionButtonDataHandler.save();
    }

    public static void load() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "quickmenu_data.json");
        Gson gson = new Gson();
        Type listType = new TypeToken<List<ActionButtonDataJSON>>(){}.getType();
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);){
                List actionDataJSONS = (List)gson.fromJson((Reader)fileReader, listType);
                for (ActionButtonDataJSON action : actionDataJSONS) {
                    actions.add(ActionButtonData.fromJSON(action));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        ArrayList<ActionButtonDataJSON> actionDataJSONS = new ArrayList<ActionButtonDataJSON>();
        for (ActionButtonData action : actions) {
            actionDataJSONS.add(action.toJSON());
        }
        Gson gson = new Gson();
        String jsonString = gson.toJson(actionDataJSONS);
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "quickmenu_data.json");
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

