/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.ParentComponent;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class FocusHandler {
    protected final ParentComponent root;
    @Nullable
    protected Component focused = null;
    @Nullable
    protected Component.FocusSource lastFocusSource = null;

    public FocusHandler(ParentComponent root) {
        this.root = root;
    }

    public void updateClickFocus(double mouseX, double mouseY) {
        Component clicked = this.root.childAt((int)mouseX, (int)mouseY);
        this.focus(clicked != null && clicked.canFocus(Component.FocusSource.MOUSE_CLICK) ? clicked : null, Component.FocusSource.MOUSE_CLICK);
    }

    @Contract(pure=true)
    @Nullable
    public Component focused() {
        return this.focused;
    }

    public Component.FocusSource lastFocusSource() {
        return this.lastFocusSource;
    }

    public void cycle(boolean forwards) {
        int newIndex;
        ArrayList<Component> allChildren = new ArrayList<Component>();
        this.root.collectDescendants(allChildren);
        allChildren.removeIf(component -> !component.canFocus(Component.FocusSource.KEYBOARD_CYCLE));
        if (allChildren.isEmpty()) {
            return;
        }
        int n = this.focused == null ? (forwards ? 0 : allChildren.size() - 1) : (newIndex = allChildren.indexOf(this.focused) + (forwards ? 1 : -1));
        if (newIndex >= allChildren.size()) {
            newIndex -= allChildren.size();
        }
        if (newIndex < 0) {
            newIndex += allChildren.size();
        }
        this.focus(allChildren.get(newIndex), Component.FocusSource.KEYBOARD_CYCLE);
    }

    public void moveFocus(int keyCode) {
        if (this.focused == null) {
            return;
        }
        ArrayList<Component> allChildren = new ArrayList<Component>();
        this.root.collectDescendants(allChildren);
        allChildren.removeIf(component -> !component.canFocus(Component.FocusSource.KEYBOARD_CYCLE));
        if (allChildren.isEmpty()) {
            return;
        }
        Component closest = this.focused;
        switch (keyCode) {
            case 262: {
                int closestX = Integer.MAX_VALUE;
                int closestY = Integer.MAX_VALUE;
                for (Component child : allChildren) {
                    if (child == this.focused || child.x() < this.focused.x() + this.focused.width() || child.x() > closestX || Math.abs(child.y() - this.focused.y()) > closestY) continue;
                    closest = child;
                    closestX = child.x();
                    closestY = Math.abs(child.y() - this.focused.y());
                }
                break;
            }
            case 263: {
                int closestX = 0;
                int closestY = Integer.MAX_VALUE;
                for (Component child : allChildren) {
                    if (child == this.focused || child.x() + child.width() > this.focused.x() || child.x() + child.width() < closestX || Math.abs(child.y() - this.focused.y()) > closestY) continue;
                    closest = child;
                    closestX = child.x() + child.width();
                    closestY = Math.abs(child.y() - this.focused.y());
                }
                break;
            }
            case 265: {
                int closestX = Integer.MAX_VALUE;
                int closestY = 0;
                for (Component child : allChildren) {
                    if (child == this.focused || child.y() + child.height() > this.focused.y() || child.y() + child.height() < closestY || Math.abs(child.x() - this.focused.x()) > closestX) continue;
                    closest = child;
                    closestX = Math.abs(child.x() - this.focused.x());
                    closestY = child.y() + child.height();
                }
                break;
            }
            case 264: {
                int closestX = Integer.MAX_VALUE;
                int closestY = Integer.MAX_VALUE;
                for (Component child : allChildren) {
                    if (child == this.focused || child.y() < this.focused.y() + this.focused.height() || child.y() + child.height() > closestY || Math.abs(child.x() - this.focused.x()) > closestX) continue;
                    closest = child;
                    closestX = Math.abs(child.x() - this.focused.x());
                    closestY = child.y() + child.height();
                }
                break;
            }
        }
        this.focus(closest, Component.FocusSource.KEYBOARD_CYCLE);
    }

    public void focus(@Nullable Component component, Component.FocusSource source) {
        if (this.focused != component) {
            if (this.focused != null) {
                this.focused.onFocusLost();
            }
            if ((this.focused = component) != null) {
                this.focused.onFocusGained(source);
                this.lastFocusSource = source;
            } else {
                this.lastFocusSource = null;
            }
        }
    }
}

