/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DropdownComponent
extends FlowLayout {
    protected static final class_2960 ICONS_TEXTURE = class_2960.method_60655((String)"owo", (String)"textures/gui/dropdown_icons.png");
    protected final FlowLayout entries;
    protected boolean closeWhenNotHovered = false;

    protected DropdownComponent(Sizing horizontalSizing) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        this.entries = Containers.verticalFlow(horizontalSizing, Sizing.content());
        this.entries.padding(Insets.of(1));
        this.entries.allowOverflow(true);
        this.entries.surface(Surface.flat(-956301312).and(Surface.blur(3.0f, 5.0f)).and(Surface.outline(-15592942)));
        this.child(this.entries);
    }

    public static <R extends ParentComponent> DropdownComponent openContextMenu(class_437 screen, R rootComponent, BiConsumer<R, DropdownComponent> mountFunction, double mouseX, double mouseY, Consumer<DropdownComponent> builder) {
        DropdownComponent dropdown = new DropdownComponent(Sizing.content());
        builder.accept(dropdown);
        mountFunction.accept(rootComponent, dropdown);
        int xLocation = (int)mouseX - rootComponent.x();
        int yLocation = (int)mouseY - rootComponent.y();
        if (xLocation + dropdown.width() > screen.field_22789) {
            xLocation -= xLocation + dropdown.width() - screen.field_22789;
        }
        if (yLocation + dropdown.height() > screen.field_22790) {
            yLocation -= yLocation + dropdown.height() - screen.field_22790;
        }
        dropdown.positioning(Positioning.absolute(xLocation, yLocation));
        MutableBoolean dismounted = new MutableBoolean(false);
        ScreenMouseEvents.beforeMouseClick((class_437)screen).register((screen_, mouseX_, mouseY_, button) -> {
            if (dismounted.isTrue() || dropdown.isInBoundingBox(mouseX_, mouseY_)) {
                return;
            }
            rootComponent.removeChild(dropdown);
            dismounted.setTrue();
        });
        return dropdown;
    }

    @Override
    public ParentComponent surface(Surface surface) {
        return this.entries.surface(surface);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        if (this.closeWhenNotHovered && !this.isInBoundingBox(mouseX, mouseY)) {
            this.queue(() -> {
                this.closeWhenNotHovered(false);
                this.parent.removeChild(this);
            });
        }
    }

    @Override
    public void layout(Size space) {
        super.layout(space);
        List<Component> entries = this.entries.children();
        for (int i = 0; i < entries.size(); ++i) {
            Component entry = entries.get(i);
            if (!(entry instanceof ResizeableComponent)) continue;
            ResizeableComponent sizeable = (ResizeableComponent)((Object)entry);
            sizeable.setWidth(this.entries.width() - ((Insets)this.entries.padding().get()).horizontal() - ((Insets)entry.margins().get()).horizontal());
        }
    }

    public DropdownComponent divider() {
        this.entries.child(new Divider());
        return this;
    }

    public DropdownComponent text(class_2561 text) {
        this.entries.child(Components.label(text).color(Color.ofFormatting(class_124.field_1080)).margins(Insets.of(2)));
        return this;
    }

    public DropdownComponent button(class_2561 text, Consumer<DropdownComponent> onClick) {
        this.entries.child(new Button(this, text, onClick).margins(Insets.of(2)));
        return this;
    }

    public DropdownComponent checkbox(class_2561 text, boolean state, Consumer<Boolean> onClick) {
        this.entries.child(new Checkbox(this, text, state, onClick).margins(Insets.of(2)));
        return this;
    }

    public DropdownComponent nested(class_2561 text, Sizing horizontalSizing, Consumer<DropdownComponent> builder) {
        DropdownComponent nested = new DropdownComponent(horizontalSizing);
        builder.accept(nested);
        this.entries.child(new NestEntry(this, text, nested).margins(Insets.of(2)));
        return this;
    }

    @Override
    public FlowLayout removeChild(Component child) {
        if (child == this.entries) {
            this.queue(() -> {
                this.closeWhenNotHovered(false);
                this.parent.removeChild(this);
            });
        }
        return super.removeChild(child);
    }

    public DropdownComponent closeWhenNotHovered(boolean closeWhenNotHovered) {
        this.closeWhenNotHovered = closeWhenNotHovered;
        return this;
    }

    public boolean closeWhenNotHovered() {
        return this.closeWhenNotHovered;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "entries", Function.identity(), this::parseAndApplyEntries);
        UIParsing.apply(children, "close-when-not-hovered", UIParsing::parseBool, this::closeWhenNotHovered);
    }

    protected void parseAndApplyEntries(Element container) {
        for (Node node : UIParsing.allChildrenOfType(container, (short)1)) {
            Element entry = (Element)node;
            switch (entry.getNodeName()) {
                case "divider": {
                    this.divider();
                    break;
                }
                case "text": {
                    this.text(UIParsing.parseText(entry));
                    break;
                }
                case "button": {
                    Map<String, Element> children = UIParsing.childElements(entry);
                    UIParsing.expectChildren(entry, children, "text");
                    class_2561 text = UIParsing.parseText(children.get("text"));
                    this.button(text, dropdownComponent -> {});
                    break;
                }
                case "checkbox": {
                    Map<String, Element> children = UIParsing.childElements(entry);
                    UIParsing.expectChildren(entry, children, "text", "checked");
                    class_2561 text = UIParsing.parseText(children.get("text"));
                    boolean checked = UIParsing.parseBool(children.get("checked"));
                    this.checkbox(text, checked, aBoolean -> {});
                    break;
                }
                case "nested": {
                    class_5250 text = entry.getAttribute("translate").equals("true") ? class_2561.method_43471((String)entry.getAttribute("name")) : class_2561.method_43470((String)entry.getAttribute("name"));
                    this.nested((class_2561)text, Sizing.content(), dropdownComponent -> dropdownComponent.parseAndApplyEntries(entry));
                }
            }
        }
    }

    protected static void drawIconFromTexture(OwoUIDrawContext context, ParentComponent dropdown, int y, int u, int v) {
        context.method_25290(ICONS_TEXTURE, dropdown.x() + dropdown.width() - ((Insets)dropdown.padding().get()).right() - 10, y, u, v, 9, 9, 32, 32);
    }

    protected static interface ResizeableComponent {
        public void setWidth(int var1);
    }

    protected static class Divider
    extends BaseComponent
    implements ResizeableComponent {
        public Divider() {
            this.sizing(Sizing.fixed(1));
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            Insets margins = (Insets)this.margins.get();
            context.method_25294(this.x - margins.left(), this.y - margins.top(), this.x + this.width + margins.right(), this.y + this.height + margins.bottom(), -15592942);
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }
    }

    protected static class Button
    extends LabelComponent
    implements ResizeableComponent {
        protected final DropdownComponent parentDropdown;
        protected Consumer<DropdownComponent> onClick;

        protected Button(DropdownComponent parentDropdown, class_2561 text, Consumer<DropdownComponent> onClick) {
            super(text);
            this.onClick = onClick;
            this.parentDropdown = parentDropdown;
            this.margins(Insets.vertical(1));
            this.cursorStyle(CursorStyle.HAND);
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public boolean onMouseDown(double mouseX, double mouseY, int button) {
            super.onMouseDown(mouseX, mouseY, button);
            this.onClick.accept(this.parentDropdown);
            this.playInteractionSound();
            return true;
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (this.isInBoundingBox(mouseX, mouseY)) {
                Insets margins = (Insets)this.margins.get();
                context.method_25294(this.x - margins.left(), this.y - margins.top(), this.x + this.width + margins.right(), this.y + this.height + margins.bottom(), 0x44FFFFFF);
            }
            super.draw(context, mouseX, mouseY, partialTicks, delta);
        }

        protected void playInteractionSound() {
            UISounds.playButtonSound();
        }
    }

    protected static class Checkbox
    extends Button {
        protected boolean state;

        public Checkbox(DropdownComponent parentDropdown, class_2561 text, boolean state, Consumer<Boolean> onClick) {
            super(parentDropdown, text, dropdownComponent -> {});
            this.state = state;
            this.onClick = dropdownComponent -> {
                this.state = !this.state;
                onClick.accept(this.state);
            };
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            DropdownComponent.drawIconFromTexture(context, this.parent, this.y, this.state ? 16 : 0, 0);
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return super.determineHorizontalContentSize(sizing) + 17;
        }

        @Override
        protected void playInteractionSound() {
            UISounds.playInteractionSound();
        }
    }

    protected static class NestEntry
    extends LabelComponent {
        private final DropdownComponent child;

        protected NestEntry(DropdownComponent parentDropdown, class_2561 text, DropdownComponent child) {
            super(text);
            this.child = child;
            this.mouseEnter().subscribe(() -> {
                child.margins(Insets.top(this.y - parentDropdown.y));
                parentDropdown.queue(() -> {
                    parentDropdown.removeChild(child);
                    parentDropdown.child(child);
                });
            });
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            DropdownComponent.drawIconFromTexture(context, this.parent, this.y, 0, 16);
            this.child.closeWhenNotHovered(!PositionedRectangle.of(this.x, this.y, this.parent.width(), this.height).isInBoundingBox(mouseX, mouseY));
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return super.determineHorizontalContentSize(sizing) + 17;
        }
    }
}

