/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.netty.buffer.ByteBuf;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmEndec;
import io.wispforest.endec.format.edm.EdmMap;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.format.edm.LenientEdmDeserializer;
import io.wispforest.owo.mixin.ForwardingDynamicOpsAccessor;
import io.wispforest.owo.mixin.RegistryOpsAccessor;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.EitherEndec;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.format.edm.EdmOps;
import io.wispforest.owo.util.Scary;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_5379;
import net.minecraft.class_6903;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

public class CodecUtils {
    public static <T> Endec<T> toEndec(Codec<T> codec) {
        return Endec.of((ctx, serializer, value) -> {
            DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
            EdmEndec.INSTANCE.encode(ctx, serializer, (EdmElement)codec.encodeStart(ops, value).getOrThrow(IllegalStateException::new));
        }, (ctx, deserializer) -> {
            DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
            return codec.parse(ops, (Object)EdmEndec.INSTANCE.decode(ctx, deserializer)).getOrThrow(IllegalStateException::new);
        });
    }

    public static <T> Endec<T> toEndec(Codec<T> codec, class_9139<ByteBuf, T> packetCodec) {
        return Endec.of((ctx, serializer, value) -> {
            if (serializer instanceof ByteBufSerializer) {
                class_2540 buffer = PacketByteBufs.create();
                packetCodec.encode((Object)buffer, value);
                MinecraftEndecs.PACKET_BYTE_BUF.encode(ctx, serializer, (Object)buffer);
                return;
            }
            DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
            EdmEndec.INSTANCE.encode(ctx, serializer, (EdmElement)codec.encodeStart(ops, value).getOrThrow(IllegalStateException::new));
        }, (ctx, deserializer) -> {
            if (deserializer instanceof ByteBufDeserializer) {
                class_2540 buffer = (class_2540)MinecraftEndecs.PACKET_BYTE_BUF.decode(ctx, deserializer);
                return packetCodec.decode((Object)buffer);
            }
            DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
            return codec.parse(ops, (Object)EdmEndec.INSTANCE.decode(ctx, deserializer)).getOrThrow(IllegalStateException::new);
        });
    }

    public static <T> Endec<T> toEndecWithRegistries(Codec<T> codec, class_9139<class_9129, T> packetCodec) {
        return Endec.of((ctx, serializer, value) -> {
            if (serializer instanceof ByteBufSerializer) {
                class_9129 buffer = new class_9129((ByteBuf)PacketByteBufs.create(), ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager());
                packetCodec.encode((Object)buffer, value);
                MinecraftEndecs.PACKET_BYTE_BUF.encode(ctx, serializer, (Object)buffer);
                return;
            }
            class_6903 ops = class_6903.method_40414((DynamicOps)EdmOps.withContext(ctx), (class_6903.class_7863)((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
            EdmEndec.INSTANCE.encode(ctx, serializer, (EdmElement)codec.encodeStart((DynamicOps)ops, value).getOrThrow(IllegalStateException::new));
        }, (ctx, deserializer) -> {
            if (deserializer instanceof ByteBufDeserializer) {
                class_2540 buffer = (class_2540)MinecraftEndecs.PACKET_BYTE_BUF.decode(ctx, deserializer);
                return packetCodec.decode((Object)new class_9129((ByteBuf)buffer, ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager()));
            }
            class_6903 ops = class_6903.method_40414((DynamicOps)EdmOps.withContext(ctx), (class_6903.class_7863)((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
            return codec.parse((DynamicOps)ops, (Object)EdmEndec.INSTANCE.decode(ctx, deserializer)).getOrThrow(IllegalStateException::new);
        });
    }

    public static <F, S> Endec<Either<F, S>> eitherEndec(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, false);
    }

    public static <F, S> Endec<Either<F, S>> xorEndec(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, true);
    }

    public static <T> Codec<T> toCodec(final Endec<T> endec, final SerializationContext assumedContext) {
        return new Codec<T>(){

            public <D> DataResult<Pair<T, D>> decode(DynamicOps<D> ops, D input) {
                return CodecUtils.captureThrows(() -> new Pair(endec.decode(CodecUtils.createContext(ops, assumedContext), (Deserializer)LenientEdmDeserializer.of((EdmElement)((EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), input)))), input));
            }

            public <D> DataResult<D> encode(T input, DynamicOps<D> ops, D prefix) {
                return CodecUtils.captureThrows(() -> EdmOps.withoutContext().convertTo(ops, (EdmElement)endec.encodeFully(CodecUtils.createContext(ops, assumedContext), EdmSerializer::of, input)));
            }
        };
    }

    public static <T> Codec<T> toCodec(Endec<T> endec) {
        return CodecUtils.toCodec(endec, SerializationContext.empty());
    }

    public static <T> MapCodec<T> toMapCodec(final StructEndec<T> structEndec, final SerializationContext assumedContext) {
        return new MapCodec<T>(){

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                throw new UnsupportedOperationException("MapCodec generated from StructEndec cannot report keys");
            }

            public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                return CodecUtils.captureThrows(() -> {
                    HashMap map = new HashMap();
                    input.entries().forEach(pair -> map.put((String)ops.getStringValue(pair.getFirst()).getOrThrow(s -> new IllegalStateException("Unable to parse key: " + s)), (EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), pair.getSecond())));
                    return structEndec.decode(CodecUtils.createContext(ops, assumedContext), (Deserializer)LenientEdmDeserializer.of((EdmElement)EdmElement.wrapMap(map)));
                });
            }

            public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                try {
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    Map element = (Map)((EdmElement)structEndec.encodeFully(context, EdmSerializer::of, input)).cast();
                    RecordBuilder result = prefix;
                    for (Map.Entry entry : element.entrySet()) {
                        result = result.add((String)entry.getKey(), EdmOps.withoutContext().convertTo(ops, (EdmElement)entry.getValue()));
                    }
                    return result;
                }
                catch (Exception e) {
                    return prefix.withErrorsFrom(DataResult.error(e::getMessage, input));
                }
            }
        };
    }

    public static <T> MapCodec<T> toMapCodec(StructEndec<T> structEndec) {
        return CodecUtils.toMapCodec(structEndec, SerializationContext.empty());
    }

    @Scary
    @ApiStatus.Experimental
    public static <T> StructEndec<T> toStructEndec(final MapCodec<T> mapCodec) {
        return new StructEndec<T>(){

            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
                EdmMap edmMap = ((EdmElement)mapCodec.encode(value, ops, ops.mapBuilder()).build((Object)((EdmElement)ops.emptyMap())).getOrThrow(IllegalStateException::new)).asMap();
                if (serializer instanceof SelfDescribedSerializer) {
                    ((Map)edmMap.value()).forEach((s, element) -> struct.field(s, ctx, (Endec)EdmEndec.INSTANCE, element));
                } else {
                    struct.field("element", ctx, EdmEndec.MAP, (Object)edmMap);
                }
            }

            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                EdmMap edmMap = deserializer instanceof SelfDescribedDeserializer ? (EdmMap)EdmEndec.MAP.decode(ctx, deserializer) : (EdmMap)struct.field("element", ctx, EdmEndec.MAP);
                DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
                return mapCodec.decode(ops, (MapLike)ops.getMap((Object)edmMap).getOrThrow(IllegalStateException::new)).getOrThrow(IllegalStateException::new);
            }
        };
    }

    public static <B extends class_2540, T> class_9139<B, T> toPacketCodec(final Endec<T> endec) {
        return new class_9139<B, T>(){

            public T decode(B buf) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                return endec.decode(ctx, (Deserializer)ByteBufDeserializer.of(buf));
            }

            public void encode(B buf, T value) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                endec.encode(ctx, (Serializer)ByteBufSerializer.of(buf), value);
            }
        };
    }

    public static SerializationContext createContext(DynamicOps<?> ops, SerializationContext assumedContext) {
        SerializationContext context;
        Object rootOps = ops;
        while (rootOps instanceof class_5379) {
            rootOps = ((ForwardingDynamicOpsAccessor)rootOps).owo$delegate();
        }
        if (rootOps instanceof EdmOps) {
            EdmOps edmOps = (EdmOps)rootOps;
            v0 = edmOps.capturedContext().and(assumedContext);
        } else {
            v0 = context = assumedContext;
        }
        if (ops instanceof class_6903) {
            class_6903 registryOps = (class_6903)ops;
            context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.tryFromCachedInfoGetter(((RegistryOpsAccessor)registryOps).owo$infoGetter())});
        }
        return context;
    }

    public static DynamicOps<EdmElement<?>> createEdmOps(SerializationContext ctx) {
        EdmOps ops = EdmOps.withContext(ctx);
        if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
            ops = class_6903.method_40414((DynamicOps)ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
        }
        return ops;
    }

    private static <T> DataResult<T> captureThrows(Supplier<T> action) {
        try {
            return DataResult.success(action.get());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }
}

