/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.client.features.heldItemTooltips;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.ContainerTooltip;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.EnchantmentTooltip;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.PotionTooltip;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.Tooltip;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1833;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class HeldItemTooltips {
    private final int tooltipSize = 6;

    public int drawItemWithCustomTooltips(class_332 drawContext, class_327 fontRenderer, class_2561 text, float x, float y, int color, class_1799 currentStack) {
        BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;
        int screenBorder = settings.getScreenSafeArea();
        int tooltipOffset = 0;
        class_746 player = class_310.method_1551().field_1724;
        if (null == player || null == class_310.method_1551().field_1761) {
            return 0;
        }
        if (class_310.method_1551().field_1761.method_2908()) {
            y -= 16.0f;
            if (player.method_6096() > 0) {
                y -= 10.0f;
            }
            if (player.method_6067() > 0.0f) {
                y -= 10.0f;
            }
        } else if (player.method_5854() != null && player.method_5854() instanceof class_1309) {
            y -= 16.0f;
        }
        if (settings.heldItemTooltips) {
            boolean showMoreTooltip;
            ArrayList tooltips = Lists.newArrayList();
            for (Tooltip tooltip : this.getTooltips(currentStack)) {
                tooltips.add(tooltip.getTooltipText());
            }
            boolean bl = showMoreTooltip = tooltips.size() > 6;
            if (showMoreTooltip) {
                int xMore = tooltips.size() - 5;
                tooltips.subList(5, tooltips.size()).clear();
                tooltips.add(class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{xMore}).method_27692(class_124.field_1080));
            }
            tooltipOffset = 12 * tooltips.size();
            int maxLength = this.getMaxTooltipLength(tooltips, fontRenderer, currentStack);
            this.renderBackground(drawContext, y, screenBorder, tooltipOffset, maxLength, color >> 24 & 0xFF);
            int i = tooltips.size() - 1;
            for (class_2561 elem : tooltips) {
                this.renderTooltip(drawContext, fontRenderer, y - (float)screenBorder - (float)(12 * i), color, (class_2561)((class_5250)elem).method_27692(class_124.field_1080));
                --i;
            }
        }
        return drawContext.method_27535(fontRenderer, text, (int)x, (int)(y - (float)tooltipOffset - (float)screenBorder), color);
    }

    public List<Tooltip> getTooltips(class_1799 currentStack) {
        class_9276 container;
        class_1792 item = currentStack.method_7909();
        ArrayList result = Lists.newArrayList();
        if (item == class_1802.field_8598 || currentStack.method_7942()) {
            class_9304 enchantmentsComponent = class_1890.method_57532((class_1799)currentStack);
            enchantmentsComponent.method_57534().forEach(enchantment -> result.add(new EnchantmentTooltip((class_1887)enchantment.comp_349(), enchantmentsComponent.method_57536(enchantment))));
        } else if (item instanceof class_1812 || item instanceof class_1833) {
            ArrayList generated = Lists.newArrayList();
            item.method_7851(currentStack, class_1792.class_9635.field_51353, (List)generated, (class_1836)class_1836.field_41070);
            HeldItemTooltips.generateTooltipsForPotion(generated, result);
        } else if (currentStack.method_57353().method_57832(class_9334.field_49622)) {
            class_9288 container2 = (class_9288)currentStack.method_57353().method_57829(class_9334.field_49622);
            if (container2 != null) {
                HeldItemTooltips.generateTooltipsFromContainer(container2.method_57489().toList(), result);
            }
        } else if (currentStack.method_57353().method_57832(class_9334.field_49650) && (container = (class_9276)currentStack.method_57353().method_57829(class_9334.field_49650)) != null) {
            HeldItemTooltips.generateTooltipsFromContainer(container.method_59707().toList(), result);
        }
        return result;
    }

    public boolean equals(class_1799 item1, class_1799 item2) {
        List<Tooltip> itemTooltips1 = this.getTooltips(item1);
        List<Tooltip> itemTooltips2 = this.getTooltips(item2);
        return Objects.equals(itemTooltips1, itemTooltips2);
    }

    private static void generateTooltipsFromContainer(List<class_1799> items, List<Tooltip> instance) {
        for (class_1799 item : items) {
            if (item.method_7960()) continue;
            instance.add(new ContainerTooltip(item));
        }
    }

    private static void generateTooltipsForPotion(List<class_2561> texts, List<Tooltip> instance) {
        int startIndex = texts.indexOf(class_5244.field_39003);
        if (startIndex > 0) {
            texts.subList(startIndex, texts.size()).clear();
        }
        texts.forEach(current -> instance.add(new PotionTooltip((class_2561)current)));
    }

    private void renderBackground(class_332 drawContext, float y, int screenBorder, int tooltipOffset, int maxLength, int alpha) {
        class_310 client = class_310.method_1551();
        int background = class_3532.method_48781((float)((float)alpha / 255.0f), (int)0, (int)class_3532.method_15384((double)(255.0 * BedrockifyClient.getInstance().settings.heldItemTooltipBackground))) << 24;
        drawContext.method_25294(class_3532.method_15386((float)((float)(client.method_22683().method_4486() - maxLength) / 2.0f - 3.0f)), class_3532.method_15386((float)(y - (float)tooltipOffset - 5.0f - (float)screenBorder)), class_3532.method_15386((float)((float)(client.method_22683().method_4486() + maxLength) / 2.0f + 1.0f)), class_3532.method_15386((float)(y - (float)tooltipOffset - 4.0f - (float)screenBorder)), background);
        drawContext.method_25294(class_3532.method_15386((float)((float)(client.method_22683().method_4486() - maxLength) / 2.0f - 3.0f)), class_3532.method_15386((float)(y + 12.0f - (float)screenBorder)), class_3532.method_15386((float)((float)(client.method_22683().method_4486() + maxLength) / 2.0f + 1.0f)), class_3532.method_15386((float)(y + 13.0f - (float)screenBorder)), background);
        drawContext.method_25294(class_3532.method_15386((float)((float)(client.method_22683().method_4486() - maxLength) / 2.0f - 4.0f)), class_3532.method_15386((float)(y - (float)tooltipOffset - 4.0f - (float)screenBorder)), class_3532.method_15386((float)((float)(client.method_22683().method_4486() + maxLength) / 2.0f + 2.0f)), class_3532.method_15386((float)(y + 12.0f - (float)screenBorder)), background);
    }

    private void renderTooltip(class_332 drawContext, class_327 fontRenderer, float y, int color, class_2561 text) {
        int enchantX = (class_310.method_1551().method_22683().method_4486() - fontRenderer.method_27525((class_5348)text)) / 2;
        drawContext.method_27535(fontRenderer, text, enchantX, (int)y, color);
    }

    private int getMaxTooltipLength(List<class_2561> tooltips, class_327 textRenderer, class_1799 itemStack) {
        int maxLength = textRenderer.method_27525((class_5348)itemStack.method_7964());
        for (class_2561 elem : tooltips) {
            int tipLength = textRenderer.method_27525((class_5348)elem);
            if (maxLength >= tipLength) continue;
            maxLength = tipLength;
        }
        return maxLength;
    }
}

