/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.platform;

import de.cech12.usefulhats.platform.services.IConfigHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;

@Config(name="usefulhats")
public class FabricConfigHelper
implements ConfigData,
IConfigHelper {
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public AquanautHelmet AQUANAUT_HELMET = new AquanautHelmet();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public BunnyEars BUNNY_EARS = new BunnyEars();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public ChoppingHat CHOPPING_HAT = new ChoppingHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public EnderHelmet ENDER_HELMET = new EnderHelmet();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public Halo HALO = new Halo();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public LuckyHat LUCKY_HAT = new LuckyHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public MiningHat MINING_HAT = new MiningHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public MushroomHat MUSHROOM_HAT = new MushroomHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public PostmanHat POSTMAN_HAT = new PostmanHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public ShulkerHelmet SHULKER_HELMET = new ShulkerHelmet();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public StockingCap STOCKING_CAP = new StockingCap();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public StrawHat STRAW_HAT = new StrawHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public WingHelmet WING_HELMET = new WingHelmet();

    @Override
    public void init() {
        AutoConfig.register(FabricConfigHelper.class, Toml4jConfigSerializer::new);
    }

    private FabricConfigHelper getConfig() {
        return (FabricConfigHelper)AutoConfig.getConfigHolder(FabricConfigHelper.class).getConfig();
    }

    private int getInteger(long config) {
        return (int)config;
    }

    private int getEnchantmentInteger(int enchantmentLevel, long config0, long config1, long config2, long config3, long config4, long config5) {
        if (enchantmentLevel < 0) {
            return this.getInteger(config0);
        }
        return this.getInteger(switch (enchantmentLevel) {
            case 0 -> config0;
            case 1 -> config1;
            case 2 -> config2;
            case 3 -> config3;
            case 4 -> config4;
            default -> config5;
        });
    }

    private double getDouble(long config) {
        return (double)config / 100.0;
    }

    private double getEnchantmentDouble(int enchantmentLevel, long config0, long config1, long config2, long config3, long config4, long config5) {
        if (enchantmentLevel < 0) {
            return this.getDouble(config0);
        }
        return this.getDouble(switch (enchantmentLevel) {
            case 0 -> config0;
            case 1 -> config1;
            case 2 -> config2;
            case 3 -> config3;
            case 4 -> config4;
            default -> config5;
        });
    }

    @Override
    public boolean isAquanautHelmetDamageEnabled() {
        return this.getConfig().AQUANAUT_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getAquanautHelmetDurability() {
        return this.getInteger(this.getConfig().AQUANAUT_HELMET.DURABILITY);
    }

    @Override
    public int getAquanautHelmetEffectTimeWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentInteger(enchantmentLevel, config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_0, config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_1, config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_2, config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_3, config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_4, config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_5);
    }

    @Override
    public boolean isBunnyEarsDamageEnabled() {
        return this.getConfig().BUNNY_EARS.DAMAGE_ENABLED;
    }

    @Override
    public int getBunnyEarsDurability() {
        return this.getInteger(this.getConfig().getConfig().BUNNY_EARS.DURABILITY);
    }

    @Override
    public boolean isChoppingHatDamageEnabled() {
        return this.getConfig().CHOPPING_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getChoppingHatDurability() {
        return this.getInteger(this.getConfig().CHOPPING_HAT.DURABILITY);
    }

    @Override
    public double getChoppingHatSpeedWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentDouble(enchantmentLevel, config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_0, config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_1, config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_2, config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_3, config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_4, config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_5);
    }

    @Override
    public boolean isEnderHelmetDamageEnabled() {
        return this.getConfig().ENDER_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getEnderHelmetDurability() {
        return this.getInteger(this.getConfig().ENDER_HELMET.DURABILITY);
    }

    @Override
    public boolean isEnderHelmetInterdimensionalEnabled() {
        return this.getConfig().ENDER_HELMET.INTERDIMENSIONAL_ENABLED;
    }

    @Override
    public boolean isHaloDamageEnabled() {
        return this.getConfig().HALO.DAMAGE_ENABLED;
    }

    @Override
    public int getHaloDurability() {
        return this.getInteger(this.getConfig().HALO.DURABILITY);
    }

    @Override
    public boolean isLuckyHatDamageEnabled() {
        return this.getConfig().LUCKY_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getLuckyHatDurability() {
        return this.getInteger(this.getConfig().LUCKY_HAT.DURABILITY);
    }

    @Override
    public boolean isLuckyHatUnluckEnabled() {
        return this.getConfig().LUCKY_HAT.UNLUCK_ENABLED;
    }

    @Override
    public boolean isMiningHatDamageEnabled() {
        return this.getConfig().MINING_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getMiningHatDurability() {
        return this.getInteger(this.getConfig().MINING_HAT.DURABILITY);
    }

    @Override
    public boolean isMiningHatNightVisionEnabled() {
        return this.getConfig().MINING_HAT.NIGHT_VISION_ENABLED;
    }

    @Override
    public boolean isMiningHatMakePiglinsNeutralEnabled() {
        return this.getConfig().MINING_HAT.MAKE_PIGLINS_NEUTRAL_ENABLED;
    }

    @Override
    public double getMiningHatSpeedWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentDouble(enchantmentLevel, config.MINING_HAT.SPEED_WITH_EFFICIENCY_0, config.MINING_HAT.SPEED_WITH_EFFICIENCY_1, config.MINING_HAT.SPEED_WITH_EFFICIENCY_2, config.MINING_HAT.SPEED_WITH_EFFICIENCY_3, config.MINING_HAT.SPEED_WITH_EFFICIENCY_4, config.MINING_HAT.SPEED_WITH_EFFICIENCY_5);
    }

    @Override
    public boolean isMushroomHatDamageEnabled() {
        return this.getConfig().MUSHROOM_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getMushroomHatDurability() {
        return this.getInteger(this.getConfig().MUSHROOM_HAT.DURABILITY);
    }

    @Override
    public int getMushroomHatEatInterval() {
        return this.getInteger(this.getConfig().MUSHROOM_HAT.EAT_INTERVAL);
    }

    @Override
    public boolean isPostmanHatDamageEnabled() {
        return this.getConfig().POSTMAN_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getPostmanHatDurability() {
        return this.getInteger(this.getConfig().POSTMAN_HAT.DURABILITY);
    }

    @Override
    public boolean isPostmanHatHungerEnabled() {
        return this.getConfig().POSTMAN_HAT.HUNGER_ENABLED;
    }

    @Override
    public boolean isShulkerHelmetDamageEnabled() {
        return this.getConfig().SHULKER_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getShulkerHelmetDurability() {
        return this.getInteger(this.getConfig().SHULKER_HELMET.DURABILITY);
    }

    @Override
    public boolean isStockingCapDamageEnabled() {
        return this.getConfig().STOCKING_CAP.DAMAGE_ENABLED;
    }

    @Override
    public int getStockingCapDurability() {
        return this.getInteger(this.getConfig().STOCKING_CAP.DURABILITY);
    }

    @Override
    public boolean isStrawHatDamageEnabled() {
        return this.getConfig().STRAW_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getStrawHatDurability() {
        return this.getInteger(this.getConfig().STRAW_HAT.DURABILITY);
    }

    @Override
    public double getStrawHatSpeedWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentDouble(enchantmentLevel, config.STRAW_HAT.SPEED_WITH_EFFICIENCY_0, config.STRAW_HAT.SPEED_WITH_EFFICIENCY_1, config.STRAW_HAT.SPEED_WITH_EFFICIENCY_2, config.STRAW_HAT.SPEED_WITH_EFFICIENCY_3, config.STRAW_HAT.SPEED_WITH_EFFICIENCY_4, config.STRAW_HAT.SPEED_WITH_EFFICIENCY_5);
    }

    @Override
    public boolean isWingHelmetDamageEnabled() {
        return this.getConfig().WING_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getWingHelmetDurability() {
        return this.getInteger(this.getConfig().WING_HELMET.DURABILITY);
    }

    @Override
    public boolean isWingHelmetLevitationEnabled() {
        return this.getConfig().WING_HELMET.LEVITATION_ENABLED;
    }

    public static final class AquanautHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 600L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=10L, max=120L)
        public long EFFECT_TIME_WITH_EFFICIENCY_0 = 60L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=10L, max=180L)
        public long EFFECT_TIME_WITH_EFFICIENCY_1 = 120L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=10L, max=240L)
        public long EFFECT_TIME_WITH_EFFICIENCY_2 = 180L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=10L, max=300L)
        public long EFFECT_TIME_WITH_EFFICIENCY_3 = 240L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=10L, max=360L)
        public long EFFECT_TIME_WITH_EFFICIENCY_4 = 300L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=10L, max=420L)
        public long EFFECT_TIME_WITH_EFFICIENCY_5 = 360L;

        private AquanautHelmet() {
        }
    }

    public static final class BunnyEars
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 450L;

        private BunnyEars() {
        }
    }

    public static final class ChoppingHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 300L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_0 = 20L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_1 = 40L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_2 = 60L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_3 = 80L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_4 = 100L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_5 = 150L;

        private ChoppingHat() {
        }
    }

    public static final class EnderHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 80L;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean INTERDIMENSIONAL_ENABLED = true;

        private EnderHelmet() {
        }
    }

    public static final class Halo
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 600L;
    }

    public static final class LuckyHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 300L;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean UNLUCK_ENABLED = true;

        private LuckyHat() {
        }
    }

    public static final class MiningHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 450L;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean NIGHT_VISION_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean MAKE_PIGLINS_NEUTRAL_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_0 = 20L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_1 = 40L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_2 = 60L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_3 = 80L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_4 = 100L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_5 = 150L;

        private MiningHat() {
        }
    }

    public static final class MushroomHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 80L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long EAT_INTERVAL = 60L;

        private MushroomHat() {
        }
    }

    public static final class PostmanHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 600L;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean HUNGER_ENABLED = true;

        private PostmanHat() {
        }
    }

    public static final class ShulkerHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 600L;

        private ShulkerHelmet() {
        }
    }

    public static final class StockingCap
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 600L;

        private StockingCap() {
        }
    }

    public static final class StrawHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 300L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_0 = 20L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_1 = 40L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_2 = 60L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_3 = 80L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_4 = 100L;
        @ConfigEntry.Gui.Tooltip(count=4)
        @ConfigEntry.BoundedDiscrete(min=0L, max=500L)
        public long SPEED_WITH_EFFICIENCY_5 = 150L;

        private StrawHat() {
        }
    }

    public static final class WingHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.BoundedDiscrete(min=1L, max=10000L)
        public long DURABILITY = 600L;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean LEVITATION_ENABLED = true;

        private WingHelmet() {
        }
    }
}

