/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class PostmanHatItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final int HUNGER_AMPLIFIER = 0;
    private static final int HUNGER_DURATION = 219;
    private static final int SPEED_DURATION = 219;

    public PostmanHatItem() {
        super(HatArmorMaterials.POSTMAN, PostmanHatItem.rawColorFromRGB(57, 99, 150), Services.CONFIG::getPostmanHatDurability, Services.CONFIG::isPostmanHatDamageEnabled);
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, context, tooltip, flagIn);
        int enchantmentLevel = CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131) + 1;
        tooltip.add((class_2561)class_2561.method_43469((String)"item.usefulhats.postman_hat.desc.speed", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).method_27692(class_124.field_1078));
        if (Services.CONFIG.isPostmanHatHungerEnabled()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.usefulhats.postman_hat.desc.hunger").method_27692(class_124.field_1061));
        }
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slot, boolean selectedIndex) {
        if (!level.field_9236 && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int speedAmplifier = CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131);
            if (this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5904, 219, speedAmplifier)) {
                return;
            }
            if (livingEntity.method_5624()) {
                if (livingEntity.method_6112(class_1294.field_5904) == null || livingEntity.field_6012 % 19 == 0) {
                    this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5904, 219, speedAmplifier);
                }
                if (Services.CONFIG.isPostmanHatHungerEnabled() && !this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5903, 219, 0) && (livingEntity.method_6112(class_1294.field_5903) == null || livingEntity.field_6012 % 19 == 0)) {
                    this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5903, 219, 0);
                }
                if (livingEntity.field_6012 % 20 == 0) {
                    this.damageHatItemByOne(stack, livingEntity);
                }
            } else {
                this.removeEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5904, 219, speedAmplifier);
                if (Services.CONFIG.isPostmanHatHungerEnabled()) {
                    this.removeEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5903, 219, 0);
                }
            }
        }
    }

    @Override
    public void onUnequippedHatItem(class_1309 entity, class_1799 oldStack) {
        int speedAmplifier = CommonLoader.getEnchantmentLevel(oldStack, (class_5321<class_1887>)class_1893.field_9131);
        this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5904, 219, speedAmplifier);
        if (Services.CONFIG.isPostmanHatHungerEnabled()) {
            this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5903, 219, 0);
        }
    }
}

