/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.client;

import com.google.common.collect.Maps;
import de.cech12.usefulhats.Constants;
import de.cech12.usefulhats.client.UsefulHatModel;
import de.cech12.usefulhats.item.AbstractHatItem;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_918;
import net.minecraft.class_9282;

public abstract class AbstractUsefulHatsRenderer {
    public static final class_5601 USEFUL_HAT_LAYER = new class_5601(Constants.id("usefulhat_layer"), "main");
    private static final Map<String, class_2960> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private static final boolean IS_CHRISTMAS = Calendar.getInstance().get(2) + 1 == 12;
    private static final int WHITE = class_5253.class_5254.method_59554((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    private class_572<class_1309> usefulHatModel;

    public void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_572<class_1309> model = this.getModel(stack);
        model.method_17087(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        model.method_17086(entity, limbAngle, limbDistance, tickDelta);
        this.render(stack, matrices, vertexConsumers, light, entity, model);
    }

    public void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 entity) {
        this.render(stack, matrices, vertexConsumers, light, entity, this.getModel(stack));
    }

    private void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 entity, class_572<class_1309> model) {
        class_1792 item = stack.method_7909();
        this.followBodyRotations(entity, model);
        boolean flag1 = stack.method_7958();
        int color = stack.method_31573(class_3489.field_48803) ? class_9282.method_57470((class_1799)stack, (int)((AbstractHatItem)stack.method_7909()).getDefaultColor()) : ((AbstractHatItem)stack.method_7909()).getDefaultColor();
        for (class_1741.class_9196 layer : ((class_1741)((class_1738)item).method_7686().comp_349()).comp_2302()) {
            if (layer.method_56692()) {
                this.renderLayer(matrices, vertexConsumers, light, flag1, model, color, this.getTexture((class_1738)stack.method_7909(), layer));
                continue;
            }
            this.renderLayer(matrices, vertexConsumers, light, flag1, model, WHITE, this.getTexture((class_1738)stack.method_7909(), layer));
        }
        if (stack.method_7958()) {
            this.renderGlint(matrices, vertexConsumers, light, model);
        }
    }

    protected abstract void followBodyRotations(class_1309 var1, class_572<class_1309> var2);

    private void renderLayer(class_4587 poseStack, class_4597 multiBufferSource, int light, boolean bl, class_572<class_1309> humanoidModel, int color, class_2960 armorResource) {
        class_4588 vertexConsumer = class_918.method_23181((class_4597)multiBufferSource, (class_1921)humanoidModel.method_23500(armorResource), (boolean)false, (boolean)bl);
        humanoidModel.method_2828(poseStack, vertexConsumer, light, class_4608.field_21444, color);
    }

    private void renderGlint(class_4587 poseStack, class_4597 multiBufferSource, int light, class_572<class_1309> humanoidModel) {
        humanoidModel.method_2828(poseStack, multiBufferSource.getBuffer(class_1921.method_27949()), light, class_4608.field_21444, WHITE);
    }

    private class_572<class_1309> getModel(class_1799 stack) {
        if (this.usefulHatModel == null) {
            this.usefulHatModel = new UsefulHatModel<class_1309>(class_310.method_1551().method_31974().method_32072(USEFUL_HAT_LAYER));
        }
        return this.usefulHatModel;
    }

    private class_2960 getTexture(class_1738 armorItem, class_1741.class_9196 layer) {
        class_2960 location = AbstractUsefulHatsRenderer.getArmorTexture(armorItem, layer);
        return ARMOR_TEXTURE_RES_MAP.computeIfAbsent(location.toString(), k -> location);
    }

    public static class_2960 getArmorTexture(class_1738 armorItem, class_1741.class_9196 layer) {
        class_2960 location = layer.method_56693(false);
        return location.method_45136(String.format("%s%s.png", location.method_12832().replace("_layer_1", "").replace(".png", ""), IS_CHRISTMAS && ((AbstractHatItem)armorItem).hasChristmasVariant() ? "_xmas" : ""));
    }
}

