/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9290;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class TerminalSyncManager {
    private static final int MAX_PACKET_SIZE = 64000;
    private Object2IntMap<StoredItemStack> idMap = new Object2IntOpenHashMap();
    private Int2ObjectMap<StoredItemStack> idMap2 = new Int2ObjectArrayMap();
    private Map<StoredItemStack, StoredItemStack> items = new HashMap<StoredItemStack, StoredItemStack>();
    private Map<StoredItemStack, StoredItemStack> itemList = new HashMap<StoredItemStack, StoredItemStack>();
    private int lastId = 1;
    private int lastChangeID = -1;
    private class_9129 workBuf;

    public TerminalSyncManager(class_5455 reg) {
        this.workBuf = Platform.makeRegByteBuf(Unpooled.buffer((int)64000, (int)128000), reg);
    }

    private void write(class_9129 buf, StoredItemStack stack) {
        class_1799 st = stack.getStack();
        class_1792 item = st.method_7909();
        class_9326 components = st.method_57380();
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | (!components.method_57848() ? 2 : 0));
        boolean wr = true;
        int id = this.idMap.getInt((Object)stack);
        if (id != 0) {
            flags = (byte)(flags | 4);
            wr = false;
        }
        buf.method_52997((int)flags);
        buf.method_10804(this.idMap.computeIfAbsent((Object)stack, s -> {
            int i = this.lastId++;
            this.idMap2.put(i, (Object)((StoredItemStack)s));
            return i;
        }));
        if (wr) {
            buf.method_10804(class_7923.field_41178.method_10206((Object)item));
        }
        if (stack.getQuantity() != 0L) {
            buf.method_10791(stack.getQuantity());
        }
        if (wr && !components.method_57848()) {
            class_9326.field_49590.encode((Object)buf, (Object)components);
        }
    }

    private void writeMiniStack(class_9129 buf, StoredItemStack stack) {
        int id = this.idMap.getInt((Object)stack);
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | 2);
        buf.method_52997((int)flags);
        buf.method_10804(id);
        buf.method_10804(class_7923.field_41178.method_10206((Object)stack.getStack().method_7909()));
        if (stack.getQuantity() != 0L) {
            buf.method_10791(stack.getQuantity());
        }
        class_9326 tag = class_9326.method_57841().method_57854(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43471((String)"tooltip.toms_storage.nbt_overflow").method_27692(class_124.field_1061)))).method_57852();
        class_9326.field_49590.encode((Object)buf, (Object)tag);
    }

    private StoredItemStack read(class_9129 buf) {
        byte flags = buf.readByte();
        int id = buf.method_10816();
        boolean rd = (flags & 4) == 0;
        StoredItemStack stack = rd ? new StoredItemStack(new class_1799((class_1935)class_7923.field_41178.method_10200(buf.method_10816()))) : new StoredItemStack(((StoredItemStack)this.idMap2.get(id)).getStack());
        long count = (flags & 1) != 0 ? 0L : buf.method_10792();
        stack.setCount(count);
        if (rd && (flags & 2) != 0) {
            class_9326 dataComponentPatch = (class_9326)class_9326.field_49590.decode((Object)buf);
            stack.getStack().method_57366(dataComponentPatch);
        }
        this.idMap.put((Object)stack, id);
        this.idMap2.put(id, (Object)stack);
        return stack;
    }

    public void update(int changeID, Map<StoredItemStack, StoredItemStack> items, class_3222 player, Consumer<class_2487> extraSync) {
        if (changeID != this.lastChangeID) {
            this.lastChangeID = changeID;
            ArrayList toWrite = new ArrayList();
            HashSet found = new HashSet();
            items.forEach((s, c) -> {
                StoredItemStack pc = this.items.get(s);
                if (pc != null) {
                    found.add(s);
                }
                if (pc == null || !c.equalDetails(pc)) {
                    toWrite.add(c);
                }
            });
            this.items.forEach((s, c) -> {
                if (!found.contains(s)) {
                    toWrite.add(new StoredItemStack(s.getStack(), 0L));
                }
            });
            this.items.clear();
            this.items.putAll(items);
            if (!toWrite.isEmpty()) {
                this.workBuf.method_52990(0);
                int j = 0;
                int i = 0;
                while (i < toWrite.size()) {
                    StoredItemStack stack = (StoredItemStack)toWrite.get(i);
                    int li = this.workBuf.writerIndex();
                    try {
                        this.write(this.workBuf, stack);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.workBuf.method_52990(li);
                        this.writeMiniStack(this.workBuf, stack);
                    }
                    int s2 = this.workBuf.writerIndex();
                    if ((s2 > 64000 || j > 32000) && j > 1) {
                        class_2487 t = this.writeBuf("d", (class_2540)this.workBuf, li);
                        t.method_10575("l", (short)j);
                        NetworkHandler.sendTo(player, t);
                        j = 0;
                        this.workBuf.method_52990(0);
                        if (s2 - li > 64000) {
                            this.writeMiniStack(this.workBuf, stack);
                        } else {
                            this.workBuf.method_52977((ByteBuf)this.workBuf, li, s2 - li);
                        }
                    }
                    ++i;
                    ++j;
                }
                if (j > 0 || extraSync != null) {
                    class_2487 t;
                    if (j > 0) {
                        t = this.writeBuf("d", (class_2540)this.workBuf, this.workBuf.writerIndex());
                        t.method_10575("l", (short)j);
                    } else {
                        t = new class_2487();
                    }
                    if (extraSync != null) {
                        extraSync.accept(t);
                    }
                    NetworkHandler.sendTo(player, t);
                    return;
                }
            }
        }
        if (extraSync != null) {
            class_2487 t = new class_2487();
            extraSync.accept(t);
            NetworkHandler.sendTo(player, t);
        }
    }

    public boolean receiveUpdate(class_5455 registryAccess, class_2487 tag) {
        if (tag.method_10545("d")) {
            class_9129 buf = Platform.makeRegByteBuf(Unpooled.wrappedBuffer((byte[])tag.method_10547("d")), registryAccess);
            ArrayList<StoredItemStack> in = new ArrayList<StoredItemStack>();
            int len = tag.method_10568("l");
            for (int i = 0; i < len; ++i) {
                in.add(this.read(buf));
            }
            in.forEach(s -> {
                if (s.getQuantity() == 0L) {
                    this.itemList.remove(s);
                } else {
                    this.itemList.put((StoredItemStack)s, (StoredItemStack)s);
                }
            });
            return true;
        }
        return false;
    }

    public void sendInteract(StoredItemStack intStack, SlotAction action, boolean mod) {
        int flags;
        class_2540 buf = new class_2540(Unpooled.buffer());
        int n = flags = mod ? 1 : 0;
        if (intStack == null) {
            buf.method_52997(flags | 2);
        } else {
            buf.method_52997(flags);
            buf.method_10804(this.idMap.getInt((Object)intStack));
            buf.method_10791(intStack.getQuantity());
        }
        buf.method_10817((Enum)action);
        NetworkHandler.sendDataToServer(this.writeBuf("a", buf, buf.writerIndex()));
    }

    private class_2487 writeBuf(String id, class_2540 buf, int len) {
        byte[] data = new byte[len];
        buf.method_52952(0, data);
        class_2487 tag = new class_2487();
        tag.method_10570(id, data);
        return tag;
    }

    public void receiveInteract(class_2487 tag, InteractHandler handler) {
        if (tag.method_10545("a")) {
            StoredItemStack stack;
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])tag.method_10547("a")));
            byte flags = buf.readByte();
            if ((flags & 2) != 0) {
                stack = null;
            } else {
                stack = new StoredItemStack(((StoredItemStack)this.idMap2.get(buf.method_10816())).getStack());
                long count = buf.method_10792();
                stack.setCount(count);
            }
            handler.onInteract(stack, (SlotAction)buf.method_10818(SlotAction.class), (flags & 1) != 0);
        }
    }

    public List<StoredItemStack> getAsList() {
        return new ArrayList<StoredItemStack>(this.itemList.values());
    }

    public void fillStackedContents(class_1662 stc) {
        this.items.forEach((s, c) -> stc.method_7404(c.getActualStack()));
    }

    public long getAmount(StoredItemStack stack) {
        StoredItemStack s = this.itemList.get(stack);
        return s != null ? s.getQuantity() : 0L;
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER,
        CRAFT;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }

    public static interface InteractHandler {
        public void onInteract(StoredItemStack var1, SlotAction var2, boolean var3);
    }
}

