/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.Config;
import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import com.tom.storagemod.util.Priority;
import com.tom.storagemod.util.WorldStates;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public abstract class MultiInventoryAccess
implements IInventoryAccess {
    protected List<IInventoryAccess> connected = new ArrayList<IInventoryAccess>();
    protected MultiChangeTracker tracker = new MultiChangeTracker();

    public MultiInventoryAccess() {
        WorldStates.trackers.put((Storage<ItemVariant>)((Storage)this.getPlatformHandler()), this.tracker());
    }

    public void build(IInventoryConnector self, Collection<IInventoryConnector> connectors) {
        this.connected.clear();
        ArrayDeque<IInventoryConnector> q = new ArrayDeque<IInventoryConnector>();
        q.add(self);
        q.addAll(connectors);
        HashSet<IInventoryConnector> all = new HashSet<IInventoryConnector>();
        while (!q.isEmpty()) {
            IInventoryConnector ic = (IInventoryConnector)q.poll();
            if (!all.add(ic)) continue;
            q.addAll(ic.getConnectedConnectors());
        }
        EnumMap map = all.stream().flatMap(c -> c.getConnectedInventories().stream()).collect(Collectors.groupingBy(Priority.IPriority.GETTER, () -> new EnumMap(Priority.class), Collectors.toList()));
        HashSet<IInventoryAccess> allRoots = new HashSet<IInventoryAccess>();
        allRoots.add(this);
        for (int i = Priority.VALUES.length - 1; i >= 0; --i) {
            for (IInventoryAccess a : map.getOrDefault((Object)Priority.VALUES[i], Collections.emptyList())) {
                IInventoryAccess root = a.getRootHandler();
                if (root instanceof MultiInventoryAccess || !allRoots.add(root)) continue;
                this.connected.add(a);
            }
        }
        this.refresh();
    }

    @Override
    public class_1799 pullMatchingStack(class_1799 st, long max) {
        class_1799 res = class_1799.field_8037;
        int c = 0;
        for (int i = 0; i < this.connected.size(); ++i) {
            class_1799 p = this.connected.get(i).pullMatchingStack(st, max - (long)c);
            if (p.method_7960()) continue;
            if (res.method_7960()) {
                res = p;
            }
            if ((long)(c += p.method_7947()) >= max) break;
        }
        res.method_7939(c);
        return res;
    }

    @Override
    public class_1799 pushStack(class_1799 stack) {
        for (int i = 0; i < this.connected.size(); ++i) {
            stack = this.connected.get(i).pushStack(stack);
            if (!stack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    @Override
    public IInventoryAccess.IInventoryChangeTracker tracker() {
        return this.tracker;
    }

    @Override
    public int getFreeSlotCount() {
        int c = 0;
        for (int i = 0; i < this.connected.size(); ++i) {
            c += this.connected.get(i).getFreeSlotCount();
        }
        return c;
    }

    @Override
    public int getSlotCount() {
        int c = 0;
        for (int i = 0; i < this.connected.size(); ++i) {
            c += this.connected.get(i).getSlotCount();
        }
        return c;
    }

    public void clear() {
        this.connected.clear();
    }

    public int getInventoryCount() {
        return this.connected.size();
    }

    protected void refresh() {
    }

    @Override
    public IInventoryAccess getRootHandler() {
        return this;
    }

    public Collection<IInventoryAccess> getConnected() {
        return this.connected;
    }

    protected class MultiChangeTracker
    implements IInventoryAccess.IInventoryChangeTracker {
        private long lastUpdate;
        private long lastChange;
        private long[] trackers = new long[0];
        private ItemList[] items = new ItemList[0];

        protected MultiChangeTracker() {
        }

        private boolean multithreadProcessing(class_1937 level) {
            int size = MultiInventoryAccess.this.connected.size();
            ArrayList<TrackerInfo> infos = new ArrayList<TrackerInfo>(size);
            boolean ch = false;
            for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                IInventoryAccess.IMultiThreadedTracker mt;
                Object prep;
                IInventoryAccess.IInventoryChangeTracker iInventoryChangeTracker = MultiInventoryAccess.this.connected.get(i).tracker();
                if (iInventoryChangeTracker instanceof IInventoryAccess.IMultiThreadedTracker && (prep = (mt = (IInventoryAccess.IMultiThreadedTracker)((Object)iInventoryChangeTracker)).prepForOffThread(level)) != null) {
                    infos.add(new TrackerInfo(i, mt, prep));
                    continue;
                }
                long v = iInventoryChangeTracker.getChangeTracker(level);
                if (v == this.trackers[i]) continue;
                ch |= true;
                this.items[i] = null;
                this.trackers[i] = v;
            }
            ((Stream)infos.parallelStream().unordered()).peek(TrackerInfo::run).toArray();
            for (TrackerInfo trackerInfo : infos) {
                trackerInfo.finish(level);
                long v = trackerInfo.tracker;
                int i = trackerInfo.id;
                if (v == this.trackers[i]) continue;
                ch |= true;
                this.items[i] = null;
                this.trackers[i] = v;
            }
            return ch;
        }

        @Override
        public long getChangeTracker(class_1937 level) {
            if (this.lastUpdate != level.method_8510()) {
                if (this.trackers.length != MultiInventoryAccess.this.connected.size()) {
                    this.trackers = new long[MultiInventoryAccess.this.connected.size()];
                    this.items = new ItemList[MultiInventoryAccess.this.connected.size()];
                    for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                        IInventoryAccess.IInventoryChangeTracker tr = MultiInventoryAccess.this.connected.get(i).tracker();
                        this.trackers[i] = tr.getChangeTracker(level);
                    }
                    this.lastChange = System.nanoTime();
                    return this.lastChange;
                }
                boolean ch = false;
                if (Config.get().runMultithreaded) {
                    ch = this.multithreadProcessing(level);
                } else {
                    for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                        IInventoryAccess ia = MultiInventoryAccess.this.connected.get(i);
                        long v = ia.tracker().getChangeTracker(level);
                        if (v == this.trackers[i]) continue;
                        ch |= true;
                        this.items[i] = null;
                        this.trackers[i] = v;
                    }
                }
                if (ch) {
                    this.lastChange = System.nanoTime();
                }
                this.lastUpdate = level.method_8510();
            }
            return this.lastChange;
        }

        @Override
        public Stream<StoredItemStack> streamWrappedStacks(boolean parallel) {
            Stream<ItemList> str = IntStream.range(0, this.items.length).mapToObj(i -> {
                if (this.items[i] == null) {
                    this.items[i] = MultiInventoryAccess.this.connected.get(i).tracker().streamWrappedStacks(false).collect(Collectors.toCollection(ItemList::new));
                }
                return this.items[i];
            });
            if (parallel) {
                return (Stream)str.toList().parallelStream().flatMap(Collection::parallelStream).unordered();
            }
            return str.flatMap(Collection::stream);
        }

        @Override
        public long countItems(StoredItemStack filter) {
            long c = 0L;
            for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                IInventoryAccess ia = MultiInventoryAccess.this.connected.get(i);
                c += ia.tracker().countItems(filter);
            }
            return c;
        }

        @Override
        public InventorySlot findSlot(ItemPredicate filter, boolean findEmpty) {
            for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                IInventoryAccess ia = MultiInventoryAccess.this.connected.get(i);
                InventorySlot is = ia.tracker().findSlot(filter, findEmpty);
                if (is == null) continue;
                return is;
            }
            return null;
        }

        @Override
        public InventorySlot findSlotDest(StoredItemStack forStack) {
            for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                IInventoryAccess ia = MultiInventoryAccess.this.connected.get(i);
                InventorySlot is = ia.tracker().findSlotDest(forStack);
                if (is == null) continue;
                return is;
            }
            return null;
        }

        @Override
        public InventorySlot findSlotAfter(InventorySlot slot, ItemPredicate filter, boolean findEmpty, boolean loop) {
            for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                IInventoryAccess ia = MultiInventoryAccess.this.connected.get(i);
                InventorySlot is = ia.tracker().findSlotAfter(slot, filter, findEmpty, loop);
                if (is == null) continue;
                return is;
            }
            return null;
        }

        @Override
        public InventorySlot findSlotDestAfter(InventorySlot slot, StoredItemStack forStack, boolean loop) {
            for (int i = 0; i < MultiInventoryAccess.this.connected.size(); ++i) {
                IInventoryAccess ia = MultiInventoryAccess.this.connected.get(i);
                InventorySlot is = ia.tracker().findSlotDestAfter(slot, forStack, loop);
                if (is == null) continue;
                return is;
            }
            return null;
        }
    }

    public static class TrackerInfo {
        private int id;
        private IInventoryAccess.IMultiThreadedTracker<Object, Object> mt;
        private Object prep;
        private Object result;
        private long tracker;

        public TrackerInfo(int id, IInventoryAccess.IMultiThreadedTracker<?, ?> mt, Object prep) {
            this.id = id;
            this.mt = mt;
            this.prep = prep;
        }

        public void run() {
            this.result = this.mt.processOffThread(this.prep);
        }

        public void finish(class_1937 level) {
            this.tracker = this.mt.finishOffThreadProcess(level, this.result);
        }
    }

    private static class ItemList
    extends ArrayList<StoredItemStack> {
        private static final long serialVersionUID = 6690277901361998268L;

        private ItemList() {
        }
    }
}

