/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.InventoryCableConnectorBlock;
import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IInventoryConnectorReference;
import com.tom.storagemod.inventory.IInventoryLink;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.MultiInventoryAccess;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.PlatformMultiInventoryAccess;
import com.tom.storagemod.inventory.RemoteConnections;
import com.tom.storagemod.menu.InventoryLinkMenu;
import com.tom.storagemod.util.BeaconLevelCalc;
import com.tom.storagemod.util.TickerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class InventoryCableConnectorBlockEntity
extends PaintedBlockEntity
implements class_3908,
TickerUtil.TickableServer,
IInventoryConnector,
IInventoryLink {
    private static final String CHANNEL_TAG = "channel";
    private PlatformInventoryAccess.BlockInventoryAccess block = new PlatformInventoryAccess.BlockInventoryAccess();
    private MultiInventoryAccess mergedHandler = new PlatformMultiInventoryAccess();
    private Set<IInventoryConnector> linkedConnectors = new HashSet<IInventoryConnector>();
    private Collection<IInventoryAccess> filteredMerge = Collections.emptyList();
    private IInventoryAccess self = this.block;
    private UUID channel = null;
    private int beaconLevel = -1;

    public InventoryCableConnectorBlockEntity(class_2338 p_155229_, class_2680 p_155230_) {
        super((class_2591)Content.cableConnectorBE.get(), p_155229_, p_155230_);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_11863.field_9236) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            class_2350 facing = (class_2350)state.method_11654((class_2769)InventoryCableConnectorBlock.FACING);
            this.block.onLoad(this.field_11863, this.field_11867.method_10093(facing), facing.method_10153(), this);
        }
    }

    public class_1703 createMenu(int p_39954_, class_1661 p_39955_, class_1657 p_39956_) {
        return new InventoryLinkMenu(p_39954_, p_39955_, this);
    }

    @Override
    public void updateServer() {
        long time = this.field_11863.method_8510();
        if (time % 20L == (long)(Math.abs(this.field_11867.hashCode()) % 20)) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            class_2350 facing = (class_2350)state.method_11654((class_2769)InventoryCableConnectorBlock.FACING);
            class_2338 pos = this.field_11867.method_10093(facing);
            class_2680 st = this.field_11863.method_8320(pos);
            this.mergedHandler.clear();
            this.linkedConnectors.clear();
            this.beaconLevel = -1;
            this.detectCableNetwork();
            if (st.method_27852(class_2246.field_10327)) {
                RemoteConnections.Channel chn;
                this.beaconLevel = BeaconLevelCalc.calcBeaconLevel(this.field_11863, pos.method_10263(), pos.method_10264(), pos.method_10260());
                this.self = this.mergedHandler;
                if (this.channel != null && (chn = RemoteConnections.get(this.field_11863).getChannel(this.channel)) != null) {
                    chn.register((class_3218)this.field_11863, this.field_11867);
                    Set<IInventoryLink> links = chn.findOthers((class_3218)this.field_11863, this.field_11867, this.beaconLevel);
                    links.forEach(l -> this.linkedConnectors.add(l.getConnector()));
                }
                this.mergedHandler.build(this, this.linkedConnectors);
            } else {
                class_2586 be = this.field_11863.method_8321(pos);
                if (be instanceof IInventoryConnectorReference) {
                    IInventoryConnectorReference ref = (IInventoryConnectorReference)be;
                    IInventoryConnector inv = ref.getConnectorRef();
                    if (inv != null) {
                        this.self = this.mergedHandler;
                        this.mergedHandler.build(inv, Collections.emptyList());
                        BlockFilter f = BlockFilter.getFilterAt(this.field_11863, this.field_11867);
                        if (f != null) {
                            ArrayList<IInventoryAccess> invs = new ArrayList<IInventoryAccess>();
                            for (IInventoryAccess a : this.mergedHandler.getConnected()) {
                                invs.add(f.wrap(this.field_11863, a));
                            }
                            this.filteredMerge = invs;
                            this.mergedHandler.build(this, Collections.emptyList());
                        } else {
                            this.filteredMerge = this.mergedHandler.getConnected();
                        }
                    } else {
                        this.self = PlatformInventoryAccess.EMPTY;
                    }
                } else {
                    BlockFilter f = BlockFilter.getFilterAt(this.field_11863, this.field_11867);
                    this.self = f != null ? f.wrap(this.field_11863, this.block) : this.block;
                }
            }
        }
    }

    private void detectCableNetwork() {
        Collection<class_2338> netBlocks = InventoryCableNetwork.getNetwork(this.field_11863).getNetworkNodes(this.field_11867);
        for (class_2338 p : netBlocks) {
            class_2586 be;
            if (!this.field_11863.method_8477(p) || (be = this.field_11863.method_8321(p)) == this || !(be instanceof IInventoryConnector)) continue;
            IInventoryConnector te = (IInventoryConnector)be;
            this.linkedConnectors.add(te);
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"menu.toms_storage.inventory_connector");
    }

    public boolean stillValid(class_1657 player) {
        RemoteConnections.Channel chn;
        if (this.channel != null && (chn = RemoteConnections.get(this.field_11863).getChannel(this.channel)) != null && !chn.publicChannel && !chn.owner.equals(player.method_5667())) {
            return false;
        }
        if (this.field_11863.method_8321(this.field_11867) != this || this.beaconLevel < 0) {
            return false;
        }
        return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
    }

    @Override
    public IInventoryAccess getMergedHandler() {
        return this.self;
    }

    @Override
    public Collection<IInventoryAccess> getConnectedInventories() {
        return this.beaconLevel >= 0 ? Collections.emptyList() : (this.self == this.mergedHandler ? this.filteredMerge : Collections.singleton(this.self));
    }

    @Override
    public boolean hasConnectedInventories() {
        return !this.method_11015() && this.beaconLevel >= 0;
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11014(nbt, provider);
        this.channel = nbt.method_10545(CHANNEL_TAG) ? nbt.method_25926(CHANNEL_TAG) : null;
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11007(nbt, provider);
        if (this.channel != null) {
            nbt.method_25927(CHANNEL_TAG, this.channel);
        }
    }

    @Override
    public IInventoryConnector getConnector() {
        return this;
    }

    @Override
    public boolean isAccessibleFrom(class_3218 world, class_2338 blockPos, int level) {
        int cLocalLvl = Config.get().invLinkBeaconLvl;
        int cSDLvl = Config.get().invLinkBeaconLvlSameDim;
        int cCDLvl = Config.get().invLinkBeaconLvlCrossDim;
        int lvl = Math.max(this.beaconLevel, level);
        int lvlM = Math.min(this.beaconLevel, level);
        if (cLocalLvl == -1) {
            return false;
        }
        if (cCDLvl != -1 && lvl >= cCDLvl && (lvlM > 0 || cCDLvl == 0)) {
            return true;
        }
        if (!this.field_11863.method_27983().equals(world.method_27983())) {
            return false;
        }
        if (cSDLvl != -1 && lvl >= cSDLvl && (lvlM > 0 || cSDLvl == 0)) {
            return true;
        }
        int range = Config.get().invLinkBeaconRange;
        range *= range;
        return blockPos.method_10262((class_2382)this.field_11867) < (double)range;
    }

    @Override
    public UUID getChannel() {
        return this.channel;
    }

    public void setChannel(UUID chn) {
        this.channel = chn;
        this.method_5431();
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }

    @Override
    public Collection<IInventoryConnector> getConnectedConnectors() {
        return this.linkedConnectors;
    }

    public boolean hasBeacon() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        class_2350 facing = (class_2350)state.method_11654((class_2769)InventoryCableConnectorBlock.FACING);
        class_2338 pos = this.field_11867.method_10093(facing);
        class_2680 st = this.field_11863.method_8320(pos);
        return st.method_27852(class_2246.field_10327);
    }
}

