/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class BlockOcclusionCache {
    private static final int CACHE_SIZE = 512;
    private static final int ENTRY_ABSENT = -1;
    private static final int ENTRY_FALSE = 0;
    private static final int ENTRY_TRUE = 1;
    private final Object2IntLinkedOpenCustomHashMap<ShapeComparison> comparisonLookupTable;
    private final ShapeComparison cachedComparisonObject = new ShapeComparison();
    private final class_2338.class_2339 cachedPositionObject = new class_2338.class_2339();

    public BlockOcclusionCache() {
        this.comparisonLookupTable = new Object2IntLinkedOpenCustomHashMap(512, 0.5f, (Hash.Strategy)new ShapeComparison.ShapeComparisonStrategy());
        this.comparisonLookupTable.defaultReturnValue(-1);
    }

    public boolean shouldDrawSide(class_2680 selfState, class_1922 view, class_2338 selfPos, class_2350 facing) {
        class_2338.class_2339 otherPos = this.cachedPositionObject;
        otherPos.method_10103(selfPos.method_10263() + facing.method_10148(), selfPos.method_10264() + facing.method_10164(), selfPos.method_10260() + facing.method_10165());
        class_2680 otherState = view.method_8320((class_2338)otherPos);
        if (selfState.method_26187(otherState, facing)) {
            return false;
        }
        if (!otherState.method_26225()) {
            return true;
        }
        class_265 selfShape = selfState.method_26173(view, selfPos, facing);
        if (selfShape.method_1110()) {
            return true;
        }
        class_265 otherShape = otherState.method_26173(view, (class_2338)otherPos, DirectionUtil.getOpposite(facing));
        if (otherShape.method_1110()) {
            return true;
        }
        if (selfShape == class_259.method_1077() && otherShape == class_259.method_1077()) {
            return false;
        }
        return this.lookup(selfShape, otherShape);
    }

    private boolean lookup(class_265 self, class_265 other) {
        ShapeComparison comparison = this.cachedComparisonObject;
        comparison.self = self;
        comparison.other = other;
        return switch (this.comparisonLookupTable.getAndMoveToFirst((Object)comparison)) {
            case 0 -> false;
            case 1 -> true;
            default -> this.calculate(comparison);
        };
    }

    private boolean calculate(ShapeComparison comparison) {
        boolean result = class_259.method_1074((class_265)comparison.self, (class_265)comparison.other, (class_247)class_247.field_16886);
        while (this.comparisonLookupTable.size() >= 512) {
            this.comparisonLookupTable.removeLastInt();
        }
        this.comparisonLookupTable.putAndMoveToFirst((Object)comparison.copy(), result ? 1 : 0);
        return result;
    }

    private static final class ShapeComparison {
        private class_265 self;
        private class_265 other;

        private ShapeComparison() {
        }

        private ShapeComparison(class_265 self, class_265 other) {
            this.self = self;
            this.other = other;
        }

        public ShapeComparison copy() {
            return new ShapeComparison(this.self, this.other);
        }

        public static class ShapeComparisonStrategy
        implements Hash.Strategy<ShapeComparison> {
            public int hashCode(ShapeComparison value) {
                int result = System.identityHashCode(value.self);
                result = 31 * result + System.identityHashCode(value.other);
                return result;
            }

            public boolean equals(ShapeComparison a, ShapeComparison b) {
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                return a.self == b.self && a.other == b.other;
            }
        }
    }
}

