/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.compat;

import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.compat.BedrockifyCompat;
import eu.midnightdust.midnightcontrols.client.compat.CompatHandler;
import eu.midnightdust.midnightcontrols.client.compat.EMICompat;
import eu.midnightdust.midnightcontrols.client.compat.HQMCompat;
import eu.midnightdust.midnightcontrols.client.compat.OkZoomerCompat;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import org.aperlambda.lambdacommon.utils.LambdaReflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightControlsCompat {
    public static final List<CompatHandler> HANDLERS = new ArrayList<CompatHandler>();

    public static void init(@NotNull MidnightControlsClient mod) {
        if (FabricLoader.getInstance().isModLoaded("okzoomer") || FabricLoader.getInstance().isModLoaded("ok_zoomer")) {
            mod.log("Adding Ok Zoomer compatibility...");
            HANDLERS.add(new OkZoomerCompat());
        }
        if (MidnightControlsCompat.isEMIPresent()) {
            mod.log("Adding EMI compatibility...");
            HANDLERS.add(new EMICompat());
        }
        if (FabricLoader.getInstance().isModLoaded("hardcorequesting") && LambdaReflection.doesClassExist((String)"hardcorequesting.client.interfaces.GuiBase")) {
            mod.log("Adding HQM compatibility...");
            HANDLERS.add(new HQMCompat());
        }
        if (FabricLoader.getInstance().isModLoaded("bedrockify")) {
            mod.log("Adding Bedrockify compatibility...");
            HANDLERS.add(new BedrockifyCompat());
        }
        HANDLERS.forEach(handler -> handler.handle(mod));
        InputManager.loadButtonBindings();
    }

    public static void registerCompatHandler(@NotNull CompatHandler handler) {
        HANDLERS.add(handler);
    }

    public static Stream<CompatHandler> streamCompatHandlers() {
        return HANDLERS.stream();
    }

    public static boolean requireMouseOnScreen(class_437 screen) {
        return HANDLERS.stream().anyMatch(handler -> handler.requireMouseOnScreen(screen));
    }

    @Nullable
    public static CompatHandler.SlotPos getSlotAt(@NotNull class_437 screen, int mouseX, int mouseY) {
        for (CompatHandler handler : HANDLERS) {
            CompatHandler.SlotPos slot = handler.getSlotAt(screen, mouseX, mouseY);
            if (slot == null) continue;
            return slot;
        }
        return null;
    }

    public static String getAttackActionAt(@NotNull class_310 client, @Nullable class_3965 placeResult) {
        for (CompatHandler handler : HANDLERS) {
            String action = handler.getAttackActionAt(client, placeResult);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public static String getUseActionAt(@NotNull class_310 client, @Nullable class_3965 placeResult) {
        for (CompatHandler handler : HANDLERS) {
            String action = handler.getUseActionAt(client, placeResult);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public static boolean handleMenuBack(@NotNull class_310 client, @NotNull class_437 screen) {
        for (CompatHandler handler : HANDLERS) {
            if (!handler.handleMenuBack(client, screen)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReiPresent() {
        return FabricLoader.getInstance().isModLoaded("roughlyenoughitems");
    }

    public static boolean isEMIPresent() {
        return FabricLoader.getInstance().isModLoaded("emi");
    }

    public static boolean isInventoryTabsPresent() {
        return FabricLoader.getInstance().isModLoaded("inventorytabs");
    }

    public static boolean isEmotecraftPresent() {
        return FabricLoader.getInstance().isModLoaded("emotecraft");
    }
}

