/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class MultiplayerOptionsPacket {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"journeymap", (String)"mp_options_req");
    private String payload;

    public MultiplayerOptionsPacket() {
    }

    public MultiplayerOptionsPacket(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public static MultiplayerOptionsPacket decode(class_2540 buf) {
        MultiplayerOptionsPacket packet = new MultiplayerOptionsPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.payload = buf.method_10800(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for multiplayer options request: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            if (this.payload != null) {
                buf.method_52997(42);
                buf.method_10814(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for multiplayer options request:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<MultiplayerOptionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            if (((MultiplayerOptionsPacket)ctx.message()).getPayload() == null) {
                Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsOpen(ctx.sender());
            } else {
                Journeymap.getInstance().getPacketHandler().onMultiplayerOptionsSave(ctx.sender(), ((MultiplayerOptionsPacket)ctx.message()).getPayload());
            }
        } else {
            JourneymapClient.getInstance().getPacketHandler().onMultiplayerDataResponse(((MultiplayerOptionsPacket)ctx.message()).getPayload());
        }
    }
}

