/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.ThreeLineButton;
import journeymap.client.ui.component.popupscreenbutton.PopupMenu;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class GroupSlot
extends ManagerSlot
implements SelectableParent {
    private final WaypointGroup group;
    private int width;
    private int height;
    boolean selected = false;
    private int x;
    private int y;
    boolean popupWasOpen = false;
    Button editButton;
    PopupMenu popupMenu;
    ManagerSlot.ToolTipMeta tooltips;

    public GroupSlot(WaypointGroup group, int width, int height) {
        this.group = group;
        this.width = width;
        this.height = height;
        this.editButton = new ThreeLineButton(2, 10, 10, this::optionsClicked);
        this.buildTooltips();
    }

    private void buildTooltips() {
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>();
        tooltip.add(class_5481.method_30747((String)this.group.getName(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1075)));
        if (this.group.getDescription() != null) {
            tooltip.add(class_5481.method_30747((String)this.group.getDescription(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1075)));
        }
        tooltip.add(class_5481.method_30747((String)("Waypoints: " + this.group.getWaypointIds().stream().count()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1060)));
        tooltip.add(class_5481.method_30747((String)("Id: " + this.group.getGuid()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1078)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    private void optionsClicked(class_4185 button) {
        this.optionsPopup(button.method_46426(), button.method_46427());
    }

    private void editGroup(class_4185 button) {
        new EditGroupPopup((class_2561)class_2561.method_43471((String)"Edit Group"), this.group).display();
    }

    private void deleteGroup(class_4185 button) {
        DeleteConfirmGroupPopup popup = new DeleteConfirmGroupPopup((class_2561)class_2561.method_43471((String)("Delete Group " + this.group.getName())), this::deleteGroup);
        popup.display();
    }

    protected void deleteGroup(Tuple2<Boolean, Boolean> tuple2) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple2.a()).booleanValue()));
    }

    private void optionsPopup(int x, int y) {
        if (!WaypointGroupStore.ALL.equals((Object)this.group)) {
            ArrayList list = Lists.newArrayList((Object[])new DropDownItem[]{new DropDownItem((SelectableParent)this, (Object)this.group.getGuid(), true, "Edit", this::editGroup)});
            this.popupMenu = new PopupMenu(class_310.method_1551().field_1755);
            this.popupMenu.setClickLoc(x, y);
            if (!this.group.isLocked() && !WaypointGroupStore.DEFAULT.equals((Object)this.group)) {
                list.add(new DropDownItem((SelectableParent)this, (Object)this.group.getGuid(), true, "Delete", this::deleteGroup));
            }
            this.popupMenu.display(list);
        }
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        return false;
    }

    public boolean method_25404(int key, int value, int modifier) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return new ArrayList();
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return this.tooltips;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void method_25343(class_332 graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        boolean drawHovered = isMouseOver;
        this.x = x;
        this.y = y;
        this.width = rowWidth;
        this.height = itemHeight;
        this.editButton.method_46421(x + 1);
        this.editButton.method_46419(y + 3);
        class_327 font = class_310.method_1551().field_1772;
        Integer color = drawHovered ? backgroundHover : background;
        float alpha = drawHovered ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, color, alpha);
        if (this.selected) {
            DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, backgroundHover, 1.0f);
        }
        int ct = this.group.getWaypointIds().size();
        String name = this.group.getName();
        graphics.method_25303(font, String.format("%s (%s)", name, ct), x + 15, y + 3, -1);
        if (this.selected && !WaypointGroupStore.ALL.equals((Object)this.group)) {
            this.editButton.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderTransferStatus(class_332 graphics, boolean transferable) {
        int color = transferable ? 65280 : 0xFF0000;
        this.outline(graphics, this.x, this.y, this.width - 4, this.height, color, 0.8f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        long clickTime = class_156.method_658();
        boolean bl = this.doubleclick = clickTime - this.lastClickTime < 250L && this.lastClickButton == button;
        if (button == 1 || this.doubleclick) {
            this.popupWasOpen = true;
            this.editGroup(null);
            this.lastClickTime = clickTime;
            this.lastClickButton = button;
            return true;
        }
        this.selected = this.method_25405(mouseX, mouseY);
        if (this.selected) {
            this.popupWasOpen = this.editButton.method_25402(mouseX, mouseY, button);
        }
        this.lastClickTime = clickTime;
        this.lastClickButton = button;
        return this.selected;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.popupWasOpen) {
            this.selected = this.method_25405(mouseX, mouseY);
        }
        this.popupWasOpen = false;
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public WaypointGroup getGroup() {
        return this.group;
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.popupMenu.setSelected(button);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group.getName()).toString();
    }
}

