/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import commonnetwork.api.Network;
import java.io.File;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.client.impl.EntityRegistrationFactory;
import journeymap.api.client.impl.OptionsDisplayFactory;
import journeymap.api.services.Services;
import journeymap.api.services.WebMapService;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.util.PluginHelper;
import journeymap.client.Constants;
import journeymap.client.InternalStateHandler;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.data.DataCache;
import journeymap.client.event.handlers.ChunkMonitorHandler;
import journeymap.client.event.handlers.EntityRadarUpdateEventHandler;
import journeymap.client.event.handlers.PopupMenuEventHandler;
import journeymap.client.event.handlers.ResourceReloadHandler;
import journeymap.client.event.handlers.keymapping.KeyEvent;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.RegionImageCache;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.properties.RenderingProperties;
import journeymap.client.properties.TopoProperties;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.properties.WebMapProperties;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MainTaskController;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.task.multi.TaskController;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.migrate.Migration;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.network.PacketManager;
import journeymap.common.network.dispatch.ClientNetworkDispatcher;
import journeymap.common.network.handler.ClientPacketHandler;
import journeymap.common.version.VersionCheck;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JourneymapClient {
    public static final String FULL_VERSION = Journeymap.MC_VERSION + "-" + String.valueOf(Journeymap.JM_VERSION);
    public static final String MOD_NAME = Journeymap.SHORT_MOD_NAME + " " + FULL_VERSION;
    private volatile String currentWorldId = null;
    private volatile CoreProperties coreProperties;
    private volatile FullMapProperties fullMapProperties;
    private volatile MiniMapProperties miniMapProperties1;
    private volatile MiniMapProperties miniMapProperties2;
    private volatile TopoProperties topoProperties;
    private volatile WebMapProperties webMapProperties;
    private volatile RenderingProperties renderingProperties;
    private volatile WaypointProperties waypointProperties;
    private volatile OptionsDisplayFactory optionsDisplayFactory;
    private volatile Boolean initialized = false;
    private final InternalStateHandler stateHandler;
    private Logger logger = LogManager.getLogger((String)"journeymap");
    private boolean enabled = true;
    private boolean threadLogging = false;
    public boolean hasOptifine = false;
    private ClientNetworkDispatcher dispatcher;
    private ClientPacketHandler packetHandler;
    private TaskController multithreadTaskController;
    private ChunkRenderController chunkRenderController;
    private final MainTaskController mainThreadTaskController;
    private final ResourceReloadHandler resourceReloadHandler;
    private KeyEvent keyEvents;
    private static JourneymapClient instance;

    public JourneymapClient() {
        instance = this;
        this.mainThreadTaskController = new MainTaskController();
        this.resourceReloadHandler = new ResourceReloadHandler();
        this.stateHandler = new InternalStateHandler();
        this.packetHandler = new ClientPacketHandler();
        PacketManager.init();
    }

    public static JourneymapClient getInstance() {
        return instance;
    }

    public void init() {
        StatTimer timer = null;
        try {
            timer = StatTimer.getDisposable("elapsed").start();
            boolean migrationOk = new Migration("journeymap.common.migrate").performTasks();
            this.logger = JMLogger.init();
            this.logger.info("initialize ENTER");
            if (this.initialized.booleanValue()) {
                this.logger.warn("Already initialized, aborting");
                return;
            }
            PluginHelper.INSTANCE.initPlugins((IClientAPI)ClientAPI.INSTANCE);
            this.logger.debug("Loading and Generating Journeymap configs");
            this.loadConfigProperties();
            JMLogger.logProperties();
            this.threadLogging = false;
            EntityRadarUpdateEventHandler.init();
            EntityRegistrationFactory.init();
            PopupMenuEventHandler.init();
            this.keyEvents.getHandler().registerActions();
            this.logger.info("initialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger((String)"journeymap");
            }
            this.logger.error(LogFormatter.toString(t));
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInit() {
        StatTimer timer = null;
        try {
            this.logger.debug("postInitialize ENTER");
            timer = StatTimer.getDisposable("elapsed").start();
            this.queueMainThreadTask(new MappingMonitorTask());
            IconSetFileHandler.initialize();
            ThemeLoader.initialize(true);
            class_3300 resourceManager = class_310.method_1551().method_1478();
            ((class_3304)resourceManager).method_14477((class_3302)((class_4013)rm -> this.resourceReloadHandler.onResourceReload()));
            this.resourceReloadHandler.onResourceReload();
            if (this.webMapProperties.enabled.get().booleanValue() && this.getWebMap() != null) {
                try {
                    this.startWebMap();
                }
                catch (Throwable e) {
                    this.logger.warn("Webmap not found, likely in forge dev environment.");
                }
            }
            ChatLog.announceMod(false);
            this.initialized = true;
            VersionCheck.getVersionAvailable();
            this.optifineCheck();
            if (-1 == this.getKeyEvents().getHandler().kbToggleAllWaypoints.getKeyValue().method_1444() && !JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue()) {
                JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.set(true);
            }
            this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
        }
        catch (Throwable t) {
            try {
                if (this.logger == null) {
                    this.logger = LogManager.getLogger((String)"journeymap");
                }
                this.logger.error(LogFormatter.toString(t));
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
            }
            catch (Throwable throwable) {
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
                throw throwable;
            }
        }
        JMLogger.setLevelFromProperties();
    }

    public void commonSetup() {
        try {
            PluginHelper.INSTANCE.preInitPlugins(Services.COMMON_SERVICE.getClientPluginScanResult());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void optifineCheck() {
        try {
            Class<?> optifine = Class.forName("net.optifine.override.ChunkCacheOF");
            this.logger.info("OptiFine detected.");
            this.hasOptifine = optifine != null;
        }
        catch (ClassNotFoundException e) {
            this.hasOptifine = false;
        }
    }

    public CoreProperties getCoreProperties() {
        return this.coreProperties;
    }

    public RenderingProperties getRenderingProperties() {
        return this.renderingProperties;
    }

    public FullMapProperties getFullMapProperties() {
        return this.fullMapProperties;
    }

    public TopoProperties getTopoProperties() {
        return this.topoProperties;
    }

    public void disable() {
        this.initialized = false;
        this.enabled = false;
        this.stopMapping();
        ClientAPI.INSTANCE.purge();
        DataCache.INSTANCE.purge();
    }

    public void enable() {
        this.enabled = true;
        if (!this.initialized.booleanValue()) {
            this.initialized = true;
            this.startMapping();
        }
    }

    public MiniMapProperties getMiniMapProperties(int which) {
        switch (which) {
            case 2: {
                this.miniMapProperties2.setActive(true);
                this.miniMapProperties1.setActive(false);
                return this.getMiniMapProperties2();
            }
        }
        this.miniMapProperties1.setActive(true);
        this.miniMapProperties2.setActive(false);
        return this.getMiniMapProperties1();
    }

    public MiniMapProperties getActiveMiniMapProperties() {
        if (this.miniMapProperties1.isActive()) {
            return this.getMiniMapProperties1();
        }
        return this.getMiniMapProperties2();
    }

    public int getActiveMinimapId() {
        if (this.miniMapProperties1.isActive()) {
            return 1;
        }
        return 2;
    }

    public MiniMapProperties getMiniMapProperties1() {
        return this.miniMapProperties1;
    }

    public MiniMapProperties getMiniMapProperties2() {
        return this.miniMapProperties2;
    }

    public WebMapProperties getWebMapProperties() {
        return this.webMapProperties;
    }

    public WaypointProperties getWaypointProperties() {
        return this.waypointProperties;
    }

    public boolean isUpdateCheckEnabled() {
        return this.getCoreProperties().checkUpdates.get();
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.initialized != false && this.multithreadTaskController != null && this.multithreadTaskController.isActive() != false;
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnable() {
        this.initialized = true;
        this.enabled = true;
    }

    public WebMapService getWebMap() {
        try {
            return Services.WEB_MAP_SERVICE;
        }
        catch (Throwable e) {
            JMLogger.logOnce("Webmap not found.");
            this.getWebMapProperties().enabled.set(false);
            return null;
        }
    }

    public void startWebMap() {
        if (this.getWebMap() != null) {
            this.getWebMap().start();
        }
    }

    public void stopWebMap() {
        if (this.getWebMap() != null) {
            this.getWebMap().stop();
        }
    }

    public void queueOneOff(Runnable runnable) throws Exception {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.queueOneOff(runnable);
        }
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.toggleTask(managerClass, enable, params);
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.multithreadTaskController != null) {
            return this.multithreadTaskController.isTaskManagerEnabled(managerClass);
        }
        return false;
    }

    public boolean isMainThreadTaskActive() {
        if (this.mainThreadTaskController != null) {
            return this.mainThreadTaskController.isActive();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean created;
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null || !this.initialized.booleanValue() || !this.coreProperties.mappingEnabled.get().booleanValue()) {
                return;
            }
            File worldDir = FileHandler.getJMWorldDir(mc, this.currentWorldId);
            if (worldDir == null) {
                return;
            }
            if (!worldDir.exists() && !(created = worldDir.mkdirs())) {
                JMLogger.logOnce("CANNOT CREATE DATA DIRECTORY FOR WORLD: " + worldDir.getPath());
                return;
            }
            this.reset();
            this.multithreadTaskController = new TaskController();
            this.multithreadTaskController.enableTasks();
            ColorManager.INSTANCE.loadPalettes();
            long totalMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeMB = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            String memory = String.format("Memory: %sMB total, %sMB free", totalMB, freeMB);
            class_5321 dimension = mc.field_1687.method_27983();
            this.logger.info(String.format("Mapping started in %s%s%s. %s ", FileHandler.getJMWorldDir(mc, this.currentWorldId), File.separator, FileHandler.getDimNameForPath(FileHandler.getJMWorldDir(mc, this.currentWorldId), (class_5321<class_1937>)dimension), memory));
            if (this.stateHandler.isJourneyMapServerConnection() || this.stateHandler.isModdedServerConnection() || class_310.method_1551().method_1496()) {
                this.getDispatcher().sendPermissionRequest();
            }
            ClientAPI.INSTANCE.getClientEventManager().fireMappingEvent(true, (class_5321<class_1937>)dimension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            ChunkMonitorHandler.getInstance().reset();
            class_310 mc = class_310.method_1551();
            if (this.isMapping().booleanValue() && mc != null) {
                this.logger.info(String.format("Mapping halted in %s%s%s", FileHandler.getJMWorldDir(mc, this.currentWorldId), File.separator, mc.field_1687.method_27983().method_29177()));
                RegionImageCache.INSTANCE.flushToDiskAsync(true);
            }
            if (this.multithreadTaskController != null) {
                this.multithreadTaskController.disableTasks();
                this.multithreadTaskController.clear();
                this.multithreadTaskController = null;
            }
            if (mc != null) {
                class_5321 dimension = mc.field_1687 != null ? mc.field_1687.method_27983() : class_1937.field_25179;
                ClientAPI.INSTANCE.getClientEventManager().fireMappingEvent(false, (class_5321<class_1937>)dimension);
            }
        }
    }

    private void reset() {
        this.stateHandler.reset();
        if (!class_310.method_1551().method_1496()) {
            try {
                this.getDispatcher().sendPermissionRequest();
                this.getDispatcher().sendWorldIdRequest();
            }
            catch (Exception e) {
                JMLogger.throwLogOnce("error sending packet request, likely due to being on singleplayer", e);
            }
        }
        this.loadConfigProperties();
        DataCache.INSTANCE.purge();
        ChunkMonitorHandler.getInstance().reset();
        this.chunkRenderController = new ChunkRenderController();
        Fullscreen.state().follow.set(true);
        StatTimer.resetAll();
        UIManager.INSTANCE.reset();
        WaypointHandler.getInstance().reset();
        RegionDataStorageHandler.getInstance().flushDataCache();
    }

    public void queueMainThreadTask(IMainThreadTask task) {
        this.mainThreadTaskController.addTask(task);
    }

    public void performMainThreadTasks() {
        this.mainThreadTaskController.performTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMultithreadTasks() {
        try {
            JourneymapClient journeymapClient = this;
            synchronized (journeymapClient) {
                if (this.isMapping().booleanValue()) {
                    this.multithreadTaskController.performTasks();
                }
            }
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMultithreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public ChunkRenderController getChunkRenderController() {
        return this.chunkRenderController;
    }

    public void saveConfigProperties() {
        if (this.coreProperties != null) {
            this.coreProperties.save();
        }
        if (this.fullMapProperties != null) {
            this.fullMapProperties.save();
        }
        if (this.miniMapProperties1 != null) {
            this.miniMapProperties1.save();
        }
        if (this.miniMapProperties2 != null) {
            this.miniMapProperties2.save();
        }
        if (this.topoProperties != null) {
            this.topoProperties.save();
        }
        if (this.webMapProperties != null) {
            this.webMapProperties.save();
        }
        if (this.waypointProperties != null) {
            this.waypointProperties.save();
        }
        if (this.optionsDisplayFactory != null) {
            this.optionsDisplayFactory.save();
        }
        if (this.renderingProperties != null) {
            this.renderingProperties.save();
        }
    }

    public void loadConfigProperties() {
        this.saveConfigProperties();
        this.optionsDisplayFactory = new OptionsDisplayFactory().buildAddonProperties().load();
        this.coreProperties = (CoreProperties)new CoreProperties().load();
        this.fullMapProperties = (FullMapProperties)new FullMapProperties().load();
        this.miniMapProperties1 = (MiniMapProperties)new MiniMapProperties(1).load();
        this.miniMapProperties2 = (MiniMapProperties)new MiniMapProperties(2).load();
        this.topoProperties = (TopoProperties)new TopoProperties().load();
        this.webMapProperties = (WebMapProperties)new WebMapProperties().load();
        this.waypointProperties = (WaypointProperties)new WaypointProperties().load();
        this.renderingProperties = (RenderingProperties)new RenderingProperties().load();
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWorldId(String worldId) {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            class_310 mc = class_310.method_1551();
            if (!mc.method_1496()) {
                boolean directoryUnchanged;
                File currentWorldDirectory = FileHandler.getJMWorldDirForWorldId(mc, this.currentWorldId);
                File newWorldDirectory = FileHandler.getJMWorldDir(mc, worldId);
                boolean worldIdUnchanged = Constants.safeEqual(worldId, this.currentWorldId);
                boolean bl = directoryUnchanged = currentWorldDirectory != null && newWorldDirectory != null && currentWorldDirectory.getPath().equals(newWorldDirectory.getPath());
                if (worldIdUnchanged && directoryUnchanged) {
                    Journeymap.getLogger().debug("World UID hasn't changed: " + worldId);
                    return;
                }
                boolean wasMapping = this.isMapping();
                if (wasMapping) {
                    this.stopMapping();
                }
                this.currentWorldId = worldId;
                Journeymap.getLogger().info("World UID is set to: " + worldId);
            }
        }
    }

    public ClientNetworkDispatcher getDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new ClientNetworkDispatcher(Network.getNetworkHandler());
        }
        return this.dispatcher;
    }

    public ClientPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public InternalStateHandler getStateHandler() {
        return this.stateHandler;
    }

    public KeyEvent getKeyEvents() {
        return this.keyEvents;
    }

    public void setKeyEvents(KeyEvent keyEvents) {
        this.keyEvents = keyEvents;
    }

    public int getRenderDistance() {
        int gameRenderDistance = Math.max(1, class_310.method_1551().field_1690.method_38521() - 1);
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            int serverDistance = JourneymapClient.getInstance().getStateHandler().getMaxRenderDistance();
            gameRenderDistance = serverDistance == 0 ? gameRenderDistance : Math.min(serverDistance, gameRenderDistance);
        }
        return gameRenderDistance;
    }
}

