/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.idwtialsimmoedm;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.wispforest.idwtialsimmoedm.IdwtialsimmoedmClient;
import io.wispforest.idwtialsimmoedm.api.DefaultDescriptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class IdwtialsimmoedmConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static IdwtialsimmoedmConfig INSTANCE = new IdwtialsimmoedmConfig();
    public String descriptionPrefix = " \u25c7 ";
    public String descriptionIndent = "   ";
    public boolean displayOnlyWhenShiftIsHeld = false;
    public boolean displayOnBooksOnly = true;
    public boolean hideMissingDescriptions = !FabricLoader.getInstance().isDevelopmentEnvironment();

    public static void load() {
        if (!Files.exists(IdwtialsimmoedmConfig.configPath(), new LinkOption[0])) {
            IdwtialsimmoedmConfig.save();
            return;
        }
        try (InputStream input = Files.newInputStream(IdwtialsimmoedmConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (IdwtialsimmoedmConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), IdwtialsimmoedmConfig.class);
        }
        catch (IOException e) {
            IdwtialsimmoedmClient.LOGGER.warn("Could not load config", (Throwable)e);
        }
    }

    public static void save() {
        DefaultDescriptions.clearCache();
        try (OutputStream output = Files.newOutputStream(IdwtialsimmoedmConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            IdwtialsimmoedmClient.LOGGER.warn("Could not save config", (Throwable)e);
        }
    }

    public static IdwtialsimmoedmConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new IdwtialsimmoedmConfig();
        }
        return INSTANCE;
    }

    private static Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("idwtialsimmoedm.json");
    }
}

