/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.generic_properties;

import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.NumberRangeFromStringArrayProperty;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class FloatRangeFromStringArrayProperty
extends NumberRangeFromStringArrayProperty<Float> {
    protected FloatRangeFromStringArrayProperty(String string) throws RandomProperty.RandomPropertyException {
        super(string);
    }

    @Override
    @Nullable
    protected NumberRangeFromStringArrayProperty.RangeTester<Float> getRangeTesterFromString(String possibleRange) {
        try {
            if (possibleRange.matches("([\\d.]+|-[\\d.]+)-([\\d.]+|-[\\d.]+)")) {
                float right;
                String[] str = possibleRange.split("(?<!^|-)-");
                float left = Float.parseFloat(str[0].replaceAll("[^0-9.-]", ""));
                if (left == (right = Float.parseFloat(str[1].replaceAll("[^0-9.-]", "")))) {
                    return value -> value.floatValue() == left;
                }
                if (right > left) {
                    return value -> value.floatValue() >= left && value.floatValue() <= right;
                }
                return value -> value.floatValue() >= right && value.floatValue() <= left;
            }
            float single = Float.parseFloat(possibleRange.replaceAll("[^0-9.-]", ""));
            return value -> value.floatValue() == single;
        }
        catch (Exception ignored) {
            ETFUtils2.logError("number or range in [" + this.getPropertyId() + "] property could not be extracted from input: " + possibleRange);
            return null;
        }
    }
}

