/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.ArrayList;
import java.util.List;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;

public class MinMethod
extends MathMethod {
    public MinMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = MinMethod.parseAllArgs(args, calculationInstance);
        MathComponent initial = parsedArgs.get(0);
        ArrayList<MathComponent> theRest = new ArrayList<MathComponent>(parsedArgs);
        theRest.remove(0);
        this.setSupplierAndOptimize(() -> {
            float min = initial.getResult();
            for (MathComponent parsedArg : theRest) {
                float val = parsedArg.getResult();
                if (!(val < min)) continue;
                min = val;
            }
            return min;
        }, parsedArgs);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 2;
    }
}

