/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.NestedSlotReferenceImpl;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class AccessoryNestUtils {
    @Nullable
    public static AccessoryNestContainerContents getData(class_1799 stack) {
        Accessory accessory = AccessoriesAPI.getAccessory(stack.method_7909());
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (AccessoryNestContainerContents)stack.method_57824(AccessoriesDataComponents.NESTED_ACCESSORIES);
    }

    @Nullable
    public static <T> T recursiveStackHandling(class_1799 stack, SlotReference reference, BiFunction<class_1799, SlotReference, @Nullable T> function) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack.method_7909());
        T value = function.apply(stack, reference);
        if (accessory instanceof AccessoryNest) {
            AccessoryNest holdable = (AccessoryNest)accessory;
            if (value == null) {
                List<class_1799> innerStacks = holdable.getInnerStacks(stack);
                for (int i = 0; i < innerStacks.size(); ++i) {
                    class_1799 innerStack = innerStacks.get(i);
                    if (innerStack.method_7960() || (value = AccessoryNestUtils.recursiveStackHandling(innerStack, AccessoryNestUtils.create(reference, i), function)) == null) continue;
                    return value;
                }
            }
        }
        return value;
    }

    public static void recursiveStackConsumption(class_1799 stack, SlotReference reference, BiConsumer<class_1799, SlotReference> consumer) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack.method_7909());
        consumer.accept(stack, reference);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNest holdable = (AccessoryNest)accessory;
        List<class_1799> innerStacks = holdable.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            class_1799 innerStack = innerStacks.get(i);
            if (innerStack.method_7960()) continue;
            AccessoryNestUtils.recursiveStackConsumption(innerStack, AccessoryNestUtils.create(reference, i), consumer);
        }
    }

    public static SlotReference create(SlotReference reference, int innerIndex) {
        ArrayList<Integer> innerSlotIndices = new ArrayList<Integer>();
        if (reference instanceof NestedSlotReferenceImpl) {
            NestedSlotReferenceImpl nestedSlotReference = (NestedSlotReferenceImpl)reference;
            innerSlotIndices.addAll(nestedSlotReference.innerSlotIndices());
        }
        innerSlotIndices.add(innerIndex);
        return SlotReference.ofNest(reference.entity(), reference.slotName(), reference.slot(), innerSlotIndices);
    }
}

