/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.endec.RegistriesAttribute;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesContainerImpl
implements AccessoriesContainer,
InstanceEndec {
    protected AccessoriesCapability capability;
    private String slotName;
    protected final Map<class_2960, class_1322> modifiers = new HashMap<class_2960, class_1322>();
    protected final Set<class_1322> persistentModifiers = new HashSet<class_1322>();
    protected final Set<class_1322> cachedModifiers = new HashSet<class_1322>();
    private final Multimap<class_1322.class_1323, class_1322> modifiersByOperation = HashMultimap.create();
    @Nullable
    private Integer baseSize;
    private List<Boolean> renderOptions;
    private ExpandedSimpleContainer accessories;
    private ExpandedSimpleContainer cosmeticAccessories;
    private boolean update = false;
    private boolean resizingUpdate = false;
    public static final KeyedEndec<String> SLOT_NAME_KEY = Endec.STRING.keyed("SlotName", (Object)"UNKNOWN");
    public static final KeyedEndec<Integer> BASE_SIZE_KEY = Endec.INT.keyed("BaseSize", () -> null);
    public static final KeyedEndec<Integer> CURRENT_SIZE_KEY = Endec.INT.keyed("CurrentSize", (Object)0);
    public static final KeyedEndec<List<Boolean>> RENDER_OPTIONS_KEY = Endec.BOOLEAN.listOf().keyed("RenderOptions", ArrayList::new);
    public static final KeyedEndec<List<class_2487>> MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("Modifiers", ArrayList::new);
    public static final KeyedEndec<List<class_2487>> PERSISTENT_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("PersistentModifiers", ArrayList::new);
    public static final KeyedEndec<List<class_2487>> CACHED_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("CachedModifiers", ArrayList::new);
    public static final KeyedEndec<class_2499> ITEMS_KEY = NbtEndec.LIST.keyed("Items", class_2499::new);
    public static final KeyedEndec<class_2499> COSMETICS_KEY = NbtEndec.LIST.keyed("Cosmetics", class_2499::new);

    public AccessoriesContainerImpl(AccessoriesCapability capability, SlotType slotType) {
        this.capability = capability;
        this.slotName = slotType.name();
        this.baseSize = slotType.amount();
        this.accessories = new ExpandedSimpleContainer(this.baseSize, "Accessories", false);
        this.cosmeticAccessories = new ExpandedSimpleContainer(this.baseSize, "Cosmetic Accessories", false);
        this.renderOptions = this.getWithSize(this.baseSize, new ArrayList(), true);
    }

    @Nullable
    public Integer getBaseSize() {
        return this.baseSize;
    }

    @Override
    public void markChanged(boolean resizingUpdate) {
        this.update = true;
        this.resizingUpdate = resizingUpdate;
        if (this.capability.entity().method_37908().field_9236) {
            return;
        }
        Map<AccessoriesContainer, Boolean> inv = ((AccessoriesCapabilityImpl)this.capability).getUpdatingInventories();
        inv.remove(this);
        inv.put(this, resizingUpdate);
    }

    @Override
    public boolean hasChanged() {
        return this.update;
    }

    @Override
    public void update() {
        int currentSize;
        double size;
        boolean hasChangeOccurred;
        boolean bl = hasChangeOccurred = !this.resizingUpdate;
        if (!this.update) {
            return;
        }
        this.update = false;
        if (this.capability.entity().method_37908().field_9236) {
            return;
        }
        SlotType slotType = this.slotType();
        if (this.baseSize == null) {
            this.baseSize = 0;
        }
        if (slotType != null && this.baseSize.intValue() != slotType.amount()) {
            this.baseSize = slotType.amount();
            hasChangeOccurred = true;
        }
        double baseSize = this.baseSize.intValue();
        if (ExtraSlotTypeProperties.getProperty(this.slotName, false).allowResizing()) {
            for (class_1322 modifier : this.getModifiersForOperation(class_1322.class_1323.field_6328)) {
                baseSize += modifier.comp_2449();
            }
            size = baseSize;
            for (class_1322 modifier : this.getModifiersForOperation(class_1322.class_1323.field_6330)) {
                size += (double)this.baseSize.intValue() * modifier.comp_2449();
            }
            for (class_1322 modifier : this.getModifiersForOperation(class_1322.class_1323.field_6331)) {
                size *= modifier.comp_2449();
            }
        } else {
            size = baseSize;
        }
        if ((currentSize = (int)Math.round(size)) != this.accessories.method_5439()) {
            hasChangeOccurred = true;
            ArrayList<Pair> invalidAccessories = new ArrayList<Pair>();
            ArrayList<class_1799> invalidStacks = new ArrayList<class_1799>();
            ExpandedSimpleContainer newAccessories = new ExpandedSimpleContainer(currentSize, "Accessories");
            ExpandedSimpleContainer newCosmetics = new ExpandedSimpleContainer(currentSize, "Cosmetic Accessories");
            for (int i = 0; i < this.accessories.method_5439(); ++i) {
                if (i < newAccessories.method_5439()) {
                    newAccessories.method_5447(i, this.accessories.method_5438(i));
                    newCosmetics.method_5447(i, this.cosmeticAccessories.method_5438(i));
                    continue;
                }
                invalidAccessories.add(Pair.of((Object)i, (Object)this.accessories.method_5438(i)));
                invalidStacks.add(this.cosmeticAccessories.method_5438(i));
            }
            newAccessories.copyPrev(this.accessories);
            newCosmetics.copyPrev(this.cosmeticAccessories);
            this.accessories = newAccessories;
            this.cosmeticAccessories = newCosmetics;
            this.renderOptions = this.getWithSize(currentSize, this.renderOptions, true);
            class_1309 livingEntity = this.capability.entity();
            for (Pair invalidAccessory : invalidAccessories) {
                Integer index = (Integer)invalidAccessory.getFirst();
                class_1799 invalidStack = (class_1799)invalidAccessory.getSecond();
                if (invalidStack.method_7960()) continue;
                SlotReference slotReference = SlotReference.of(livingEntity, this.slotName, index);
                AttributeUtils.removeTransientAttributeModifiers(livingEntity, AccessoriesAPI.getAttributeModifiers(invalidStack, slotReference));
                Accessory accessory = AccessoriesAPI.getAccessory(invalidStack);
                if (accessory != null) {
                    accessory.onUnequip(invalidStack, slotReference);
                }
                invalidStacks.add(invalidStack);
            }
            ((AccessoriesHolderImpl)this.capability.getHolder()).invalidStacks.addAll(invalidStacks);
            if (this.update) {
                this.capability.updateContainers();
            }
        }
        if (!hasChangeOccurred) {
            Map<AccessoriesContainer, Boolean> inv = ((AccessoriesCapabilityImpl)this.capability).getUpdatingInventories();
            inv.remove(this);
        }
    }

    @Override
    public int getSize() {
        this.update();
        return this.accessories.method_5439();
    }

    @Override
    public String getSlotName() {
        return this.slotName;
    }

    @Override
    public AccessoriesCapability capability() {
        return this.capability;
    }

    @Override
    public List<Boolean> renderOptions() {
        this.update();
        return this.renderOptions;
    }

    @Override
    public ExpandedSimpleContainer getAccessories() {
        this.update();
        return this.accessories;
    }

    @Override
    public ExpandedSimpleContainer getCosmeticAccessories() {
        this.update();
        return this.cosmeticAccessories;
    }

    @Override
    public Map<class_2960, class_1322> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Set<class_1322> getCachedModifiers() {
        return this.cachedModifiers;
    }

    @Override
    public Collection<class_1322> getModifiersForOperation(class_1322.class_1323 operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(class_1322 modifier) {
        this.modifiers.put(modifier.comp_2447(), modifier);
        this.getModifiersForOperation(modifier.comp_2450()).add(modifier);
        this.markChanged();
    }

    @Override
    public void addPersistentModifier(class_1322 modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public boolean hasModifier(class_2960 location) {
        return this.modifiers.containsKey(location);
    }

    @Override
    public void removeModifier(class_2960 location) {
        class_1322 modifier = this.modifiers.remove(location);
        if (modifier == null) {
            return;
        }
        this.persistentModifiers.remove(modifier);
        this.getModifiersForOperation(modifier.comp_2450()).remove(modifier);
        this.markChanged();
    }

    @Override
    public void clearModifiers() {
        this.getModifiers().keySet().iterator().forEachRemaining(this::removeModifier);
    }

    @Override
    public void removeCachedModifiers(class_1322 modifier) {
        this.cachedModifiers.remove(modifier);
    }

    @Override
    public void clearCachedModifiers() {
        this.cachedModifiers.forEach(cachedModifier -> this.removeModifier(cachedModifier.comp_2447()));
        this.cachedModifiers.clear();
    }

    public void copyFrom(AccessoriesContainerImpl other) {
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.values().forEach(this::addTransientModifier);
        other.persistentModifiers.forEach(this::addPersistentModifier);
        this.update();
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        this.write(carrier, ctx, false);
    }

    public void write(MapCarrier carrier, SerializationContext ctx, boolean sync) {
        class_5455 registryAccess = ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager();
        carrier.put(SLOT_NAME_KEY, (Object)this.slotName);
        carrier.putIfNotNull(ctx, BASE_SIZE_KEY, (Object)this.baseSize);
        carrier.put(RENDER_OPTIONS_KEY, this.renderOptions);
        if (!sync || this.accessories.wasNewlyConstructed()) {
            carrier.put(CURRENT_SIZE_KEY, (Object)this.accessories.method_5439());
            carrier.put(ITEMS_KEY, (Object)this.accessories.method_7660((class_7225.class_7874)registryAccess));
            carrier.put(COSMETICS_KEY, (Object)this.cosmeticAccessories.method_7660((class_7225.class_7874)registryAccess));
        }
        if (sync) {
            if (!this.modifiers.isEmpty()) {
                ArrayList modifiersTag = new ArrayList();
                this.modifiers.values().forEach(modifier -> modifiersTag.add(modifier.method_26860()));
                carrier.put(MODIFIERS_KEY, modifiersTag);
            }
        } else {
            if (!this.persistentModifiers.isEmpty()) {
                ArrayList persistentTag = new ArrayList();
                this.persistentModifiers.forEach(modifier -> persistentTag.add(modifier.method_26860()));
                carrier.put(PERSISTENT_MODIFIERS_KEY, persistentTag);
            }
            if (!this.modifiers.isEmpty()) {
                ArrayList cachedTag = new ArrayList();
                this.modifiers.values().forEach(modifier -> {
                    if (this.persistentModifiers.contains(modifier)) {
                        return;
                    }
                    cachedTag.add(modifier.method_26860());
                });
                carrier.put(CACHED_MODIFIERS_KEY, cachedTag);
            }
        }
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.read(carrier, ctx, false);
    }

    public void read(MapCarrier carrier, SerializationContext ctx, boolean sync) {
        block10: {
            class_1322 modifier;
            List persistentTag;
            block9: {
                class_5455 registryAccess = ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager();
                this.slotName = (String)carrier.get(SLOT_NAME_KEY);
                this.baseSize = (Integer)carrier.get(BASE_SIZE_KEY);
                if (carrier.has(CURRENT_SIZE_KEY)) {
                    Integer currentSize = (Integer)carrier.get(CURRENT_SIZE_KEY);
                    List sentOptions = (List)carrier.get(RENDER_OPTIONS_KEY);
                    this.renderOptions = this.getWithSize(currentSize, sentOptions, true);
                    if (this.accessories.method_5439() != currentSize.intValue()) {
                        this.accessories = new ExpandedSimpleContainer(currentSize, "Accessories");
                        this.cosmeticAccessories = new ExpandedSimpleContainer(currentSize, "Cosmetic Accessories");
                    }
                    this.accessories.method_7659((class_2499)carrier.get(ITEMS_KEY), (class_7225.class_7874)registryAccess);
                    this.cosmeticAccessories.method_7659((class_2499)carrier.get(COSMETICS_KEY), (class_7225.class_7874)registryAccess);
                } else {
                    this.renderOptions = (List)carrier.get(RENDER_OPTIONS_KEY);
                }
                if (!sync) break block9;
                this.modifiers.clear();
                this.persistentModifiers.clear();
                this.modifiersByOperation.clear();
                if (!carrier.has(MODIFIERS_KEY)) break block10;
                persistentTag = (List)carrier.get(MODIFIERS_KEY);
                for (class_2487 compoundTag : persistentTag) {
                    class_1322 modifier2 = class_1322.method_26859((class_2487)compoundTag);
                    if (modifier2 == null) continue;
                    this.addTransientModifier(modifier2);
                }
                break block10;
            }
            if (carrier.has(PERSISTENT_MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(PERSISTENT_MODIFIERS_KEY);
                for (class_2487 compoundTag : persistentTag) {
                    modifier = class_1322.method_26859((class_2487)compoundTag);
                    if (modifier == null) continue;
                    this.addPersistentModifier(modifier);
                }
            }
            if (carrier.has(CACHED_MODIFIERS_KEY)) {
                List cachedTag = (List)carrier.get(PERSISTENT_MODIFIERS_KEY);
                for (class_2487 compoundTag : cachedTag) {
                    modifier = class_1322.method_26859((class_2487)compoundTag);
                    if (modifier != null) {
                        this.cachedModifiers.add(modifier);
                        this.addTransientModifier(modifier);
                    }
                    this.update();
                }
            }
        }
    }

    private <T> List<T> getWithSize(int size, List<T> list, T defaultValue) {
        ArrayList<T> sizedList = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            T value = i < list.size() ? list.get(i) : defaultValue;
            sizedList.add(value);
        }
        return sizedList;
    }

    public static class_1277 readContainer(MapCarrier carrier, SerializationContext ctx, KeyedEndec<class_2499> key) {
        return AccessoriesContainerImpl.readContainers(carrier, ctx, key).get(0);
    }

    @SafeVarargs
    public static List<class_1277> readContainers(MapCarrier carrier, SerializationContext ctx, KeyedEndec<class_2499> ... keys) {
        ArrayList<class_1277> containers = new ArrayList<class_1277>();
        class_5455 registryAccess = ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager();
        for (KeyedEndec<class_2499> key : keys) {
            class_1277 stacks = new class_1277(new class_1799[0]);
            if (carrier.has(key)) {
                stacks.method_7659((class_2499)carrier.get(key), (class_7225.class_7874)registryAccess);
            }
            containers.add(stacks);
        }
        return containers;
    }

    public static class_1277 copyContainerList(class_1277 container) {
        return new class_1277((class_1799[])container.method_54454().toArray(class_1799[]::new));
    }
}

