/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.endec.RegistriesAttribute;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesCapabilityImpl
implements AccessoriesCapability,
InstanceEndec {
    private final class_1309 entity;
    private boolean updateContainersLock = false;

    public AccessoriesCapabilityImpl(class_1309 entity) {
        this.entity = entity;
        if (this.holder().loadedFromTag) {
            this.reset(true);
        }
    }

    @Override
    public class_1309 entity() {
        return this.entity;
    }

    @Override
    public AccessoriesHolder getHolder() {
        AccessoriesHolder holder = AccessoriesInternals.getHolder(this.entity);
        if (((AccessoriesHolderImpl)holder).loadedFromTag) {
            this.reset(true);
        }
        return holder;
    }

    private AccessoriesHolderImpl holder() {
        return (AccessoriesHolderImpl)this.getHolder();
    }

    @Override
    public Map<String, AccessoriesContainer> getContainers() {
        Map<String, AccessoriesContainer> containers = this.holder().getSlotContainers();
        for (AccessoriesContainer container : containers.values()) {
            if (this.entity == container.capability().entity()) break;
            ((AccessoriesContainerImpl)container).capability = this;
        }
        return containers;
    }

    @Override
    public void reset(boolean loadedFromTag) {
        block5: {
            AccessoriesHolderImpl holder;
            block7: {
                block6: {
                    block4: {
                        if (this.entity.method_37908().method_8608()) {
                            return;
                        }
                        holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(this.entity);
                        if (loadedFromTag) break block4;
                        Map<String, AccessoriesContainer> oldContainers = Map.copyOf(holder.getSlotContainers());
                        holder.init(this);
                        Map<String, AccessoriesContainer> currentContainers = holder.getSlotContainers();
                        oldContainers.forEach((s, oldContainer) -> {
                            AccessoriesContainer currentContainer = (AccessoriesContainer)currentContainers.get(s);
                            currentContainer.getAccessories().setFromPrev(oldContainer.getAccessories());
                            currentContainer.markChanged(false);
                        });
                        break block5;
                    }
                    holder.init(this);
                    class_1309 currentContainers = this.entity;
                    if (!(currentContainers instanceof class_3222)) break block6;
                    class_3222 serverPlayer = (class_3222)currentContainers;
                    if (serverPlayer.field_13987 != null) break block7;
                }
                return;
            }
            NbtMapCarrier carrier = NbtMapCarrier.of();
            holder.write(carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(this.entity.method_37908().method_30349())}));
            AccessoriesInternals.getNetworkHandler().sendToTrackingAndSelf((class_1297)this.entity(), new SyncEntireContainer(this.entity.method_5628(), carrier));
        }
    }

    @Override
    public void updateContainers() {
        boolean hasUpdateOccurred;
        if (this.updateContainersLock) {
            return;
        }
        Collection<AccessoriesContainer> containers = this.getContainers().values();
        this.updateContainersLock = true;
        do {
            hasUpdateOccurred = false;
            for (AccessoriesContainer container : containers) {
                if (!container.hasChanged()) continue;
                container.update();
                hasUpdateOccurred = true;
            }
        } while (hasUpdateOccurred);
        this.updateContainersLock = false;
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addTransientModifier);
        }
    }

    @Override
    public void addPersistentSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addPersistentModifier);
        }
    }

    @Override
    public void removeSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(modifier -> container.removeModifier(modifier.comp_2447()));
        }
    }

    @Override
    public Multimap<String, class_1322> getSlotModifiers() {
        HashMultimap modifiers = HashMultimap.create();
        this.getContainers().forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$getSlotModifiers$2((Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @Override
    public void clearSlotModifiers() {
        this.getContainers().forEach((s, container) -> container.clearModifiers());
    }

    @Override
    public void clearCachedSlotModifiers() {
        HashMultimap slotModifiers = HashMultimap.create();
        Map<String, AccessoriesContainer> containers = this.getContainers();
        containers.forEach((name, container) -> {
            Set<class_1322> modifiers = container.getCachedModifiers();
            if (modifiers.isEmpty()) {
                return;
            }
            ExpandedSimpleContainer accessories = container.getAccessories();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                class_1799 stack = accessories.method_5438(i);
                if (stack.method_7960()) continue;
                SlotReference slotReference = container.createReference(i);
                slotModifiers.putAll(AccessoriesAPI.getAttributeModifiers(stack, slotReference).getSlotModifiers());
            }
        });
        slotModifiers.asMap().forEach((name, modifiers) -> {
            if (!containers.containsKey(name)) {
                return;
            }
            AccessoriesContainer container = (AccessoriesContainer)containers.get(name);
            modifiers.forEach(container.getCachedModifiers()::remove);
            container.clearCachedModifiers();
        });
    }

    public Map<AccessoriesContainer, Boolean> getUpdatingInventories() {
        return this.holder().containersRequiringUpdates;
    }

    @Override
    @Nullable
    public it.unimi.dsi.fastutil.Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack, boolean allowSwapping, TriFunction<Accessory, class_1799, SlotReference, Boolean> additionalCheck) {
        ExpandedSimpleContainer accessories;
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        if (accessory == null) {
            return null;
        }
        HashMap<String, AccessoriesContainer> validContainers = new HashMap<String, AccessoriesContainer>();
        if (stack.method_7960() && allowSwapping) {
            Map<String, AccessoriesContainer> allContainers = this.getContainers();
            EntitySlotLoader.getEntitySlots(this.entity()).forEach((s, slotType) -> validContainers.put((String)s, (AccessoriesContainer)allContainers.get(slotType.name())));
        } else {
            for (AccessoriesContainer container : this.getContainers().values()) {
                if (container.getSize() <= 0) continue;
                accessories = container.getAccessories();
                boolean isValid = AccessoriesAPI.canInsertIntoSlot(stack, container.createReference(0));
                if (!isValid || !ExtraSlotTypeProperties.getProperty(container.getSlotName(), this.entity.method_37908().field_9236).allowEquipFromUse()) continue;
                if (allowSwapping) {
                    validContainers.put(container.getSlotName(), container);
                }
                for (int i = 0; i < container.getSize(); ++i) {
                    class_1799 slotStack = accessories.method_5438(i);
                    SlotReference slotReference = container.createReference(i);
                    if (!slotStack.method_7960() || !AccessoriesAPI.canUnequip(slotStack, slotReference) || !((Boolean)additionalCheck.apply((Object)accessory, (Object)stack, (Object)slotReference)).booleanValue() || !AccessoriesAPI.canInsertIntoSlot(stack, slotReference)) continue;
                    class_1799 stackCopy = stack.method_7972();
                    if (!this.entity.method_37908().field_9236) {
                        class_1799 splitStack = stackCopy.method_7971(accessory.maxStackSize(stackCopy));
                        accessories.method_5447(i, splitStack);
                        container.markChanged();
                    }
                    return it.unimi.dsi.fastutil.Pair.of((Object)container.createReference(i), List.of(stackCopy.method_7960() ? class_1799.field_8037 : stackCopy));
                }
            }
        }
        for (AccessoriesContainer validContainer : validContainers.values()) {
            accessories = validContainer.getAccessories();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                class_1799 splitStack;
                SlotReference slotReference;
                class_1799 slotStack = accessories.method_5438(i).method_7972();
                if (!AccessoriesAPI.canUnequip(slotStack, slotReference = validContainer.createReference(i)) || slotStack.method_7960() || !stack.method_7960() && (!((Boolean)additionalCheck.apply((Object)accessory, (Object)stack, (Object)slotReference)).booleanValue() || !AccessoriesAPI.canInsertIntoSlot(stack, slotReference))) continue;
                class_1799 stackCopy = stack.method_7972();
                class_1799 class_17992 = splitStack = stackCopy.method_7960() ? class_1799.field_8037 : stackCopy.method_7971(accessory.maxStackSize(stackCopy));
                if (!this.entity.method_37908().field_9236) {
                    accessories.method_5447(i, splitStack);
                    validContainer.markChanged();
                }
                return it.unimi.dsi.fastutil.Pair.of((Object)slotReference, List.of(stackCopy, slotStack));
            }
        }
        return null;
    }

    @Override
    public SlotEntryReference getFirstEquipped(Predicate<class_1799> predicate, EquipmentChecking check) {
        for (AccessoriesContainer container : this.getContainers().values()) {
            for (Pair<Integer, class_1799> stackEntry : container.getAccessories()) {
                SlotEntryReference entryReference;
                class_1799 cosmetic;
                class_1799 stack = (class_1799)stackEntry.getSecond();
                SlotReference reference = container.createReference((Integer)stackEntry.getFirst());
                if (check == EquipmentChecking.COSMETICALLY_OVERRIDABLE && !(cosmetic = container.getCosmeticAccessories().method_5438(reference.slot())).method_7960()) {
                    stack = cosmetic;
                }
                if ((entryReference = AccessoryNestUtils.recursiveStackHandling(stack, reference, (innerStack, ref) -> !innerStack.method_7960() && predicate.test((class_1799)innerStack) ? new SlotEntryReference(reference, (class_1799)innerStack) : null)) == null) continue;
                return entryReference;
            }
        }
        return null;
    }

    @Override
    public List<SlotEntryReference> getEquipped(Predicate<class_1799> predicate) {
        return this.getAllEquipped().stream().filter(reference -> predicate.test(reference.stack())).toList();
    }

    @Override
    public List<SlotEntryReference> getAllEquipped(boolean recursiveStackLookup) {
        ArrayList<SlotEntryReference> references = new ArrayList<SlotEntryReference>();
        for (AccessoriesContainer container : this.getContainers().values()) {
            for (Pair<Integer, class_1799> stackEntry : container.getAccessories()) {
                class_1799 stack = (class_1799)stackEntry.getSecond();
                if (stack.method_7960()) continue;
                SlotReference reference = container.createReference((Integer)stackEntry.getFirst());
                if (recursiveStackLookup) {
                    AccessoryNestUtils.recursiveStackConsumption(stack, reference, (innerStack, ref) -> references.add(new SlotEntryReference((SlotReference)ref, (class_1799)innerStack)));
                    continue;
                }
                references.add(new SlotEntryReference(reference, stack));
            }
        }
        return references;
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        this.holder().write(carrier, ctx);
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.holder().read(carrier, ctx);
    }

    private static /* synthetic */ void lambda$getSlotModifiers$2(Multimap modifiers, String s, AccessoriesContainer container) {
        modifiers.putAll((Object)s, container.getModifiers().values());
    }
}

