/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.commands.RecordArgumentTypeInfo;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AccessoriesCommands {
    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> class_2561.method_54159((String)"commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> class_2561.method_54159((String)"commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    public static void registerCommandArgTypes() {
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
    }

    public static class_1309 getOrThrowLivingEntity(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(ctx, (String)"entity");
        if (!(entity instanceof class_1309)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        return livingEntity;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"accessories").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Accessories.openAccessoriesMenu((class_1657)player, AccessoriesCommands.getOrThrowLivingEntity((CommandContext<class_2168>)ctx));
            return 1;
        }))).executes(ctx -> Accessories.attemptOpenScreenPlayer(((class_2168)ctx.getSource()).method_9207()) ? 1 : 0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slot").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"valid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(0, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"invalid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(1, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)"valid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(2, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"invalid").then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).executes(ctx -> AccessoriesCommands.adjustSlotValidationOnStack(3, (class_1309)((class_2168)ctx.getSource()).method_9207(), (CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stack-sizing").then(class_2170.method_9247((String)"useStackSize").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Boolean bl = (Boolean)ctx.getArgument("value", Boolean.class);
            player.method_6047().method_57368(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.useStackSize(bl));
            return 1;
        })))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            Integer size = (Integer)ctx.getArgument("value", Integer.class);
            player.method_6047().method_57368(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.sizeOverride(size));
            return 1;
        })))).then(class_2170.method_9247((String)"attribute").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modifier").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"attribute", ResourceExtendedArgument.attributes(context)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).then(AccessoriesCommands.createAddLiteral("add_value"))).then(AccessoriesCommands.createAddLiteral("add_multiplied_base"))).then(AccessoriesCommands.createAddLiteral("add_multiplied_total"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"attribute", ResourceExtendedArgument.attributes(context)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> AccessoriesCommands.removeModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"))))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"attribute", ResourceExtendedArgument.attributes(context)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> AccessoriesCommands.getAttributeModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"), 1.0))).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> AccessoriesCommands.getAttributeModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"scale"))))))))));
    }

    private static LiteralArgumentBuilder<class_2168> createAddLiteral(String literal) {
        class_1322.class_1323 selectedValue = Arrays.stream(class_1322.class_1323.values()).filter(value -> value.method_15434().equals(literal)).findFirst().orElse(null);
        if (selectedValue == null) {
            throw new IllegalStateException("Unable to handle the given literal as its not a valid AttributeModifier Operation! [Literal: " + literal + "]");
        }
        return (LiteralArgumentBuilder)class_2170.method_9247((String)literal).then(class_2170.method_9244((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).then(class_2170.method_9244((String)"isStackable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> AccessoriesCommands.addModifier((class_2168)ctx.getSource(), (class_1309)((class_2168)ctx.getSource()).method_9207(), ResourceExtendedArgument.getAttribute((CommandContext<class_2168>)ctx, "attribute"), class_2232.method_9443((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value"), selectedValue, SlotArgumentType.getSlot((CommandContext<class_2168>)ctx, "slot"), BoolArgumentType.getBool((CommandContext)ctx, (String)"isStackable")))));
    }

    private static int getAttributeModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation, double d) throws CommandSyntaxException {
        class_1799 stack = livingEntity.method_6047();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.method_57825(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        class_1322 modifier = component.getModifier(holder, resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.method_7954(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.comp_2449();
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation, double d, class_1322.class_1323 operation, String slotName, boolean isStackable) throws CommandSyntaxException {
        class_1799 stack = livingEntity.method_6047();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.method_57825(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.method_7954());
        }
        stack.method_57379(AccessoriesDataComponents.ATTRIBUTES, (Object)component.withModifierAdded(holder, new class_1322(resourceLocation, d, operation), slotName, isStackable));
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954()}), false);
        return 1;
    }

    private static int removeModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 location) throws CommandSyntaxException {
        MutableBoolean removedModifier = new MutableBoolean(false);
        class_1799 stack = livingEntity.method_6047();
        stack.method_57368(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, location)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)location, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.method_7954());
        }
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{class_2561.method_54154((class_2960)location), AccessoriesCommands.getAttributeDescription(holder), stack.method_7954()}), false);
        return 1;
    }

    private static class_2561 getAttributeDescription(class_6880<class_1320> attribute) {
        return class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
    }

    private static int adjustSlotValidationOnStack(int operation, class_1309 player, CommandContext<class_2168> ctx) {
        String slotName = SlotArgumentType.getSlot(ctx, "slot");
        player.method_6047().method_57368(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY, component -> switch (operation) {
            case 0 -> component.addValidSlot(slotName);
            case 1 -> component.addInvalidSlot(slotName);
            case 2 -> component.removeValidSlot(slotName);
            case 3 -> component.removeInvalidSlot(slotName);
            default -> throw new IllegalStateException("Unexpected value: " + operation);
        });
        return 1;
    }
}

