/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.attributes.AttributeModificationData;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class AccessoryAttributeBuilder {
    private final Map<class_2960, AttributeModificationData> exclusiveAttributes = new HashMap<class_2960, AttributeModificationData>();
    private final Multimap<class_2960, AttributeModificationData> stackedAttributes = LinkedHashMultimap.create();
    private final SlotReference slotReference;

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(SlotReference slotReference) {
        this.slotReference = slotReference;
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(String slotName, int slot) {
        this.slotReference = SlotReference.of(null, slotName, slot);
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder() {
        this.slotReference = SlotReference.of(null, "", 0);
    }

    public AccessoryAttributeBuilder addExclusive(class_6880<class_1320> attribute, class_2960 location, double amount, class_1322.class_1323 operation) {
        this.addExclusive(attribute, new class_1322(location, amount, operation));
        return this;
    }

    public AccessoryAttributeBuilder addStackable(class_6880<class_1320> attribute, class_2960 location, double amount, class_1322.class_1323 operation) {
        this.addStackable(attribute, new class_1322(location, amount, operation));
        return this;
    }

    public AccessoryAttributeBuilder addExclusive(class_6880<class_1320> attribute, class_1322 modifier) {
        this.exclusiveAttributes.putIfAbsent(modifier.comp_2447(), new AttributeModificationData(attribute, modifier));
        return this;
    }

    public AccessoryAttributeBuilder addStackable(class_6880<class_1320> attribute, class_1322 modifier) {
        this.stackedAttributes.put((Object)modifier.comp_2447(), (Object)new AttributeModificationData(AccessoryAttributeBuilder.createSlotPath(this.slotReference), attribute, modifier));
        return this;
    }

    @Nullable
    public AttributeModificationData getExclusive(class_2960 location) {
        return this.exclusiveAttributes.get(location);
    }

    public Collection<AttributeModificationData> getStacks(class_2960 location) {
        return this.stackedAttributes.get((Object)location);
    }

    public AttributeModificationData removeExclusive(class_2960 location) {
        return this.exclusiveAttributes.remove(location);
    }

    public Collection<AttributeModificationData> removeStacks(class_2960 location) {
        return this.stackedAttributes.removeAll((Object)location);
    }

    public Multimap<String, class_1322> getSlotModifiers() {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((location, uniqueInstance) -> {
            Object patt0$temp = uniqueInstance.attribute().comp_349();
            if (!(patt0$temp instanceof SlotAttribute)) {
                return;
            }
            SlotAttribute slotAttribute = (SlotAttribute)((Object)((Object)patt0$temp));
            map.put((Object)slotAttribute.slotName(), (Object)uniqueInstance.modifier());
        });
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            Object patt0$temp = stackedInstance.attribute().comp_349();
            if (!(patt0$temp instanceof SlotAttribute)) {
                return;
            }
            SlotAttribute slotAttribute = (SlotAttribute)((Object)((Object)patt0$temp));
            map.put((Object)slotAttribute.slotName(), (Object)stackedInstance.modifier());
        });
        return map;
    }

    public Multimap<class_6880<class_1320>, class_1322> getAttributeModifiers(boolean filterSlots) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((location, uniqueInstance) -> {
            if (filterSlots && uniqueInstance.attribute().comp_349() instanceof SlotAttribute) {
                return;
            }
            map.put(uniqueInstance.attribute(), (Object)uniqueInstance.modifier());
        });
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            if (filterSlots && stackedInstance.attribute().comp_349() instanceof SlotAttribute) {
                return;
            }
            map.put(stackedInstance.attribute(), (Object)stackedInstance.modifier());
        });
        return map;
    }

    public boolean isEmpty() {
        return this.exclusiveAttributes.isEmpty() && this.stackedAttributes.isEmpty();
    }

    public Map<class_2960, AttributeModificationData> exclusiveAttributes() {
        return ImmutableMap.copyOf(this.exclusiveAttributes);
    }

    public Multimap<class_2960, AttributeModificationData> stackedAttributes() {
        return ImmutableMultimap.copyOf(this.stackedAttributes);
    }

    public AccessoryAttributeBuilder addFrom(AccessoryAttributeBuilder builder) {
        builder.exclusiveAttributes.forEach(this.exclusiveAttributes::putIfAbsent);
        this.stackedAttributes.putAll(builder.stackedAttributes);
        return this;
    }

    @Deprecated
    public static String createSlotPath(SlotReference ref) {
        return ref.createSlotPath();
    }

    @Deprecated
    public static String createSlotPath(String slotname, int slot) {
        return slotname.replace(":", "-") + "/" + slot;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessoryAttributeBuilder)) {
            return false;
        }
        AccessoryAttributeBuilder otherBuilder = (AccessoryAttributeBuilder)obj;
        if (!AccessoryAttributeBuilder.areMapsEqual(this.stackedAttributes, otherBuilder.stackedAttributes)) {
            return false;
        }
        return this.exclusiveAttributes.equals(otherBuilder.exclusiveAttributes);
    }

    private static <K, V> boolean areMapsEqual(Multimap<K, V> multimap1, Multimap<K, V> multimap2) {
        for (Map.Entry entry : multimap1.asMap().entrySet()) {
            if (!((Collection)entry.getValue()).equals(multimap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

