/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesCapability {
    @Nullable
    public static AccessoriesCapability get(@NotNull class_1309 livingEntity) {
        return livingEntity.accessoriesCapability();
    }

    public static Optional<AccessoriesCapability> getOptionally(@NotNull class_1309 livingEntity) {
        return Optional.ofNullable(AccessoriesCapability.get(livingEntity));
    }

    public class_1309 entity();

    public AccessoriesHolder getHolder();

    public void reset(boolean var1);

    public Map<String, AccessoriesContainer> getContainers();

    @Nullable
    default public AccessoriesContainer getContainer(SlotType slotType) {
        return this.getContainers().get(slotType.name());
    }

    @Nullable
    default public AccessoriesContainer getContainer(SlotTypeReference reference) {
        return this.getContainers().get(reference.slotName());
    }

    public void updateContainers();

    @Nullable
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack) {
        return this.equipAccessory(stack, false, (TriFunction<Accessory, class_1799, SlotReference, Boolean>)((TriFunction)(accessory, stack1, reference) -> true));
    }

    @Nullable
    public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 var1, boolean var2, TriFunction<Accessory, class_1799, SlotReference, Boolean> var3);

    default public boolean isEquipped(class_1792 item) {
        return this.isEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(class_1792 item, EquipmentChecking check) {
        return this.isEquipped((class_1799 stack) -> stack.method_7909() == item, check);
    }

    default public boolean isEquipped(Predicate<class_1799> predicate) {
        return this.isEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Predicate<class_1799> predicate, EquipmentChecking check) {
        return this.getFirstEquipped(predicate, check) != null;
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(class_1792 item) {
        return this.getFirstEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(class_1792 item, EquipmentChecking check) {
        return this.getFirstEquipped((class_1799 stack) -> stack.method_7909() == item, check);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<class_1799> predicate) {
        return this.getFirstEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    public SlotEntryReference getFirstEquipped(Predicate<class_1799> var1, EquipmentChecking var2);

    default public List<SlotEntryReference> getEquipped(class_1792 item) {
        return this.getEquipped((class_1799 stack) -> stack.method_7909() == item);
    }

    public List<SlotEntryReference> getEquipped(Predicate<class_1799> var1);

    default public List<SlotEntryReference> getAllEquipped() {
        return this.getAllEquipped(true);
    }

    public List<SlotEntryReference> getAllEquipped(boolean var1);

    public void addTransientSlotModifiers(Multimap<String, class_1322> var1);

    public void addPersistentSlotModifiers(Multimap<String, class_1322> var1);

    public void removeSlotModifiers(Multimap<String, class_1322> var1);

    public Multimap<String, class_1322> getSlotModifiers();

    public void clearSlotModifiers();

    public void clearCachedSlotModifiers();
}

