/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.InfoUtils;
import java.io.File;
import javax.annotation.Nullable;

public class DirectoryCreator
implements IStringConsumerFeedback {
    protected final File dir;
    @Nullable
    protected final IDirectoryNavigator navigator;

    public DirectoryCreator(File dir, @Nullable IDirectoryNavigator navigator) {
        this.dir = dir;
        this.navigator = navigator;
    }

    @Override
    public boolean setString(String string) {
        if (string.isEmpty()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.invalid_directory", string);
            return false;
        }
        File file = new File(this.dir, string);
        if (file.exists()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.file_or_directory_already_exists", file.getAbsolutePath());
            return false;
        }
        if (!file.mkdirs()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.failed_to_create_directory", file.getAbsolutePath());
            return false;
        }
        if (this.navigator != null) {
            this.navigator.switchToDirectory(file);
        }
        InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.directory_created", string);
        return true;
    }
}

