/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionRenderingDebugger;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class EntryListWidget
extends WidgetWithBounds
implements OverlayListWidget,
DraggableStackVisitorWidget {
    private static final int SIZE = 18;
    protected final RegionRenderingDebugger debugger = new RegionRenderingDebugger();
    protected Rectangle bounds;
    protected Rectangle innerBounds;
    public final NumberAnimator<Double> scaleIndicator = ValueAnimator.ofDouble((double)0.0).withConvention(() -> 0.0, 8000L);

    public static int entrySize() {
        return class_3532.method_15384((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height) {
        class_310 instance = class_310.method_1551();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.field_1755)) {
            class_1269 fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    private static class_1269 canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        class_1269 fit = decider.isInZone(left, top);
        if (fit != class_1269.field_5811) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != class_1269.field_5811) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != class_1269.field_5811) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private boolean containsChecked(Point point, boolean inner) {
        return this.containsChecked(point.x, point.y, inner);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && super.containsMouse(mouseX, mouseY);
    }

    public boolean innerContainsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && this.innerBounds.contains(mouseX, mouseY);
    }

    public boolean containsChecked(double x, double y, boolean inner) {
        if (inner ? !this.innerContainsMouse(x, y) : !this.containsMouse(x, y)) {
            return false;
        }
        class_310 instance = class_310.method_1551();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.field_1755)) {
            class_1269 result = decider.isInZone(x, y);
            if (result == class_1269.field_5811) continue;
            return result == class_1269.field_5812;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int heightReduction = (int)Math.round((double)bounds.height * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundariesPercentage()));
        bounds.y += (int)Math.round((double)heightReduction * ConfigObject.getInstance().getVerticalEntriesBoundariesAlignments());
        bounds.height -= heightReduction;
        int maxHeight = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getVerticalEntriesBoundariesRows() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.height > maxHeight) {
            bounds.y += (int)Math.round((double)(bounds.height - maxHeight) * ConfigObject.getInstance().getVerticalEntriesBoundariesAlignments());
            bounds.height = maxHeight;
        }
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(class_3532.method_15375((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<class_437> context, DraggableStack stack) {
        if (this.innerBounds.contains(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.containsChecked(mouseX, mouseY, false) && amountY != 0.0 && class_437.method_25441()) {
            ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
            this.scaleIndicator.setAs(10.0);
            if (config.setEntrySize(config.getEntrySize() + amountY * 0.075)) {
                ConfigManager.getInstance().saveConfig();
                REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!this.hasSpace()) {
            return;
        }
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        this.renderEntries(fastEntryRendering, graphics, mouseX, mouseY, delta);
        this.debugger.render(graphics, this.bounds.x, this.bounds.y, delta);
        if (this.containsChecked(mouseX, mouseY, false) && ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen) && !this.minecraft.field_1724.field_7512.method_34255().method_7960() && ClientHelperImpl.getInstance().canDeleteItems()) {
            EntryStack<class_1799> stack = EntryStacks.of(this.minecraft.field_1724.field_7512.method_34255().method_7972());
            if (stack.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<class_1799> cheatsAs = stack.cheatsAs();
                stack = cheatsAs.isEmpty() ? stack : cheatsAs;
            }
            for (Widget widget : this.method_25396()) {
                EntryWidget widget2;
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create(new class_2561[]{class_2561.method_43471((String)"text.rei.delete_items")}).queue();
        }
        this.scaleIndicator.update((double)delta);
        if ((Double)this.scaleIndicator.value() > 0.04) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            class_5250 component = class_2561.method_43470((String)(Math.round(ConfigObject.getInstance().getEntrySize() * 100.0) + "%"));
            int width = this.font.method_27525((class_5348)component);
            int n = (int)Math.round(160.0 * class_3532.method_15350((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            int textColor = (int)Math.round(221.0 * class_3532.method_15350((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            graphics.method_25296(this.bounds.getCenterX() - width / 2 - 2, this.bounds.getCenterY() - 6, this.bounds.getCenterX() + width / 2 + 2, this.bounds.getCenterY() + 6, n, n);
            graphics.method_51439(this.font, (class_2561)component, this.bounds.getCenterX() - width / 2, this.bounds.getCenterY() - 4, 0xFFFFFF | textColor, false);
            graphics.method_51448().method_22909();
        }
    }

    protected abstract void renderEntries(boolean var1, class_332 var2, int var3, int var4, float var5);

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.containsChecked(EntryListWidget.mouse(), false)) {
            for (Widget widget : this.getEntryWidgets()) {
                if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(Rectangle bounds, String searchTerm) {
        this.bounds = REIRuntime.getInstance().calculateEntryListArea(bounds);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean hasSpace() {
        int height;
        int entrySize = EntryListWidget.entrySize();
        int width = this.innerBounds.width / entrySize;
        return width * (height = this.innerBounds.height / entrySize) > 0;
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        boolean zoomed = ConfigObject.getInstance().isFocusModeZoomed();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        this.updateEntries(entrySize, zoomed);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.getSystemRegion().updateEntriesPosition(entry -> true);
            favoritesListWidget.getRegion().updateEntriesPosition(entry -> true);
        }
    }

    protected abstract void updateEntries(int var1, boolean var2);

    public abstract boolean isEmpty();

    protected abstract void setCollapsedStacks(List<Object> var1);

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        EntryListSearchManager.INSTANCE.update(searchTerm, ignoreLastSearch, stacks -> {
            this.setCollapsedStacks((List<Object>)stacks);
            this.updateEntriesPosition();
        });
        this.debugger.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
    }

    public List<? extends Widget> method_25396() {
        return this.getEntryWidgets();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        for (Widget widget : this.method_25396()) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen) && player != null && player.field_7512 != null && !player.field_7512.method_34255().method_7960() && ClientHelperImpl.getInstance().canDeleteItems()) {
                boolean bl;
                EntryStack<class_1799> stack = EntryStacks.of(this.minecraft.field_1724.field_7512.method_34255().method_7972());
                if (stack.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<class_1799> entryStack = stack.cheatsAs();
                    stack = entryStack.isEmpty() ? stack : entryStack;
                }
                boolean bl2 = true;
                for (Widget widget : this.method_25396()) {
                    EntryWidget widget2;
                    if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ClientHelper.getInstance().sendDeletePacket();
                    return true;
                }
            }
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25406(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = EntryListWidget.mouse();
        if (this.containsChecked(mouse, false)) {
            for (Slot slot : this.getEntryWidgets()) {
                EntryStack<?> currentEntry = slot.getCurrentEntry();
                if (currentEntry.isEmpty() || !slot.containsMouse(mouse)) continue;
                return currentEntry.copy();
            }
        }
        return EntryStack.empty();
    }

    protected abstract List<EntryListStackEntry> getEntryWidgets();

    public void init(ScreenOverlayImpl overlay) {
    }
}

