/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier3;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class ChunkLoaderBlockEntity
extends MachineBaseBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public final RebornInventory<ChunkLoaderBlockEntity> inventory = new RebornInventory(0, "ChunkLoaderBlockEntity", 64, (MachineBaseBlockEntity)this);
    private int radius = 1;
    private String ownerUdid;

    public ChunkLoaderBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.CHUNK_LOADER, pos, state);
    }

    public void handleGuiInputFromClient(int buttonID, @Nullable class_1657 playerEntity) {
        this.radius += buttonID;
        if (this.radius > TechRebornConfig.chunkLoaderMaxRadius) {
            this.radius = TechRebornConfig.chunkLoaderMaxRadius;
        }
        if (this.radius <= 1) {
            this.radius = 1;
        }
        this.reload();
        if (playerEntity != null) {
            ChunkLoaderManager manager = ChunkLoaderManager.get((class_1937)this.method_10997());
            manager.syncChunkLoaderToClient((class_3222)playerEntity, this.method_11016());
        }
    }

    private void reload() {
        this.unloadAll();
        this.load();
    }

    private void load() {
        ChunkLoaderManager manager = ChunkLoaderManager.get((class_1937)this.method_10997());
        class_1923 rootPos = this.getChunkPos();
        int loadRadius = this.radius - 1;
        for (int i = -loadRadius; i <= loadRadius; ++i) {
            for (int j = -loadRadius; j <= loadRadius; ++j) {
                class_1923 loadPos = new class_1923(rootPos.field_9181 + i, rootPos.field_9180 + j);
                if (manager.isChunkLoaded(this.method_10997(), loadPos, this.method_11016())) continue;
                manager.loadChunk(this.method_10997(), loadPos, this.method_11016(), this.ownerUdid);
            }
        }
    }

    private void unloadAll() {
        ChunkLoaderManager manager = ChunkLoaderManager.get((class_1937)this.field_11863);
        manager.unloadChunkLoader(this.field_11863, this.method_11016());
    }

    public class_1923 getChunkPos() {
        return new class_1923(this.method_11016());
    }

    public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState) {
        if (world.field_9236) {
            return;
        }
        this.unloadAll();
        ChunkLoaderManager.get((class_1937)world).clearClient((class_3222)playerEntity);
    }

    public void onPlace(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        this.ownerUdid = placer.method_5845();
        if (worldIn.field_9236) {
            return;
        }
        this.reload();
    }

    public void method_11007(class_2487 tagCompound, class_7225.class_7874 registryLookup) {
        super.method_11007(tagCompound, registryLookup);
        tagCompound.method_10569("radius", this.radius);
        if (this.ownerUdid != null && !this.ownerUdid.isEmpty()) {
            tagCompound.method_10582("ownerUdid", this.ownerUdid);
        }
        this.inventory.write(tagCompound);
    }

    public void method_11014(class_2487 nbtCompound, class_7225.class_7874 registryLookup) {
        super.method_11014(nbtCompound, registryLookup);
        this.radius = nbtCompound.method_10550("radius");
        this.ownerUdid = nbtCompound.method_10558("ownerUdid");
        if (!StringUtils.isBlank((CharSequence)this.ownerUdid)) {
            nbtCompound.method_10582("ownerUdid", this.ownerUdid);
        }
        this.inventory.read(nbtCompound, registryLookup);
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.CHUNK_LOADER.getStack();
    }

    public RebornInventory<ChunkLoaderBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("chunkloader").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).sync(class_9135.field_49675, this::getRadius, this::setRadius).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

