/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IInputManager;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_310;

public class InputEventHandler
implements IKeybindManager,
IInputManager {
    private static final InputEventHandler INSTANCE = new InputEventHandler();
    private final class_310 mc;
    private final Multimap<Integer, IKeybind> hotkeyMap = ArrayListMultimap.create();
    private final List<KeybindCategory> allKeybinds = new ArrayList<KeybindCategory>();
    private final List<IKeybindProvider> keybindProviders = new ArrayList<IKeybindProvider>();
    private final List<IKeyboardInputHandler> keyboardHandlers = new ArrayList<IKeyboardInputHandler>();
    private final List<IMouseInputHandler> mouseHandlers = new ArrayList<IMouseInputHandler>();
    private double mouseWheelDeltaSum;

    private InputEventHandler() {
        this.mc = class_310.method_1551();
    }

    public static IKeybindManager getKeybindManager() {
        return INSTANCE;
    }

    public static IInputManager getInputManager() {
        return INSTANCE;
    }

    @Override
    public void registerKeybindProvider(IKeybindProvider provider) {
        if (!this.keybindProviders.contains(provider)) {
            this.keybindProviders.add(provider);
        }
        provider.addHotkeys(this);
    }

    @Override
    public void unregisterKeybindProvider(IKeybindProvider provider) {
        this.keybindProviders.remove(provider);
    }

    @Override
    public List<KeybindCategory> getKeybindCategories() {
        return this.allKeybinds;
    }

    @Override
    public void updateUsedKeys() {
        this.hotkeyMap.clear();
        for (IKeybindProvider handler : this.keybindProviders) {
            handler.addKeysToMap(this);
        }
    }

    @Override
    public void addKeybindToMap(IKeybind keybind) {
        List<Integer> keys = keybind.getKeys();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.hotkeyMap.put((Object)key, (Object)keybind);
        }
    }

    @Override
    public void addHotkeysForCategory(String modName, String keyCategory, List<? extends IHotkey> hotkeys) {
        KeybindCategory cat = new KeybindCategory(modName, keyCategory, hotkeys);
        this.allKeybinds.remove(cat);
        this.allKeybinds.add(cat);
    }

    @Override
    public void registerKeyboardInputHandler(IKeyboardInputHandler handler) {
        if (!this.keyboardHandlers.contains(handler)) {
            this.keyboardHandlers.add(handler);
        }
    }

    @Override
    public void unregisterKeyboardInputHandler(IKeyboardInputHandler handler) {
        this.keyboardHandlers.remove(handler);
    }

    @Override
    public void registerMouseInputHandler(IMouseInputHandler handler) {
        if (!this.mouseHandlers.contains(handler)) {
            this.mouseHandlers.add(handler);
        }
    }

    @Override
    public void unregisterMouseInputHandler(IMouseInputHandler handler) {
        this.mouseHandlers.remove(handler);
    }

    public boolean onKeyInput(int keyCode, int scanCode, int modifiers, int action) {
        boolean eventKeyState = action != 0;
        KeybindMulti.onKeyInputPre(keyCode, scanCode, modifiers, action);
        boolean cancel = this.checkKeyBindsForChanges(keyCode);
        if (!this.keyboardHandlers.isEmpty()) {
            for (IKeyboardInputHandler handler : this.keyboardHandlers) {
                if (!handler.onKeyInput(keyCode, scanCode, modifiers, eventKeyState)) continue;
                this.printInputCancellationDebugMessage(handler);
                return true;
            }
        }
        return cancel;
    }

    public boolean onMouseClick(int mouseX, int mouseY, int eventButton, int action) {
        boolean cancel = false;
        if (eventButton != -1) {
            boolean eventButtonState = action == 1;
            KeybindMulti.onKeyInputPre(eventButton - 100, 0, 0, action);
            cancel = this.checkKeyBindsForChanges(eventButton - 100);
            if (!this.mouseHandlers.isEmpty()) {
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    if (!handler.onMouseClick(mouseX, mouseY, eventButton, eventButtonState)) continue;
                    this.printInputCancellationDebugMessage(handler);
                    return true;
                }
            }
        }
        return cancel;
    }

    private void printInputCancellationDebugMessage(Object handler) {
        if (MaLiLibConfigs.Debug.INPUT_CANCELLATION_DEBUG.getBooleanValue()) {
            String msg = String.format("Cancel requested by input handler '%s'", handler.getClass().getName());
            InfoUtils.showInGameMessage(Message.MessageType.INFO, msg, new Object[0]);
            MaLiLib.logger.info(msg);
        }
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double xOffset, double yOffset) {
        boolean discrete = (Boolean)this.mc.field_1690.method_42439().method_41753();
        double sensitivity = (Double)this.mc.field_1690.method_41806().method_41753();
        double amount = (discrete ? Math.signum(yOffset) : yOffset) * sensitivity;
        if (MaLiLibConfigs.Debug.MOUSE_SCROLL_DEBUG.getBooleanValue()) {
            int time = (int)(System.currentTimeMillis() & 0xFFFFL);
            int tick = this.mc.field_1687 != null ? (int)(this.mc.field_1687.method_8510() & 0xFFFFL) : 0;
            String timeStr = String.format("time: %04X, tick: %04X", time, tick);
            MaLiLib.logger.info("{} - xOffset: {}, yOffset: {}, discrete: {}, sensitivity: {}, amount: {}", (Object)timeStr, (Object)xOffset, (Object)yOffset, (Object)discrete, (Object)sensitivity, (Object)amount);
        }
        if (amount != 0.0 && !this.mouseHandlers.isEmpty()) {
            if (this.mouseWheelDeltaSum != 0.0 && Math.signum(amount) != Math.signum(this.mouseWheelDeltaSum)) {
                this.mouseWheelDeltaSum = 0.0;
            }
            this.mouseWheelDeltaSum += amount;
            amount = (int)this.mouseWheelDeltaSum;
            if (amount != 0.0) {
                this.mouseWheelDeltaSum -= amount;
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    if (!handler.onMouseScroll(mouseX, mouseY, amount)) continue;
                    this.printInputCancellationDebugMessage(handler);
                    return true;
                }
            }
        }
        return false;
    }

    public void onMouseMove(int mouseX, int mouseY) {
        if (!this.mouseHandlers.isEmpty()) {
            for (IMouseInputHandler handler : this.mouseHandlers) {
                handler.onMouseMove(mouseX, mouseY);
            }
        }
    }

    private boolean checkKeyBindsForChanges(int eventKey) {
        boolean cancel = false;
        Collection keybinds = this.hotkeyMap.get((Object)eventKey);
        if (!keybinds.isEmpty()) {
            for (IKeybind keybind : keybinds) {
                cancel |= keybind.updateIsPressed();
            }
        }
        return cancel;
    }
}

