/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.mixin.IMixinDataQueryHandler;
import fi.dy.masa.minihud.network.ServuxEntitiesHandler;
import fi.dy.masa.minihud.network.ServuxEntitiesPacket;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.EntityUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class EntitiesDataStorage
implements IClientTickHandler {
    private static final EntitiesDataStorage INSTANCE = new EntitiesDataStorage();
    private static final ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> HANDLER = ServuxEntitiesHandler.getInstance();
    private static final class_310 mc = class_310.method_1551();
    private int uptimeTicks = 0;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion;
    private long serverTickTime = 0L;
    private Set<class_2338> pendingBlockEntitiesQueue = new LinkedHashSet<class_2338>();
    private Set<Integer> pendingEntitiesQueue = new LinkedHashSet<Integer>();
    private Map<Integer, Either<class_2338, Integer>> transactionToBlockPosOrEntityId = new HashMap<Integer, Either<class_2338, Integer>>();

    public static EntitiesDataStorage getInstance() {
        return INSTANCE;
    }

    @Nullable
    public class_1937 getWorld() {
        return EntitiesDataStorage.mc.field_1687;
    }

    private EntitiesDataStorage() {
    }

    public void onClientTick(class_310 mc) {
        ++this.uptimeTicks;
        if (System.currentTimeMillis() - this.serverTickTime > 50L) {
            if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                this.serverTickTime = System.currentTimeMillis();
                return;
            }
            for (int i = 0; i < Configs.Generic.SERVER_NBT_REQUEST_RATE.getIntegerValue(); ++i) {
                Iterator<Object> iter;
                if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                    iter = this.pendingBlockEntitiesQueue.iterator();
                    class_2338 pos = iter.next();
                    iter.remove();
                    if (this.hasServuxServer()) {
                        this.requestServuxBlockEntityData(pos);
                    } else {
                        this.requestQueryBlockEntity(pos);
                    }
                }
                if (this.pendingEntitiesQueue.isEmpty()) continue;
                iter = this.pendingEntitiesQueue.iterator();
                int entityId = (Integer)iter.next();
                iter.remove();
                if (this.hasServuxServer()) {
                    this.requestServuxEntityData(entityId);
                    continue;
                }
                this.requestQueryEntityData(entityId);
            }
            this.serverTickTime = System.currentTimeMillis();
        }
    }

    public class_2960 getNetworkChannel() {
        return ServuxEntitiesHandler.CHANNEL_ID;
    }

    private static class_634 getVanillaHandler() {
        if (EntitiesDataStorage.mc.field_1724 != null) {
            return EntitiesDataStorage.mc.field_1724.field_3944;
        }
        return null;
    }

    public IPluginClientPlayHandler<ServuxEntitiesPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.printDebug("EntitiesDataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
        } else {
            MiniHUD.printDebug("EntitiesDataStorage#reset() - dimension change or log-in", new Object[0]);
        }
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        this.hasInValidServux = false;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void setServuxVersion(String ver) {
        if (ver != null && !ver.isEmpty()) {
            this.servuxVersion = ver;
            MiniHUD.printDebug("entityDataChannel: joining Servux version {}", ver);
        } else {
            this.servuxVersion = "unknown";
        }
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxEntitiesPacket.Payload.ID, ServuxEntitiesPacket.Payload.CODEC, 6);
    }

    public void onWorldPre() {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxEntitiesPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
    }

    public void requestMetadata() {
        if (!DataStorage.getInstance().hasIntegratedServer() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxEntitiesPacket.MetadataRequest(nbt));
        }
    }

    public boolean receiveServuxMetadata(class_2487 data) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            MiniHUD.printDebug("EntitiesDataStorage#receiveServuxMetadata(): received METADATA from Servux", new Object[0]);
            if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                if (data.method_10550("version") != 1) {
                    MiniHUD.logger.warn("entityDataChannel: Mis-matched protocol version!");
                }
                this.setServuxVersion(data.method_10558("servux"));
                this.setIsServuxServer();
                return true;
            }
        }
        return false;
    }

    public void onPacketFailure() {
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    public void requestBlockEntity(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_26204() instanceof class_2343) {
            this.pendingBlockEntitiesQueue.add(pos);
        }
    }

    public void requestEntity(int entityId) {
        this.pendingEntitiesQueue.add(entityId);
    }

    private void requestQueryBlockEntity(class_2338 pos) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        class_634 handler = this.getVanillaHandler();
        if (handler != null) {
            handler.method_2876().method_1403(pos, nbtCompound -> this.handleBlockEntityData(pos, (class_2487)nbtCompound, null));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.method_2876()).currentTransactionId(), (Either<class_2338, Integer>)Either.left((Object)pos));
        }
    }

    private void requestQueryEntityData(int entityId) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        class_634 handler = this.getVanillaHandler();
        if (handler != null) {
            handler.method_2876().method_1405(entityId, nbtCompound -> this.handleEntityData(entityId, (class_2487)nbtCompound));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.method_2876()).currentTransactionId(), (Either<class_2338, Integer>)Either.right((Object)entityId));
        }
    }

    private void requestServuxBlockEntityData(class_2338 pos) {
        if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            return;
        }
        HANDLER.encodeClientData(ServuxEntitiesPacket.BlockEntityRequest(pos));
    }

    private void requestServuxEntityData(int entityId) {
        if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            return;
        }
        HANDLER.encodeClientData(ServuxEntitiesPacket.EntityRequest(entityId));
    }

    @Nullable
    public class_2586 handleBlockEntityData(class_2338 pos, class_2487 nbt, @Nullable class_2960 type) {
        class_2586 blockEntity2;
        this.pendingBlockEntitiesQueue.remove(pos);
        if (nbt == null || this.getWorld() == null) {
            return null;
        }
        class_2586 blockEntity = this.getWorld().method_8321(pos);
        if (blockEntity != null && (type == null || type.equals((Object)class_2591.method_11033((class_2591)blockEntity.method_11017())))) {
            blockEntity.method_58690(nbt, (class_7225.class_7874)this.getWorld().method_30349());
            return blockEntity;
        }
        class_2591 beType = (class_2591)class_7923.field_41181.method_10223(type);
        if (beType != null && beType.method_20526(this.getWorld().method_8320(pos)) && (blockEntity2 = beType.method_11032(pos, this.getWorld().method_8320(pos))) != null) {
            blockEntity2.method_58690(nbt, (class_7225.class_7874)this.getWorld().method_30349());
            this.getWorld().method_8438(blockEntity2);
            return blockEntity2;
        }
        return null;
    }

    @Nullable
    public class_1297 handleEntityData(int entityId, class_2487 nbt) {
        this.pendingEntitiesQueue.remove(entityId);
        if (nbt == null || this.getWorld() == null) {
            return null;
        }
        class_1297 entity = this.getWorld().method_8469(entityId);
        if (entity != null) {
            EntityUtils.loadNbtIntoEntity(entity, nbt);
        }
        return entity;
    }

    public void handleBulkEntityData(int transactionId, class_2487 nbt) {
    }

    public void handleVanillaQueryNbt(int transactionId, class_2487 nbt) {
        Either<class_2338, Integer> either = this.transactionToBlockPosOrEntityId.remove(transactionId);
        if (either != null) {
            either.ifLeft(pos -> this.handleBlockEntityData((class_2338)pos, nbt, null)).ifRight(entityId -> this.handleEntityData((int)entityId, nbt));
        }
    }

    public JsonObject toJson() {
        return new JsonObject();
    }

    public void fromJson(JsonObject obj) {
    }
}

