/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigNotifiable;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import javax.annotation.Nullable;

public enum RendererToggle implements IHotkeyTogglable,
IConfigNotifiable<IConfigBoolean>
{
    OVERLAY_BEACON_RANGE("overlayBeaconRange", "", "Toggle the Beacon Range overlay renderer", "Beacon Range overlay"),
    OVERLAY_BIOME_BORDER("overlayBiomeBorder", "", "Toggle the Biome Border overlay renderer", "Biome Border overlay"),
    OVERLAY_BLOCK_GRID("overlayBlockGrid", "", "Toggle the Block Grid overlay renderer", "Block Grid overlay"),
    OVERLAY_CONDUIT_RANGE("overlayConduitRange", "", "Toggle the Conduit Range overlay renderer", "Conduit Range overlay"),
    OVERLAY_LIGHT_LEVEL("overlayLightLevel", "", "Toggle the Light Level overlay renderer", "Light Level overlay"),
    OVERLAY_RANDOM_TICKS_FIXED("overlayRandomTicksFixed", "", "Toggle the fixed-point random ticked chunks overlay renderer", "Random Ticked Chunks (fixed) overlay"),
    OVERLAY_RANDOM_TICKS_PLAYER("overlayRandomTicksPlayer", "", "Toggle the player-following random ticked chunks overlay renderer", "Random Ticked Chunks (player-following) overlay"),
    OVERLAY_REGION_FILE("overlayRegionFile", "", "Toggle the region file border overlay renderer", "Region File Border overlay"),
    OVERLAY_SLIME_CHUNKS_OVERLAY("overlaySlimeChunks", "", KeybindSettings.INGAME_BOTH, "Toggle the Slime Chunk overlay renderer", "Slime Chunks overlay"),
    OVERLAY_SPAWNABLE_COLUMN_HEIGHTS("overlaySpawnableColumnHeights", "", "Toggle the spawnable column heights overlay renderer", "Spawnable column heights overlay"),
    OVERLAY_SPAWN_CHUNK_OVERLAY_REAL("overlaySpawnChunkReal", "", "Toggle the spawn chunks overlay renderer", "Spawn Chunks (real) overlay"),
    OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER("overlaySpawnChunkPlayer", "", "Toggle the pseudo (player-following) spawn chunks overlay renderer", "Spawn Chunks (player-following, would-be) overlay"),
    OVERLAY_STRUCTURE_MAIN_TOGGLE("overlayStructureMainToggle", "", "Main toggle for all structure bounding boxes", "Structure Bounding Boxes main"),
    OVERLAY_VILLAGER_INFO("overlayVillagerInfo", "", "Toggle the villager offers render.\nDisplays he enchantment books it sells.", "Villager offers overlay"),
    SHAPE_RENDERER("shapeRenderer", "", "The main toggle for the shape renderer", "Shape Renderer"),
    DEBUG_CHUNK_BORDER("debugChunkBorder", "", "Toggles the vanilla Chunk Border debug renderer", "Chunk Border"),
    DEBUG_CHUNK_INFO("debugChunkInfo", "", "Toggles the vanilla Chunk Info debug renderer", "Chunk Info"),
    DEBUG_CHUNK_OCCLUSION("debugChunkOcclusion", "", "Toggles the vanilla Chunk Occlusion debug renderer", "Chunk Occlusion"),
    DEBUG_COLLISION_BOXES("debugCollisionBoxEnabled", "", "Toggles the vanilla Block Collision Boxes debug renderer", "Block Collision Boxes"),
    DEBUG_NEIGHBOR_UPDATES("debugNeighborsUpdateEnabled", "", "Toggles the vanilla Block Neighbor Updates debug renderer", "Block Neighbor Updates"),
    DEBUG_SOLID_FACES("debugSolidFaceEnabled", "", "Toggles the vanilla Block Solid Faces debug renderer", "Block Solid Faces"),
    DEBUG_WATER("debugWaterEnabled", "", "Toggles the vanilla Water debug renderer", "Water");

    public static final ImmutableList<RendererToggle> VALUES;
    private final String name;
    private final String prettyName;
    private final String comment;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private boolean valueBoolean;
    @Nullable
    private IValueChangeCallback<IConfigBoolean> callback;

    private RendererToggle(String name, String defaultHotkey, String comment, String prettyName) {
        this(name, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName);
    }

    private RendererToggle(String name, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        this.name = name;
        this.prettyName = prettyName;
        this.comment = comment;
        this.defaultValueBoolean = false;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback(this::toggleValueWithMessage);
    }

    private boolean toggleValueWithMessage(KeyAction action, IKeybind key) {
        InfoUtils.printBooleanConfigToggleMessage((String)this.getPrettyName(), (!this.valueBoolean ? 1 : 0) != 0);
        this.setBooleanValue(!this.valueBoolean);
        return true;
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getStringValue() {
        return String.valueOf(this.valueBoolean);
    }

    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValueBoolean);
    }

    public String getComment() {
        return StringUtils.getTranslatedOrFallback((String)("config.comment." + this.getName().toLowerCase()), (String)this.comment);
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        boolean oldValue = this.valueBoolean;
        this.valueBoolean = value;
        if (oldValue != this.valueBoolean) {
            this.onValueChanged();
        }
    }

    public void setValueChangeCallback(IValueChangeCallback<IConfigBoolean> callback) {
        this.callback = callback;
    }

    public void onValueChanged() {
        if (this.callback != null) {
            this.callback.onValueChanged((IConfigBase)this);
        }
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public boolean isModified() {
        return this.valueBoolean != this.defaultValueBoolean;
    }

    public boolean isModified(String newValue) {
        return !String.valueOf(this.defaultValueBoolean).equals(newValue);
    }

    public void resetToDefault() {
        this.valueBoolean = this.defaultValueBoolean;
    }

    public void setValueFromString(String value) {
        try {
            this.valueBoolean = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.valueBoolean = element.getAsBoolean();
            } else {
                MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName());
            }
        }
        catch (Exception e) {
            MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])RendererToggle.values());
    }
}

