/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.mixin.config;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import malte0811.ferritecore.mixin.config.FerriteConfig;
import malte0811.ferritecore.util.Constants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public abstract class FerriteMixinConfig
implements IMixinConfigPlugin {
    protected static final Logger LOGGER = LogManager.getLogger((String)"ferritecore-mixin");
    private static final boolean HAS_LITHIUM = FerriteMixinConfig.hasClass("me.jellysquid.mods.lithium.common.LithiumMod");
    private static final boolean HAS_ROADRUNNER = FerriteMixinConfig.hasClass("me.jellysquid.mods.lithium.common.RoadRunner");
    private String prefix = null;
    private final FerriteConfig.Option enableOption;
    private final LithiumSupportState lithiumState;
    private final boolean optIn;

    protected FerriteMixinConfig(FerriteConfig.Option enableOption, LithiumSupportState lithiumCompat, boolean optIn) {
        this.enableOption = enableOption;
        this.lithiumState = lithiumCompat;
        this.optIn = optIn;
    }

    protected FerriteMixinConfig(FerriteConfig.Option enableOption) {
        this(enableOption, LithiumSupportState.NO_CONFLICT, false);
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Preconditions.checkState((boolean)mixinClassName.startsWith(this.prefix), (Object)("Unexpected prefix on " + mixinClassName));
        if (!this.enableOption.isEnabled()) {
            if (!this.optIn) {
                LOGGER.warn("Mixin " + mixinClassName + " is disabled by config");
            }
            return false;
        }
        if (!this.lithiumState.shouldApply()) {
            LOGGER.warn("Mixin " + mixinClassName + " is disabled automatically as lithium is installed");
            return false;
        }
        if (this.optIn) {
            LOGGER.warn("Opt-in mixin {} is enabled by config", (Object)mixinClassName);
        }
        return true;
    }

    public void onLoad(String mixinPackage) {
        this.prefix = mixinPackage + ".";
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (mixinClassName.equals("malte0811.ferritecore.mixin.fastmap.FastMapStateHolderMixin")) {
            this.replaceStateHolderValuesType(targetClass);
        }
    }

    private void replaceStateHolderValuesType(ClassNode targetClass) {
        String oldType = "it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap";
        String newType = "it/unimi/dsi/fastutil/objects/Reference2ObjectMap";
        String fieldNameToReplace = Constants.PLATFORM_HOOKS.computeStateHolderValuesName();
        FieldNode valuesFieldNode = this.getFieldNode(targetClass, fieldNameToReplace);
        valuesFieldNode.desc = valuesFieldNode.desc.replace("it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap", "it/unimi/dsi/fastutil/objects/Reference2ObjectMap");
        if (valuesFieldNode.signature != null) {
            valuesFieldNode.signature = valuesFieldNode.signature.replace("it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap", "it/unimi/dsi/fastutil/objects/Reference2ObjectMap");
        }
        for (MethodNode method : targetClass.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                if (insn instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                    if (fieldInsn.name.equals(fieldNameToReplace)) {
                        fieldInsn.desc = fieldInsn.desc.replace("it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap", "it/unimi/dsi/fastutil/objects/Reference2ObjectMap");
                        continue;
                    }
                }
                if (insn.getOpcode() == 182 && insn instanceof MethodInsnNode) {
                    MethodInsnNode call = (MethodInsnNode)insn;
                    if (!call.owner.contains("it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap")) continue;
                    call.owner = call.owner.replace("it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap", "it/unimi/dsi/fastutil/objects/Reference2ObjectMap");
                    call.setOpcode(185);
                    call.itf = true;
                    continue;
                }
                if (insn.getOpcode() != 192 || !(insn instanceof TypeInsnNode)) continue;
                TypeInsnNode cast = (TypeInsnNode)insn;
                cast.desc = cast.desc.replace("it/unimi/dsi/fastutil/objects/Reference2ObjectArrayMap", "it/unimi/dsi/fastutil/objects/Reference2ObjectMap");
            }
        }
    }

    private FieldNode getFieldNode(ClassNode clazz, String fieldName) {
        for (FieldNode field : clazz.fields) {
            if (!field.name.equals(fieldName)) continue;
            return field;
        }
        String fields = clazz.fields.stream().map(n -> n.name).reduce((s1, s2) -> s1 + ", " + s2).orElse("[None]");
        throw new RuntimeException("Failed to find field with name " + fieldName + " in " + clazz.name + ", available fields are " + fields);
    }

    private static boolean hasClass(String name) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(name);
            return true;
        }
        catch (IOException | ClassNotFoundException e) {
            return false;
        }
    }

    static String test(Map<String, String> m, String k) {
        return m.get(k);
    }

    protected static enum LithiumSupportState {
        NO_CONFLICT,
        INCOMPATIBLE,
        APPLY_IF_ROADRUNNER;


        private boolean shouldApply() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> {
                    if (!HAS_LITHIUM) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> !HAS_LITHIUM || HAS_ROADRUNNER;
            };
        }
    }
}

