/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IItemUseListener;
import de.cech12.usefulhats.item.ILivingJumpListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class BunnyEarsItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IItemUseListener,
ILivingJumpListener {
    private static final int JUMP_BOOST_DURATION = 219;

    public BunnyEarsItem() {
        super(HatArmorMaterials.BUNNY, BunnyEarsItem.rawColorFromRGB(142, 120, 94), Services.CONFIG::getBunnyEarsDurability, Services.CONFIG::isBunnyEarsDamageEnabled);
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, context, tooltip, flagIn);
        int enchantmentLevel = CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131) + 1;
        tooltip.add((class_2561)class_2561.method_43469((String)"item.usefulhats.bunny_ears.desc.jump_boost", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).method_27692(class_124.field_1078));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.usefulhats.bunny_ears.desc.eating", (Object[])new Object[]{enchantmentLevel + 1}).method_27692(class_124.field_1078));
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slot, boolean selectedIndex) {
        if (!level.field_9236 && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int amplifier = CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131);
            if (!(this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5913, 219, amplifier) || livingEntity.method_6112(class_1294.field_5913) != null && livingEntity.field_6012 % 19 != 0)) {
                this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5913, 219, amplifier);
            }
        }
    }

    @Override
    public int onItemUseEventStart(class_1309 entity, class_1799 usedStack, int actualDuration, class_1799 headSlotItemStack) {
        if (usedStack.method_57826(class_9334.field_50075)) {
            int amplifier = CommonLoader.getEnchantmentLevel(headSlotItemStack, (class_5321<class_1887>)class_1893.field_9131) + 2;
            this.damageHatItemByOne(headSlotItemStack, entity);
            return actualDuration / amplifier;
        }
        return actualDuration;
    }

    @Override
    public void onUnequippedHatItem(class_1309 entity, class_1799 oldStack) {
        int amplifier = CommonLoader.getEnchantmentLevel(oldStack, (class_5321<class_1887>)class_1893.field_9131);
        this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5913, 219, amplifier);
    }

    @Override
    public void onLivingJumpEvent(class_1309 jumpingEntity, class_1799 headSlotItemStack) {
        int amplifier = CommonLoader.getEnchantmentLevel(headSlotItemStack, (class_5321<class_1887>)class_1893.field_9131);
        if (!this.isEffectCausedByOtherSource(jumpingEntity, (class_6880<class_1291>)class_1294.field_5913, 219, amplifier)) {
            this.damageHatItemByOne(headSlotItemStack, jumpingEntity);
        }
    }
}

