/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.conversation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import nl.enjarai.cicada.api.conversation.Conversation;
import nl.enjarai.cicada.api.conversation.Line;
import nl.enjarai.cicada.api.conversation.conditions.LineCondition;
import nl.enjarai.cicada.api.conversation.conditions.TrueCondition;
import nl.enjarai.cicada.api.util.ProperLogger;
import nl.enjarai.cicada.api.util.Util;

public class SimpleLine
implements Line {
    public static final Function<String, Consumer<String>> DEFAULT_LOGGER = Util.memoize(((Function<String, ProperLogger>)ProperLogger::getLogger).andThen(logger -> logger::info));
    public static final Codec<SimpleLine> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("order").forGetter(SimpleLine::getOrder), (App)LineCondition.CODEC.optionalFieldOf("condition", (Object)new TrueCondition()).forGetter(SimpleLine::getCondition), (App)Codec.STRING.fieldOf("text").forGetter(SimpleLine::getText), (App)Codec.STRING.optionalFieldOf("author_override").forGetter(SimpleLine::getAuthorOverride)).apply((Applicative)instance, SimpleLine::new));
    private Conversation conversation;
    private Consumer<String> sourceLogger;
    private final int order;
    private final LineCondition condition;
    private final String text;
    private final Optional<String> authorOverride;

    public SimpleLine(int order, LineCondition condition, String text, Optional<String> authorOverride) {
        this.order = order;
        this.condition = condition;
        this.text = text;
        this.authorOverride = authorOverride;
    }

    public void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    public void setSourceLogger(Consumer<String> sourceLogger) {
        this.sourceLogger = sourceLogger;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean isConditionMet() {
        return this.condition.test(this.conversation);
    }

    protected LineCondition getCondition() {
        return this.condition;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Optional<String> getAuthorOverride() {
        return this.authorOverride;
    }

    @Override
    public void run() {
        this.getAuthorOverride().ifPresentOrElse(s -> DEFAULT_LOGGER.apply((String)s).accept(this.text), () -> this.sourceLogger.accept(this.text));
    }
}

