/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.lists;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;

public class VisibleChunkCollector
implements OcclusionCuller.Visitor {
    private final ObjectArrayList<ChunkRenderList> sortedRenderLists;
    private final EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>> sortedRebuildLists;
    private final int frame;

    public VisibleChunkCollector(int frame) {
        this.frame = frame;
        this.sortedRenderLists = new ObjectArrayList();
        this.sortedRebuildLists = new EnumMap(ChunkUpdateType.class);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.sortedRebuildLists.put(type, new ArrayDeque());
        }
    }

    @Override
    public void visit(RenderSection section, boolean visible) {
        RenderRegion region = section.getRegion();
        ChunkRenderList renderList = region.getRenderList();
        if (renderList.getLastVisibleFrame() != this.frame) {
            renderList.reset(this.frame);
            this.sortedRenderLists.add((Object)renderList);
        }
        if (visible && section.getFlags() != 0) {
            renderList.add(section);
        }
        this.addToRebuildLists(section);
    }

    private void addToRebuildLists(RenderSection section) {
        Queue queue;
        ChunkUpdateType type = section.getPendingUpdate();
        if (type != null && section.getBuildCancellationToken() == null && (queue = (Queue)this.sortedRebuildLists.get((Object)type)).size() < type.getMaximumQueueSize()) {
            queue.add(section);
        }
    }

    public SortedRenderLists createRenderLists() {
        return new SortedRenderLists(this.sortedRenderLists);
    }

    public Map<ChunkUpdateType, ArrayDeque<RenderSection>> getRebuildLists() {
        return this.sortedRebuildLists;
    }
}

