/*
 * Decompiled with CFR 0.152.
 */
package artifacts.fabric.platform;

import artifacts.Artifacts;
import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.component.AbilityToggles;
import artifacts.component.SwimData;
import artifacts.fabric.client.CosmeticsHelper;
import artifacts.fabric.integration.TrinketsIntegration;
import artifacts.fabric.registry.ModAttributesFabric;
import artifacts.fabric.registry.ModComponents;
import artifacts.fabric.registry.ModDataComponentsFabric;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3486;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public Stream<class_1799> findAllEquippedBy(class_1309 entity, Predicate<class_1799> predicate) {
        ArrayList<class_1799> armor = new ArrayList<class_1799>(4);
        for (class_1799 stack : entity.method_56674()) {
            if (!predicate.test(stack)) continue;
            armor.add(stack);
        }
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return Stream.concat(TrinketsIntegration.findAllEquippedBy(entity).filter(predicate), armor.stream());
        }
        return armor.stream();
    }

    @Override
    public void iterateEquippedItems(class_1309 entity, Consumer<class_1799> consumer) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            TrinketsIntegration.iterateEquippedTrinkets(entity, consumer);
        }
        for (class_1799 item : entity.method_56674()) {
            if (item.method_7960()) continue;
            consumer.accept(item);
        }
    }

    @Override
    public <T> T reduceItems(class_1309 entity, T init, BiFunction<class_1799, T, T> f) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            init = TrinketsIntegration.reduceTrinkets(entity, init, f);
        }
        for (class_1799 item : entity.method_56674()) {
            if (item.method_7960()) continue;
            init = f.apply(item, (class_1799)init);
        }
        return init;
    }

    @Override
    public boolean tryEquipInFirstSlot(class_1309 entity, class_1799 item) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return TrinketsIntegration.equipTrinket(entity, item);
        }
        return false;
    }

    @Override
    @Nullable
    public AbilityToggles getAbilityToggles(class_1309 entity) {
        return (AbilityToggles)ModComponents.ABILITY_TOGGLES.getNullable((Object)entity);
    }

    @Override
    @Nullable
    public SwimData getSwimData(class_1309 entity) {
        return (SwimData)ModComponents.SWIM_DATA.getNullable((Object)entity);
    }

    @Override
    public class_6880<class_1320> getSwimSpeedAttribute() {
        return ModAttributesFabric.SWIM_SPEED;
    }

    @Override
    public class_6880<class_1320> registerAttribute(String name, Supplier<? extends class_1320> supplier) {
        return class_2378.method_47984((class_2378)class_7923.field_41190, Artifacts.key(class_7924.field_41251, name), (Object)supplier.get());
    }

    @Override
    public void processWearableArtifactBuilder(WearableArtifactItem.Builder builder) {
        builder.properties(properties -> properties.method_57349((class_9331)ModDataComponentsFabric.COSMETICS_ENABLED.get(), (Object)true));
    }

    @Override
    public void registerAdditionalDataComponents() {
        ModDataComponentsFabric.register();
    }

    @Override
    public void addCosmeticToggleTooltip(List<class_5250> tooltip, class_1799 stack) {
        if (CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)) {
            tooltip.add(class_2561.method_43471((String)"%s.tooltip.cosmetics_disabled".formatted("artifacts")).method_27692(class_124.field_1056));
        } else {
            tooltip.add(class_2561.method_43471((String)"%s.tooltip.cosmetics_enabled".formatted("artifacts")).method_27692(class_124.field_1056));
        }
    }

    @Override
    public boolean isEyeInWater(class_1657 player) {
        return player.method_5777(class_3486.field_15517);
    }

    @Override
    public boolean isVisibleOnHand(class_1309 entity, class_1268 hand, class_1792 item) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return TrinketsIntegration.isVisibleOnHand(entity, hand, item);
        }
        return false;
    }

    @Override
    public boolean areBootsHidden(class_1309 entity) {
        return false;
    }

    @Override
    public boolean isFishingRod(class_1799 stack) {
        return stack.method_7909() instanceof class_1787;
    }

    @Override
    public void registerArtifactRenderer(class_1792 item, Supplier<ArtifactRenderer> rendererSupplier) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            TrinketsIntegration.registerArtifactRenderer(item, rendererSupplier);
        }
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(class_1792 item) {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            return TrinketsIntegration.getArtifactRenderer(item);
        }
        return null;
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }
}

