/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component;

import artifacts.ability.ArtifactAbility;
import artifacts.network.UpdateArtifactTogglesPacket;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class AbilityToggles {
    public static final Codec<AbilityToggles> CODEC = class_2960.field_25139.listOf().xmap(list -> {
        HashSet toggles = new HashSet();
        for (class_2960 id : list) {
            toggles.add((ArtifactAbility.Type)ModAbilities.REGISTRY.get(id));
        }
        return new AbilityToggles(toggles);
    }, abilityToggles -> {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (ArtifactAbility.Type<?> toggle : abilityToggles.toggles) {
            class_2960 id = ModAbilities.REGISTRY.getId(toggle);
            list.add(id);
        }
        return list;
    });
    protected final Set<ArtifactAbility.Type<?>> toggles = new HashSet();

    public AbilityToggles() {
        this(Set.of());
    }

    public AbilityToggles(Collection<ArtifactAbility.Type<?>> toggles) {
        this.toggles.addAll(toggles);
    }

    public boolean isToggledOn(ArtifactAbility.Type<?> type) {
        return !this.toggles.contains(type);
    }

    public void toggle(ArtifactAbility.Type<?> type, class_1309 entity) {
        if (this.toggles.contains(type)) {
            this.toggles.remove(type);
        } else {
            this.toggles.add(type);
            if (!entity.method_37908().method_8608()) {
                AbilityHelper.forEach(type, entity, ability -> ability.onUnequip(entity, ability.isEnabled()));
            }
        }
    }

    public void applyToggles(Collection<ArtifactAbility.Type<?>> toggles, class_1309 entity) {
        for (ArtifactAbility.Type type : Set.copyOf(Sets.symmetricDifference(this.toggles, Set.copyOf(toggles)))) {
            this.toggle(type, entity);
        }
    }

    public void sendToClient(class_3222 player) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateArtifactTogglesPacket(List.copyOf(this.toggles)));
    }
}

