/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.util;

import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IssuesDetector {
    private static final List<Triple<BooleanSupplier, @Nullable String, String>> ISSUES = new ArrayList<Triple<BooleanSupplier, String, String>>();

    public static void register(BooleanSupplier detector, @Nullable String ignoreFileName, String issueMessage) {
        ISSUES.add((Triple<BooleanSupplier, String, String>)Triple.of((Object)detector, (Object)ignoreFileName, (Object)issueMessage));
    }

    public static void detect() {
        File reiConfigFolder = Platform.getConfigFolder().resolve("roughlyenoughitems").toFile();
        for (Triple<BooleanSupplier, String, String> issue : ISSUES) {
            if (!((BooleanSupplier)issue.getLeft()).getAsBoolean()) continue;
            if (issue.getMiddle() != null) {
                File ignoreFile = new File(reiConfigFolder, (String)issue.getMiddle());
                if (ignoreFile.exists()) {
                    return;
                }
                RoughlyEnoughItemsState.warn((String)issue.getRight());
            } else {
                RoughlyEnoughItemsState.error((String)issue.getRight());
            }
            RoughlyEnoughItemsState.onContinue(() -> {
                try {
                    if (issue.getMiddle() != null) {
                        reiConfigFolder.mkdirs();
                        File ignoreFile = new File(reiConfigFolder, (String)issue.getMiddle());
                        ignoreFile.createNewFile();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            return;
        }
    }
}

