/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import net.minecraft.class_128;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class BatchedEntryRendererManager<T extends EntryWidget>
implements Iterable<T> {
    private final boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
    private final Int2ObjectMap<List<Object>> grouping = new Int2ObjectOpenHashMap();
    private final List<T> toRender = new ArrayList<T>();

    public BatchedEntryRendererManager() {
    }

    public BatchedEntryRendererManager(Collection<? extends T> widgets) {
        this.addAll(widgets);
    }

    public boolean isFastEntryRendering() {
        return this.fastEntryRendering;
    }

    public void addAll(Collection<? extends T> widgets) {
        if (this.fastEntryRendering) {
            for (EntryWidget widget : widgets) {
                this.add(widget);
            }
        } else {
            this.addAllSlow(widgets);
        }
    }

    public void add(T widget) {
        if (this.fastEntryRendering) {
            EntryStack<?> currentEntry = ((EntryWidget)widget).getCurrentEntry();
            try {
                EntryStack cast;
                BatchedEntryRenderer batchedRenderer;
                EntryRenderer<?> renderer = currentEntry.getRenderer();
                if (renderer instanceof BatchedEntryRenderer && (batchedRenderer = (BatchedEntryRenderer)renderer).isBatched(cast = currentEntry.cast())) {
                    Object extraData = batchedRenderer.getExtraData(cast);
                    int hash = batchedRenderer.getBatchIdentifier(cast, ((EntryWidget)widget).getBounds(), extraData) ^ ((EntryWidget)widget).getCurrentEntry().getType().hashCode();
                    ArrayList<Object> entries = (ArrayList<Object>)this.grouping.get(hash);
                    if (entries == null) {
                        entries = new ArrayList<Object>();
                        this.grouping.put(hash, entries);
                    }
                    entries.add(widget);
                    entries.add(extraData);
                    return;
                }
            }
            catch (Throwable throwable) {
                class_128 report = CrashReportUtils.essential(throwable, "Adding entry");
                CrashReportUtils.renderer(report, currentEntry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        this.addSlow(widget);
    }

    public void addAllSlow(Collection<? extends T> widgets) {
        this.toRender.addAll(widgets);
    }

    public void addSlow(T widget) {
        this.toRender.add(widget);
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.render(false, null, null, graphics, mouseX, mouseY, delta);
    }

    public void render(boolean debugTime, MutableInt size, MutableLong time, class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.fastEntryRendering) {
            for (final List entries : this.grouping.values()) {
                Object[] extraData = new Object[entries.size() / 2];
                for (int i = 0; i < extraData.length; ++i) {
                    extraData[i] = entries.get(i * 2 + 1);
                }
                BatchedEntryRendererManager.renderBatched(debugTime, size, time, graphics, mouseX, mouseY, delta, () -> new AbstractIterator<T>(this){
                    public int i = 0;

                    protected T computeNext() {
                        if (this.i >= entries.size()) {
                            return (EntryWidget)this.endOfData();
                        }
                        EntryWidget widget = (EntryWidget)entries.get(this.i);
                        this.i += 2;
                        return widget;
                    }
                }, extraData);
            }
        }
        if (!this.toRender.isEmpty()) {
            BatchedEntryRendererManager.renderSlow(debugTime, size, time, graphics, mouseX, mouseY, delta, this.toRender);
        }
    }

    public static <T extends EntryWidget> void renderEntries(boolean debugTime, MutableInt size, MutableLong time, boolean fastEntryRendering, class_332 graphics, int mouseX, int mouseY, float delta, Collection<T> entries) {
        if (fastEntryRendering) {
            EntryWidget firstWidget = (EntryWidget)Iterables.getFirst(entries, null);
            if (firstWidget == null) {
                return;
            }
            EntryRenderer<?> renderer = firstWidget.getCurrentEntry().getRenderer();
            if (renderer instanceof BatchedEntryRenderer) {
                BatchedEntryRenderer firstRenderer = (BatchedEntryRenderer)renderer;
                Object[] extraData = new Object[entries.size()];
                int i = 0;
                for (EntryWidget entry : entries) {
                    EntryStack<?> currentEntry = entry.getCurrentEntry();
                    extraData[i++] = ((BatchedEntryRenderer)currentEntry.getRenderer()).getExtraData(currentEntry.cast());
                }
                BatchedEntryRendererManager.renderBatched(debugTime, size, time, graphics, mouseX, mouseY, delta, entries, extraData);
                return;
            }
        }
        BatchedEntryRendererManager.renderSlow(debugTime, size, time, graphics, mouseX, mouseY, delta, entries);
    }

    private static <T extends EntryWidget> void renderBatched(boolean debugTime, MutableInt size, MutableLong time, class_332 graphics, int mouseX, int mouseY, float delta, Iterable<T> entries, Object[] extraData) {
        EntryStack<?> currentEntry;
        EntryWidget firstWidget = (EntryWidget)Iterables.getFirst(entries, null);
        if (firstWidget == null) {
            return;
        }
        EntryStack<?> first = firstWidget.getCurrentEntry();
        EntryRenderer<?> renderer = first.getRenderer();
        BatchedEntryRenderer firstRenderer = (BatchedEntryRenderer)renderer;
        class_4587 newStack = firstRenderer.batchModifyMatrices(graphics.method_51448());
        graphics.method_51448().method_22903();
        graphics.method_51448().method_23760().method_23761().set((Matrix4fc)newStack.method_23760().method_23761());
        graphics.method_51448().method_23760().method_23762().set((Matrix3fc)newStack.method_23760().method_23762());
        long l = debugTime ? System.nanoTime() : 0L;
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        int i = 0;
        for (EntryWidget entry : entries) {
            try {
                entry.drawBackground(graphics, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                class_128 report = CrashReportUtils.essential(throwable, "Rendering entry background");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        firstRenderer.startBatch(first, extraData[0], graphics, delta);
        for (EntryWidget entry : entries) {
            try {
                currentEntry = entry.getCurrentEntry();
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(0.0f, 0.0f, entry.getBounds().contains(mouseX, mouseY) ? 150.0f : 100.0f);
                firstRenderer.renderBase(currentEntry, extraData[i++], graphics, immediate, entry.getInnerBounds(), mouseX, mouseY, delta);
                graphics.method_51448().method_22909();
                if (!debugTime || currentEntry.isEmpty()) continue;
                size.increment();
            }
            catch (Throwable throwable) {
                class_128 report = CrashReportUtils.essential(throwable, "Rendering entry base");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        immediate.method_22993();
        firstRenderer.afterBase(first, extraData[0], graphics, delta);
        i = 0;
        for (EntryWidget entry : entries) {
            try {
                currentEntry = entry.getCurrentEntry();
                firstRenderer.renderOverlay(currentEntry, extraData[i++], graphics, immediate, entry.getInnerBounds(), mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                class_128 report = CrashReportUtils.essential(throwable, "Rendering entry base");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        immediate.method_22993();
        for (EntryWidget entry : entries) {
            try {
                if (entry.containsMouse(mouseX, mouseY)) {
                    entry.queueTooltip(graphics, mouseX, mouseY, delta);
                    if (entry.hasHighlight()) {
                        entry.drawHighlighted(graphics, mouseX, mouseY, delta);
                    }
                }
                entry.drawExtra(graphics, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                class_128 report = CrashReportUtils.essential(throwable, "Rendering entry extra");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        if (debugTime) {
            time.add(System.nanoTime() - l);
        }
        firstRenderer.endBatch(first, extraData[0], graphics, delta);
        graphics.method_51448().method_22909();
    }

    public static <T extends EntryWidget> void renderSlow(boolean debugTime, MutableInt size, MutableLong time, class_332 graphics, int mouseX, int mouseY, float delta, Iterable<T> entries) {
        for (EntryWidget entry : entries) {
            if (entry.getCurrentEntry().isEmpty()) continue;
            try {
                if (debugTime) {
                    size.increment();
                    long l = System.nanoTime();
                    entry.method_25394(graphics, mouseX, mouseY, delta);
                    time.add(System.nanoTime() - l);
                    continue;
                }
                entry.method_25394(graphics, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                class_128 report = CrashReportUtils.essential(throwable, "Rendering entry");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return Iterators.concat(this.toRender.iterator(), (Iterator)Iterators.concat(CollectionUtils.map(this.grouping.values(), entries -> new AbstractIterator<T>(this, (List)entries){
            public int i = 0;
            final /* synthetic */ List val$entries;
            {
                this.val$entries = list;
            }

            protected T computeNext() {
                if (this.i >= this.val$entries.size()) {
                    return (EntryWidget)this.endOfData();
                }
                EntryWidget widget = (EntryWidget)this.val$entries.get(this.i);
                this.i += 2;
                return widget;
            }
        }).iterator()));
    }
}

