/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.core;

import neoforge.com.cursee.disenchanting_table.DisenchantingTableNeoForge;
import neoforge.com.cursee.disenchanting_table.core.DisenchantingTableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class DisenchantingTableMenu
extends AbstractContainerMenu {
    private final Level level;
    private final ContainerData data;
    private final DisenchantingTableBlockEntity entity;
    public boolean canAfford = false;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TILE_ENTITY_INVENTORY_FIRST_SLOT_INDEX = 36;

    public DisenchantingTableMenu(int containerID, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)DisenchantingTableNeoForge.DISENCHANTING_TABLE_MENU.get(), containerID);
        DisenchantingTableMenu.checkContainerSize((Container)inventory, (int)3);
        this.data = data;
        this.level = entity.getLevel();
        this.canAfford = inventory.player.experienceLevel >= 5;
        this.entity = (DisenchantingTableBlockEntity)entity;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        if (this.entity.handler != null) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.entity.handler, 0, 27, 47));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.entity.handler, 1, 76, 47));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.entity.handler, 2, 134, 47));
        }
        this.addDataSlots(data);
    }

    public DisenchantingTableMenu(int containerID, Inventory inventory, FriendlyByteBuf buffer) {
        this(containerID, inventory, inventory.player.level().getBlockEntity(buffer.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return DisenchantingTableMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.entity.getBlockPos()), (Player)player, (Block)((Block)DisenchantingTableNeoForge.DISENCHANTING_TABLE_BLOCK.get()));
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stackCopy = stack.copy();
        if (slotIndex < 36) {
            if (!this.moveItemStackTo(stack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (slotIndex < 39) {
            if (!this.moveItemStackTo(stack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + slotIndex);
            return ItemStack.EMPTY;
        }
        if (stack.getCount() == 0) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, stack);
        return stackCopy;
    }
}

