/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core;

import forge.com.cursee.disenchanting_table.DisenchantingTableForge;
import forge.com.cursee.disenchanting_table.core.DisenchantingTableBlock;
import forge.com.cursee.disenchanting_table.core.DisenchantingTableMenu;
import forge.com.cursee.disenchanting_table.core.util.InventoryDirectionEntry;
import forge.com.cursee.disenchanting_table.core.util.InventoryDirectionWrapper;
import forge.com.cursee.disenchanting_table.core.util.WrappedHandler;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisenchantingTableBlockEntity
extends BlockEntity
implements MenuProvider {
    protected static final int TOTAL_SLOTS = 3;
    protected static final int ITEM_INPUT_SLOT = 0;
    protected static final int BOOK_INPUT_SLOT = 1;
    protected static final int OUTPUT_SLOT = 2;
    private int progress = 0;
    private int maxProgress = 10;
    protected final ContainerData data;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            DisenchantingTableBlockEntity.super.m_6596_();
            if (DisenchantingTableBlockEntity.this.f_58857_ != null && !DisenchantingTableBlockEntity.this.f_58857_.m_5776_()) {
                DisenchantingTableBlockEntity.this.f_58857_.m_7260_(DisenchantingTableBlockEntity.this.m_58899_(), DisenchantingTableBlockEntity.this.m_58900_(), DisenchantingTableBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (!EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (stack.m_41720_() == Items.f_42517_) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap;

    public DisenchantingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DisenchantingTableForge.DISENCHANTING_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.directionWrappedHandlerMap = new InventoryDirectionWrapper((IItemHandlerModifiable)this.itemHandler, (InventoryDirectionEntry[])new InventoryDirectionEntry[]{new InventoryDirectionEntry((Direction)Direction.NORTH, (int)1, (boolean)true), new InventoryDirectionEntry((Direction)Direction.EAST, (int)1, (boolean)true), new InventoryDirectionEntry((Direction)Direction.SOUTH, (int)1, (boolean)true), new InventoryDirectionEntry((Direction)Direction.WEST, (int)1, (boolean)true), new InventoryDirectionEntry((Direction)Direction.DOWN, (int)1, (boolean)true), new InventoryDirectionEntry((Direction)Direction.UP, (int)1, (boolean)true)}).directionsMap;
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> DisenchantingTableBlockEntity.this.progress;
                    case 1 -> DisenchantingTableBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        DisenchantingTableBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        DisenchantingTableBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level == null || level.m_5776_()) {
            return;
        }
        if (this.hasProperInput() && this.outputSlotIsEmpty()) {
            ++this.progress;
            DisenchantingTableBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.progress >= this.maxProgress) {
                this.craftItem(level, pos, state);
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    private static boolean takeExperienceFromNearestPlayer(Level level, BlockPos pos) {
        @Nullable ServerPlayer player = (ServerPlayer)level.m_45941_(TargetingConditions.m_148353_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (player != null && player.m_150110_().f_35937_) {
            return true;
        }
        if (player != null && !player.m_150110_().f_35937_ && player.f_36078_ >= 5) {
            player.m_9174_(player.f_36078_ - 5);
            return true;
        }
        return false;
    }

    private void craftItem(Level level, BlockPos pos, BlockState state) {
        ItemStack returnedEnchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        ItemStack inputItem = this.itemHandler.getStackInSlot(0);
        ItemStack inputBlankBook = this.itemHandler.getStackInSlot(1);
        ItemStack outputBook = this.itemHandler.getStackInSlot(2);
        if (inputItem.m_41720_() != Items.f_42690_ && !EnchantmentHelper.m_44831_((ItemStack)inputItem).isEmpty()) {
            if (!DisenchantingTableBlockEntity.takeExperienceFromNearestPlayer(level, pos)) {
                return;
            }
            Map emptyEnchantmentMap = EnchantmentHelper.m_44831_((ItemStack)returnedEnchantedBook);
            Map inputEnchantmentMap = EnchantmentHelper.m_44831_((ItemStack)inputItem);
            EnchantmentHelper.m_44865_((Map)inputEnchantmentMap, (ItemStack)returnedEnchantedBook);
            EnchantmentHelper.m_44865_((Map)emptyEnchantmentMap, (ItemStack)inputItem);
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.extractItem(1, 1, false);
            this.itemHandler.setStackInSlot(0, inputItem);
            this.itemHandler.setStackInSlot(2, returnedEnchantedBook);
        } else if (inputItem.m_41720_() == Items.f_42690_ && EnchantmentHelper.m_44831_((ItemStack)inputItem).size() >= 2) {
            if (!DisenchantingTableBlockEntity.takeExperienceFromNearestPlayer(level, pos)) {
                return;
            }
            ItemStack returnedItem = null;
            Map inputItemEnchantmentsMap = EnchantmentHelper.m_44831_((ItemStack)inputItem);
            ArrayList allEnchantmentsFromBookInput = new ArrayList();
            ArrayList allLevelsFromBookInput = new ArrayList();
            EnchantmentHelper.m_44831_((ItemStack)inputItem).forEach((enchantment, integer) -> {
                allEnchantmentsFromBookInput.add(enchantment);
                allLevelsFromBookInput.add(integer);
            });
            Map blankEnchantmentsMapForNewBook = EnchantmentHelper.m_44831_((ItemStack)returnedEnchantedBook);
            blankEnchantmentsMapForNewBook.put((Enchantment)allEnchantmentsFromBookInput.get(0), (Integer)allLevelsFromBookInput.get(0));
            EnchantmentHelper.m_44865_((Map)blankEnchantmentsMapForNewBook, (ItemStack)returnedEnchantedBook);
            inputItemEnchantmentsMap.remove(allEnchantmentsFromBookInput.get(0));
            returnedItem = new ItemStack((ItemLike)inputItem.m_41720_()).m_41714_(inputItem.m_41786_());
            EnchantmentHelper.m_44865_((Map)inputItemEnchantmentsMap, (ItemStack)returnedItem);
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.extractItem(1, 1, false);
            this.itemHandler.setStackInSlot(0, returnedItem);
            this.itemHandler.setStackInSlot(2, returnedEnchantedBook);
        }
    }

    private boolean hasProperInput() {
        return !EnchantmentHelper.m_44831_((ItemStack)this.itemHandler.getStackInSlot(0)).isEmpty() && this.itemHandler.getStackInSlot(1).m_41720_() == Items.f_42517_;
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(2).m_41741_() >= this.itemHandler.getStackInSlot(2).m_41613_() + count;
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.itemHandler.getStackInSlot(2).m_41619_() || this.itemHandler.getStackInSlot(2).m_41613_() < this.itemHandler.getStackInSlot(2).m_41741_();
    }

    private boolean outputSlotIsEmpty() {
        return this.itemHandler.getStackInSlot(2).m_41619_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)DisenchantingTableBlock.FACING);
                if (side == Direction.DOWN || side == Direction.UP) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void drops() {
        if (this.f_58857_ != null) {
            SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
            }
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    public AbstractContainerMenu m_7208_(int containerID, @NotNull Inventory inventory, @NotNull Player player) {
        return new DisenchantingTableMenu(containerID, inventory, this, this.data);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("disenchanting_table.progress", this.progress);
        pTag.m_128405_("disenchanting_table.max_progress", this.maxProgress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("disenchanting_table.progress");
        this.maxProgress = pTag.m_128451_("disenchanting_table.max_progress");
    }
}

