/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.endec.RegistriesAttribute;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.networking.base.HandledPacketPayload;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public record SyncContainerData(int entityId, Map<String, NbtMapCarrier> updatedContainers, Map<String, class_1799> dirtyStacks, Map<String, class_1799> dirtyCosmeticStacks) implements HandledPacketPayload
{
    public static Endec<SyncContainerData> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncContainerData::entityId), (StructField)NbtMapCarrier.ENDEC.mapOf().fieldOf("updatedContainers", SyncContainerData::updatedContainers), (StructField)CodecUtils.ofCodec(class_1799.field_49266).mapOf().fieldOf("dirtyStacks", SyncContainerData::dirtyStacks), (StructField)CodecUtils.ofCodec(class_1799.field_49266).mapOf().fieldOf("dirtyCosmeticStacks", SyncContainerData::dirtyCosmeticStacks), SyncContainerData::new);

    public static SyncContainerData of(class_1309 livingEntity, Collection<AccessoriesContainer> updatedContainers, Map<String, class_1799> dirtyStacks, Map<String, class_1799> dirtyCosmeticStacks) {
        HashMap<String, NbtMapCarrier> updatedContainerTags = new HashMap<String, NbtMapCarrier>();
        for (AccessoriesContainer updatedContainer : updatedContainers) {
            NbtMapCarrier syncCarrier = NbtMapCarrier.of();
            ((AccessoriesContainerImpl)updatedContainer).write(syncCarrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(livingEntity.method_56673())}), true);
            updatedContainerTags.put(updatedContainer.getSlotName(), syncCarrier);
        }
        return new SyncContainerData(livingEntity.method_5628(), updatedContainerTags, dirtyStacks, dirtyCosmeticStacks);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(class_1657 player) {
        AccessoriesContainer container;
        String slot;
        String[] parts;
        class_1937 level = player.method_37908();
        class_1297 entity = level.method_8469(this.entityId);
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            return;
        }
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        boolean aContainerHasResized = false;
        for (Map.Entry<String, NbtMapCarrier> class_17032 : this.updatedContainers.entrySet()) {
            if (!containers.containsKey(class_17032.getKey())) continue;
            AccessoriesContainer container2 = containers.get(class_17032.getKey());
            ((AccessoriesContainerImpl)container2).read(class_17032.getValue(), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(player.method_37908().method_30349())}), true);
            if (!container2.getAccessories().wasNewlyConstructed()) continue;
            aContainerHasResized = true;
        }
        for (Map.Entry<String, NbtMapCarrier> entry : this.dirtyStacks.entrySet()) {
            parts = entry.getKey().split("/");
            slot = parts[0];
            if (!containers.containsKey(slot)) continue;
            container = containers.get(slot);
            try {
                container.getAccessories().method_5447(Integer.parseInt(parts[1]), (class_1799)entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (Map.Entry<String, NbtMapCarrier> entry : this.dirtyCosmeticStacks.entrySet()) {
            parts = entry.getKey().split("/");
            slot = parts[0];
            if (!containers.containsKey(slot)) continue;
            container = containers.get(slot);
            try {
                container.getCosmeticAccessories().method_5447(Integer.parseInt(parts[1]), (class_1799)entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof AccessoriesMenu) {
            AccessoriesMenu menu = (AccessoriesMenu)class_17032;
            if (aContainerHasResized) {
                menu.reopenMenu();
            }
        }
    }
}

