/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.AccessoriesMenuData;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.mixin.SlotAccessor;
import io.wispforest.accessories.networking.server.ScreenOpen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9692;
import org.jetbrains.annotations.Nullable;

public final class AccessoriesMenu
extends class_1703 {
    public static final class_2960 BLOCK_ATLAS = class_2960.method_60656((String)"textures/atlas/blocks.png");
    public static final class_2960 EMPTY_ARMOR_SLOT_SHIELD = class_2960.method_60656((String)"item/empty_armor_slot_shield");
    private static final Map<class_1304, class_2960> TEXTURE_EMPTY_SLOTS = Map.of(class_1304.field_6166, class_2960.method_60656((String)"item/empty_armor_slot_boots"), class_1304.field_6172, class_2960.method_60656((String)"item/empty_armor_slot_leggings"), class_1304.field_6174, class_2960.method_60656((String)"item/empty_armor_slot_chestplate"), class_1304.field_6169, class_2960.method_60656((String)"item/empty_armor_slot_helmet"));
    private static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private final class_1657 owner;
    @Nullable
    private final class_1309 targetEntity;
    public int totalSlots = 0;
    public boolean overMaxVisibleSlots = false;
    public int scrolledIndex = 0;
    public float smoothScroll = 0.0f;
    private int maxScrollableIndex = 0;
    private int accessoriesSlotStartIndex = 0;
    private int cosmeticSlotStartIndex = 0;
    private final Set<SlotGroup> validGroups = new HashSet<SlotGroup>();
    private final Map<Integer, Boolean> slotToView = new HashMap<Integer, Boolean>();
    private Runnable onScrollToEvent = () -> {};
    @Nullable
    private Set<SlotType> usedSlots = null;

    public AccessoriesMenu(int containerId, class_1661 inventory, @Nullable class_1309 targetEntity) {
        super(Accessories.ACCESSORIES_MENU_TYPE, containerId);
        int i;
        this.owner = inventory.field_7546;
        this.targetEntity = targetEntity;
        class_1309 accessoryTarget = targetEntity != null ? targetEntity : this.owner;
        AccessoriesCapability capability = AccessoriesCapability.get(accessoryTarget);
        if (capability == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            class_1304 equipmentSlot = SLOT_IDS[i];
            class_2960 resourceLocation = TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            this.method_7621((class_1735)new class_9692((class_1263)inventory, (class_1309)this.owner, equipmentSlot, 39 - i, 8, 8 + i * 18, resourceLocation));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)inventory, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)inventory, i, 8 + i * 18, 142));
        }
        this.method_7621(new class_1735((class_1263)inventory, 40, 152, 62){

            public void method_48931(class_1799 newStack, class_1799 oldStack) {
                AccessoriesMenu.this.owner.method_6116(class_1304.field_6171, oldStack, newStack);
                super.method_48931(newStack, oldStack);
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        if (!this.areUnusedSlotsShown()) {
            this.usedSlots = ImmutableSet.copyOf(AccessoriesAPI.getUsedSlotsFor((class_1309)(targetEntity != null ? targetEntity : this.owner), (class_1263)this.owner.method_31548()));
        }
        int minX = -46;
        int maxX = 60;
        int minY = 8;
        int maxY = 152;
        int yIndex = 0;
        this.accessoriesSlotStartIndex = this.field_7761.size();
        HashMap<AccessoriesInternalSlot, Boolean> slotVisibility = new HashMap<AccessoriesInternalSlot, Boolean>();
        ArrayList<AccessoriesInternalSlot> accessoriesSlots = new ArrayList<AccessoriesInternalSlot>();
        ArrayList<AccessoriesInternalSlot> cosmeticSlots = new ArrayList<AccessoriesInternalSlot>();
        List<SlotGroup> groups = SlotGroupLoader.getGroups(inventory.field_7546.method_37908(), !this.areUniqueSlotsShown());
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        for (SlotGroup group : groups.stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).toList()) {
            Set<String> slotNames = group.slots();
            List<SlotType> slotTypes = slotNames.stream().map(s -> SlotTypeLoader.getSlotType(this.owner.method_37908(), s)).sorted(Comparator.comparingInt(SlotType::order).reversed()).toList();
            for (SlotType slot : slotTypes) {
                if (this.usedSlots != null && !this.usedSlots.contains(slot)) continue;
                this.validGroups.add(group);
                AccessoriesContainer accessoryContainer = containers.get(slot.name());
                if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;
                int size = accessoryContainer.getSize();
                for (int i2 = 0; i2 < size; ++i2) {
                    int currentY = yIndex * 18 + minY + 8;
                    int currentX = minX;
                    AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(yIndex, accessoryContainer, true, i2, currentX, currentY).isActive(slot1 -> this.isCosmeticsOpen() && this.slotToView.getOrDefault(slot1.field_7874, true) != false).isAccessible(slot1 -> slot1.isCosmetic && this.isCosmeticsOpen());
                    cosmeticSlots.add(cosmeticSlot);
                    slotVisibility.put(cosmeticSlot, !this.overMaxVisibleSlots);
                    AccessoriesInternalSlot baseSlot = new AccessoriesInternalSlot(yIndex, accessoryContainer, false, i2, currentX += 20, currentY).isActive(slot1 -> this.slotToView.getOrDefault(slot1.field_7874, true));
                    accessoriesSlots.add(baseSlot);
                    slotVisibility.put(baseSlot, !this.overMaxVisibleSlots);
                    ++yIndex;
                    if (this.overMaxVisibleSlots || currentY + 18 <= maxY) continue;
                    this.overMaxVisibleSlots = true;
                }
            }
        }
        for (AccessoriesInternalSlot accessoriesSlot : accessoriesSlots) {
            this.method_7621(accessoriesSlot);
            this.slotToView.put(accessoriesSlot.field_7874, slotVisibility.getOrDefault((Object)accessoriesSlot, false));
        }
        this.cosmeticSlotStartIndex = this.field_7761.size();
        for (AccessoriesInternalSlot cosmeticSlot : cosmeticSlots) {
            this.method_7621(cosmeticSlot);
            this.slotToView.put(cosmeticSlot.field_7874, slotVisibility.getOrDefault((Object)cosmeticSlot, false));
        }
        this.totalSlots = yIndex;
        this.maxScrollableIndex = this.totalSlots - 8;
    }

    public void setScrollEvent(Runnable event) {
        this.onScrollToEvent = event;
    }

    public boolean scrollTo(int i, boolean smooth) {
        int index = Math.min(Math.max(i, 0), this.maxScrollableIndex);
        if (index == this.scrolledIndex) {
            return false;
        }
        int diff = this.scrolledIndex - index;
        if (!smooth) {
            this.smoothScroll = class_3532.method_15363((float)((float)index / (float)this.maxScrollableIndex), (float)0.0f, (float)1.0f);
        }
        for (class_1735 slot : this.field_7761) {
            if (!(slot instanceof AccessoriesInternalSlot)) continue;
            AccessoriesInternalSlot accessoriesSlot = (AccessoriesInternalSlot)slot;
            ((SlotAccessor)((Object)accessoriesSlot)).accessories$setY(accessoriesSlot.field_7872 + diff * 18);
            int menuIndex = accessoriesSlot.menuIndex;
            this.slotToView.put(accessoriesSlot.field_7874, menuIndex >= index && menuIndex < index + 8);
        }
        this.scrolledIndex = index;
        this.onScrollToEvent.run();
        return true;
    }

    public int maxScrollableIndex() {
        return this.maxScrollableIndex;
    }

    @Nullable
    public class_1309 targetEntity() {
        return this.targetEntity;
    }

    public class_1657 owner() {
        return this.owner;
    }

    public static AccessoriesMenu of(int containerId, class_1661 inventory, AccessoriesMenuData data) {
        class_1309 targetEntity = data.targetEntityId().map(i -> {
            class_1297 entity = inventory.field_7546.method_37908().method_8469(i.intValue());
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return livingEntity;
            }
            return null;
        }).orElse(null);
        return new AccessoriesMenu(containerId, inventory, targetEntity);
    }

    public boolean showingSlots() {
        return this.usedSlots == null || !this.usedSlots.isEmpty();
    }

    @Nullable
    public Set<SlotType> usedSlots() {
        return this.usedSlots;
    }

    public Set<SlotGroup> validGroups() {
        return this.validGroups;
    }

    public boolean isCosmeticsOpen() {
        return Optional.ofNullable(AccessoriesHolder.get((class_1309)this.owner)).map(AccessoriesHolder::cosmeticsShown).orElse(false);
    }

    public boolean areLinesShown() {
        return Optional.ofNullable(AccessoriesHolder.get((class_1309)this.owner)).map(AccessoriesHolder::linesShown).orElse(false);
    }

    public boolean areUnusedSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((class_1309)this.owner)).map(AccessoriesHolder::showUnusedSlots).orElse(false);
    }

    public boolean areUniqueSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((class_1309)this.owner)).map(AccessoriesHolder::showUniqueSlots).orElse(false);
    }

    public void reopenMenu() {
        AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(this.targetEntity));
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int clickedIndex) {
        int targetArmorSlotIndex;
        class_2371 slots = this.field_7761;
        class_1735 clickedSlot = (class_1735)slots.get(clickedIndex);
        if (!clickedSlot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 clickedStack = clickedSlot.method_7677();
        class_1799 oldStack = clickedStack.method_7972();
        class_1304 equipmentSlot = player.method_32326(oldStack);
        int armorSlots = 4;
        int hotbarSlots = 9;
        int invSlots = 27;
        int armorStart = 0;
        int armorEnd = armorStart - 1 + armorSlots;
        int invStart = armorEnd + 1;
        int invEnd = invStart - 1 + invSlots;
        int hotbarStart = invEnd + 1;
        int hotbarEnd = hotbarStart - 1 + hotbarSlots;
        int offhand = hotbarEnd + 1;
        if (clickedIndex < this.accessoriesSlotStartIndex ? !this.method_7616(clickedStack, this.accessoriesSlotStartIndex, this.field_7761.size(), false) && (clickedIndex >= armorStart && clickedIndex <= armorEnd ? !this.method_7616(clickedStack, invStart, hotbarEnd, false) : (equipmentSlot.method_5925() == class_1304.class_1305.field_6178 && !((class_1735)this.field_7761.get(armorEnd - equipmentSlot.method_5927())).method_7681() ? !this.method_7616(clickedStack, targetArmorSlotIndex = armorEnd - equipmentSlot.method_5927(), targetArmorSlotIndex + 1, false) : (equipmentSlot == class_1304.field_6171 && !((class_1735)this.field_7761.get(offhand)).method_7681() ? !this.method_7616(clickedStack, offhand, offhand + 1, false) : (clickedIndex >= hotbarStart && clickedIndex <= hotbarEnd ? !this.method_7616(clickedStack, invStart, invEnd, false) : (clickedIndex >= invStart && clickedIndex <= invEnd ? !this.method_7616(clickedStack, hotbarStart, hotbarEnd, false) : !this.method_7616(clickedStack, invStart, hotbarEnd, false)))))) : !this.method_7616(clickedStack, invStart, hotbarEnd, false)) {
            return class_1799.field_8037;
        }
        if (clickedStack.method_7960()) {
            clickedSlot.method_48931(class_1799.field_8037, oldStack);
        } else {
            clickedSlot.method_7668();
        }
        if (clickedStack.method_7947() == oldStack.method_7947()) {
            return class_1799.field_8037;
        }
        clickedSlot.method_7667(player, clickedStack);
        return oldStack;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        class_1799 itemStack;
        class_1735 slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.method_7946()) {
            while (!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (class_1735)this.field_7761.get(i);
                if (slot.method_7676(itemStack = slot.method_7677()) < itemStack.method_7947() && !itemStack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) {
                    int j = itemStack.method_7947() + stack.method_7947();
                    if (j <= stack.method_7914()) {
                        stack.method_7939(0);
                        itemStack.method_7939(j);
                        slot.method_7668();
                        bl = true;
                    } else if (itemStack.method_7947() < stack.method_7914()) {
                        stack.method_7934(stack.method_7914() - itemStack.method_7947());
                        itemStack.method_7939(stack.method_7914());
                        slot.method_7668();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.method_7960()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (class_1735)this.field_7761.get(i);
                itemStack = slot.method_7677();
                if (itemStack.method_7960() && slot.method_7680(stack)) {
                    if (stack.method_7947() > slot.method_7676(stack)) {
                        slot.method_53512(stack.method_7971(slot.method_7676(stack)));
                    } else {
                        slot.method_53512(stack.method_7971(stack.method_7947()));
                    }
                    slot.method_7668();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }
}

