/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.google.common.collect.ImmutableMap;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;

public class UniqueSlotHandling {
    public static final Event<RegistrationCallback> EVENT = EventFactory.createArrayBacked(RegistrationCallback.class, invokers -> factory -> {
        for (RegistrationCallback invoker : invokers) {
            invoker.registerSlots(factory);
        }
    });
    private static final Map<String, Set<class_1299<?>>> SLOT_TO_ENTITIES = new HashMap();
    private static final Set<String> GROUPS_SERVER = new HashSet<String>();
    private static final Set<String> GROUPS_CLIENT = new HashSet<String>();

    @ApiStatus.Internal
    public static void gatherUniqueSlots(TriFunction<class_2960, Integer, Collection<class_2960>, SlotTypeReference> slotRegistration) {
        GROUPS_SERVER.clear();
        SLOT_TO_ENTITIES.clear();
        UniqueSlotBuilderFactory eventRegistration = (location, amount) -> new UniqueSlotBuilder(location, amount, slotRegistration);
        ((RegistrationCallback)EVENT.invoker()).registerSlots(eventRegistration);
    }

    public static boolean isUniqueSlot(String slotType) {
        return slotType.split(":").length > 1;
    }

    public static boolean isUniqueGroup(String group, boolean isClient) {
        return (isClient ? GROUPS_CLIENT : GROUPS_SERVER).contains(group);
    }

    @ApiStatus.Internal
    public static Map<String, Set<class_1299<?>>> getSlotToEntities() {
        return ImmutableMap.copyOf(SLOT_TO_ENTITIES);
    }

    @ApiStatus.Internal
    public static void addGroup(String group) {
        GROUPS_SERVER.add(group);
    }

    @ApiStatus.Internal
    public static Set<String> getGroups(boolean isClient) {
        return isClient ? GROUPS_CLIENT : GROUPS_SERVER;
    }

    @ApiStatus.Internal
    public static void setClientGroups(Set<String> set) {
        GROUPS_CLIENT.clear();
        GROUPS_CLIENT.addAll(set);
    }

    public static interface UniqueSlotBuilderFactory {
        public UniqueSlotBuilder create(class_2960 var1, int var2);
    }

    public static interface RegistrationCallback {
        public void registerSlots(UniqueSlotBuilderFactory var1);
    }

    public static final class UniqueSlotBuilder {
        private final class_2960 location;
        private final int amount;
        private Set<class_2960> slotPredicates = Set.of(Accessories.of("tag"));
        private Set<class_1299<?>> validTypes = Set.of();
        private boolean strictMode = true;
        private boolean allowResizing = false;
        private boolean allowEquipFromUse = false;
        private final TriFunction<class_2960, Integer, Collection<class_2960>, SlotTypeReference> slotRegistration;

        UniqueSlotBuilder(class_2960 location, int amount, TriFunction<class_2960, Integer, Collection<class_2960>, SlotTypeReference> slotRegistration) {
            this.location = location;
            this.amount = amount;
            this.slotRegistration = slotRegistration;
        }

        public UniqueSlotBuilder slotPredicates(class_2960 ... locations) {
            this.slotPredicates = Set.of(locations);
            return this;
        }

        public UniqueSlotBuilder validTypes(class_1299<?> ... types) {
            this.validTypes = Set.of(types);
            return this;
        }

        public UniqueSlotBuilder strictMode(boolean value) {
            this.strictMode = value;
            return this;
        }

        public UniqueSlotBuilder allowResizing(boolean value) {
            this.allowResizing = value;
            return this;
        }

        public UniqueSlotBuilder allowEquipFromUse(boolean value) {
            this.allowEquipFromUse = value;
            return this;
        }

        public SlotTypeReference build() {
            SlotTypeReference slotTypeRef = (SlotTypeReference)this.slotRegistration.apply((Object)this.location, (Object)this.amount, this.slotPredicates);
            SLOT_TO_ENTITIES.put(slotTypeRef.slotName(), Set.copyOf(this.validTypes));
            ExtraSlotTypeProperties.getProperties(false).put(slotTypeRef.slotName(), new ExtraSlotTypeProperties(this.allowResizing, this.strictMode, this.allowEquipFromUse));
            return slotTypeRef;
        }
    }
}

