/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.annotations.Since;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import journeymap.api.v2.client.display.Displayable;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class WaypointIcon {
    public static final class_2960 DEFAULT_ICON_NORMAL = class_2960.method_60655((String)"journeymap", (String)"ui/img/waypoint-icon.png");
    public static final class_2960 DEFAULT_ICON_DEATH = class_2960.method_60655((String)"journeymap", (String)"ui/img/waypoint-death-icon.png");
    public static MapCodec<WaypointIcon> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("resourceLocation").forGetter(WaypointIcon::getResourceLocation), (App)Codec.INT.optionalFieldOf("rotation").forGetter(icon -> Optional.ofNullable(icon.getRotation())), (App)Codec.INT.optionalFieldOf("textureWidth").forGetter(icon -> Optional.ofNullable(icon.getTextureWidth())), (App)Codec.INT.optionalFieldOf("textureHeight").forGetter(icon -> Optional.ofNullable(icon.getTextureHeight())), (App)Codec.INT.optionalFieldOf("color").forGetter(icon -> Optional.ofNullable(icon.getColor())), (App)Codec.FLOAT.optionalFieldOf("opacity").forGetter(icon -> Optional.ofNullable(Float.valueOf(icon.getOpacity())))).apply((Applicative)instance, WaypointIcon::new));
    @Since(value=1.0)
    private String resourceLocation;
    @Since(value=1.0)
    private Integer color;
    @Since(value=1.0)
    private Float opacity = Float.valueOf(1.0f);
    @Since(value=1.0)
    private Integer textureWidth;
    @Since(value=1.0)
    private Integer textureHeight;
    @Since(value=1.0)
    private Integer rotation = 0;

    public WaypointIcon() {
        this.resourceLocation = DEFAULT_ICON_NORMAL.toString();
    }

    public WaypointIcon(class_2960 resourceLocation) {
        this.resourceLocation = resourceLocation.toString();
        this.opacity = Float.valueOf(1.0f);
    }

    public WaypointIcon(class_2960 resourceLocation, int textureWidth, int textureHeight) {
        this(resourceLocation, textureWidth, textureHeight, -1, 1.0f);
    }

    public WaypointIcon(class_2960 resourceLocation, int textureWidth, int textureHeight, int color, float opacity) {
        this.resourceLocation = resourceLocation.toString();
        this.setTextureWidth(textureWidth);
        this.setTextureHeight(textureHeight);
        this.setColor(color);
        this.setOpacity(opacity);
    }

    @ApiStatus.Internal
    public WaypointIcon(class_2960 resourceLocation, Optional<Integer> rotation, Optional<Integer> textureWidth, Optional<Integer> textureHeight, Optional<Integer> color, Optional<Float> opacity) {
        this.resourceLocation = resourceLocation.toString();
        rotation.ifPresent(this::setRotation);
        color.ifPresent(this::setColor);
        opacity.ifPresent(this::setOpacity);
        textureHeight.ifPresent(this::setTextureHeight);
        textureWidth.ifPresent(this::setTextureWidth);
    }

    public WaypointIcon(WaypointIcon original) {
        this.resourceLocation = original.getResourceLocation().toString();
        this.textureWidth = original.getTextureWidth();
        this.textureHeight = original.getTextureHeight();
        this.color = original.getColor();
        this.opacity = Float.valueOf(original.getOpacity());
        this.rotation = original.getRotation();
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation % 360;
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer color) {
        this.color = color != null ? Integer.valueOf(Displayable.clampRGB((int)color)) : null;
    }

    public boolean useBeaconColor() {
        return this.color == null;
    }

    public float getOpacity() {
        return this.opacity.floatValue();
    }

    public void setOpacity(float opacity) {
        this.opacity = Float.valueOf(Displayable.clampOpacity((float)opacity));
    }

    public class_2960 getResourceLocation() {
        return class_2960.method_12829((String)this.resourceLocation);
    }

    public void setResourceLoctaion(class_2960 resourceLocation) {
        this.resourceLocation = resourceLocation.toString();
    }

    public Integer getTextureWidth() {
        return this.textureWidth;
    }

    public Integer getTextureHeight() {
        return this.textureHeight;
    }

    public void setTextureWidth(Integer textureWidth) {
        this.textureWidth = Math.max(1, textureWidth);
    }

    public void setTextureHeight(Integer textureHeight) {
        this.textureHeight = Math.max(1, textureHeight);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaypointIcon mapImage = (WaypointIcon)o;
        return Objects.equal((Object)this.color, (Object)mapImage.color) && Objects.equal((Object)this.opacity, (Object)mapImage.opacity) && Objects.equal((Object)this.textureWidth, (Object)mapImage.textureWidth) && Objects.equal((Object)this.textureHeight, (Object)mapImage.textureHeight) && Objects.equal((Object)this.resourceLocation, (Object)mapImage.resourceLocation);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resourceLocation, this.color, this.opacity, this.textureWidth, this.textureHeight});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("imageLocation", (Object)this.resourceLocation).add("color", (Object)this.color).add("textureHeight", (Object)this.textureHeight).add("opacity", (Object)this.opacity).add("textureWidth", (Object)this.textureWidth).toString();
    }
}

