/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import journeymap.client.io.FileHandler;
import journeymap.common.Journeymap;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;

public class ClientWaypointDAO
extends WaypointDAO {
    protected static final String DAT_FILE = "WaypointData.dat";

    public ClientWaypointDAO() {
        this.data = this.load();
    }

    @Override
    public Map<String, WaypointGroupImpl> decodeGroups(class_2487 data) {
        LinkedHashMap<String, WaypointGroupImpl> groups = new LinkedHashMap<String, WaypointGroupImpl>();
        if (data.method_10545("groups")) {
            class_2487 groupsTags = data.method_10562("groups");
            for (String key : groupsTags.method_10541()) {
                class_2520 tag = groupsTags.method_10580(key);
                DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointGroupImpl group = (WaypointGroupImpl)result.result().get();
                groups.put(group.getGuid(), group);
            }
        }
        return groups;
    }

    @Override
    public class_2487 encodeGroups(Collection<WaypointGroupImpl> groups) {
        class_2487 tag = new class_2487();
        tag.method_10566("groups", (class_2520)new class_2487());
        class_2487 groupsTag = tag.method_10562("groups");
        for (WaypointGroupImpl group : groups) {
            DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)group);
            if (!result.result().isPresent()) continue;
            groupsTag.method_10566(group.getGuid(), (class_2520)result.result().get());
        }
        return tag;
    }

    @Override
    public Map<String, WaypointImpl> decodeWaypoints(class_2487 data) {
        LinkedHashMap<String, WaypointImpl> waypoints = new LinkedHashMap<String, WaypointImpl>();
        if (data.method_10545("waypoints")) {
            class_2487 groupsTags = data.method_10562("waypoints");
            for (String key : groupsTags.method_10541()) {
                class_2520 tag = groupsTags.method_10580(key);
                DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointImpl waypoint = (WaypointImpl)result.result().get();
                waypoints.put(waypoint.getGuid(), waypoint);
            }
        }
        return waypoints;
    }

    @Override
    public class_2487 encodeWaypoints(Collection<WaypointImpl> waypoints) {
        class_2487 tag = new class_2487();
        tag.method_10566("waypoints", (class_2520)new class_2487());
        class_2487 wpTag = tag.method_10562("waypoints");
        for (WaypointImpl wp : waypoints) {
            DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)wp);
            if (!result.result().isPresent()) continue;
            wpTag.method_10566(wp.getGuid(), (class_2520)result.result().get());
        }
        return tag;
    }

    private File getFile() {
        return new File(FileHandler.getWaypointDir(), DAT_FILE);
    }

    private void write(Path path) {
        try {
            class_2507.method_10630((class_2487)this.data, (Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save(boolean async) {
        Journeymap.getLogger().info("Saving WaypointData.dat async:{}", (Object)async);
        if (async) {
            CompletableFuture.runAsync(() -> this.write(this.getFile().toPath()), class_156.method_27958());
        }
        this.write(this.getFile().toPath());
    }

    @Override
    public Map<String, WaypointGroupImpl> getGroups() {
        return this.decodeGroups(this.data);
    }

    @Override
    public Map<String, WaypointImpl> getWaypoints() {
        return this.decodeWaypoints(this.data);
    }

    private class_2487 load() {
        try {
            if (this.getFile().exists()) {
                return class_2507.method_10633((Path)this.getFile().toPath());
            }
            return new class_2487();
        }
        catch (EOFException eof) {
            Journeymap.getLogger().error("WaypointData.dat file is corrupted. Deleting as it is unusable.", (Throwable)eof);
            if (this.getFile().exists()) {
                this.getFile().delete();
            }
            return new class_2487();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

