/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.screens;

import java.awt.Color;
import java.util.List;
import java.util.Stack;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.LogoWidget;
import journeymap.client.ui.component.UnscaledStringWidget;
import journeymap.client.ui.component.buttons.Button;
import journeymap.common.Journeymap;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class JmUI
extends class_437 {
    protected final int topHeaderHeight = 24;
    protected final int bottomHeaderHeight = 12;
    protected final int headerHeight = 36;
    protected final int footerHeight = 30;
    protected final int centerHeight = 66;
    protected final String title;
    protected final Logger logger = Journeymap.getLogger();
    protected double scaleFactor = 1.0;
    public static Stack<class_437> returnDisplayStack = new Stack();
    protected final boolean hasHeaderAndFooter;
    protected final class_7845 headerLayout = new class_7845();
    protected LogoWidget logoWidget;
    protected class_7842 titleWidget;
    protected UnscaledStringWidget apiVersionWidget;
    protected class_7843 topLeftHeader;
    protected class_7843 topRightHeader;
    protected class_7843 bottomHeader;
    protected class_8667 footerLayout = class_8667.method_52742();
    protected boolean showLayoutDebug = false;
    protected class_7843 contentLayout;

    public JmUI(String title, boolean hasHeaderAndFooter) {
        this(title, hasHeaderAndFooter, null);
    }

    public JmUI(String title, boolean hasHeaderAndFooter, class_437 returnDisplay) {
        super((class_2561)Constants.getStringTextComponent(title));
        this.title = title;
        this.hasHeaderAndFooter = hasHeaderAndFooter;
        returnDisplayStack.push(returnDisplay);
    }

    public class_310 getMinecraft() {
        this.field_22787 = class_310.method_1551();
        return this.field_22787;
    }

    public void method_25423(class_310 minecraft, int width, int height) {
        this.scaleFactor = JmUI.calculateScaleFactor();
        this.method_37067();
        super.method_25423(minecraft, width, height);
        if (this.hasHeaderAndFooter) {
            this.headerLayout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.headerLayout.method_48206(w -> w.method_48591(0));
            this.bottomHeader.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.bottomHeader.method_48206(w -> w.method_48591(1));
            this.footerLayout.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.footerLayout.method_48206(w -> w.method_48591(3));
        }
        this.contentLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.contentLayout.method_48206(w -> w.method_48591(2));
        this.method_48640();
    }

    public void method_25426() {
        if (this.hasHeaderAndFooter) {
            this.headerLayout.method_48637(0);
            this.logoWidget = (LogoWidget)this.headerLayout.method_46453((class_8021)new LogoWidget(JmUI::calculateScaleFactor), 0, 0, 2, 1);
            this.titleWidget = (class_7842)this.headerLayout.method_46453((class_8021)new class_7842(this.field_22793.method_1727(this.title) + 10, this.headerHeight, (class_2561)class_2561.method_43470((String)this.title), this.field_22793).method_46438(Color.CYAN.getRGB()), 0, 2, 2, 1);
            String apiVersion = " API v2.0.0-SNAPSHOT ";
            this.apiVersionWidget = (UnscaledStringWidget)this.headerLayout.method_46453((class_8021)new UnscaledStringWidget(0, this.headerHeight, (class_2561)class_2561.method_43470((String)apiVersion), this.field_22793, JmUI::calculateScaleFactor).setColor(0xCCCCCC), 0, 4, 2, 1);
            this.topLeftHeader = (class_7843)this.headerLayout.method_46452((class_8021)new class_7843(0, this.topHeaderHeight), 0, 1);
            this.topRightHeader = (class_7843)this.headerLayout.method_46452((class_8021)new class_7843(0, this.topHeaderHeight), 0, 3);
            this.bottomHeader = new class_7843(0, this.bottomHeaderHeight);
            this.footerLayout.method_52735(12).method_52740().method_46474();
            this.contentLayout = new class_7843(0, this.headerHeight, 0, 0);
        } else {
            this.contentLayout = new class_7843(0, 0, 0, 0);
        }
    }

    public class_437 getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    protected void method_48640() {
        this.scaleFactor = JmUI.calculateScaleFactor();
        if (this.hasHeaderAndFooter) {
            int fixedLeftHeaderWidth = this.logoWidget.method_25368() + this.titleWidget.method_25368() / 2;
            int fixedRightHeaderWidth = this.apiVersionWidget.method_25368() + this.titleWidget.method_25368() / 2;
            int halfWidth = this.field_22789 / 2;
            this.topLeftHeader.method_46449(halfWidth - fixedLeftHeaderWidth);
            this.topRightHeader.method_46449(halfWidth - fixedRightHeaderWidth);
            this.headerLayout.method_48222();
            this.bottomHeader.method_48229(0, this.topHeaderHeight);
            this.bottomHeader.method_46449(this.field_22789);
            this.bottomHeader.method_48222();
            this.footerLayout.method_48222();
            this.footerLayout.method_48229((this.field_22789 - this.footerLayout.method_25368()) / 2, this.field_22790 - (this.footerHeight + this.footerLayout.method_25364()) / 2);
            this.contentLayout.method_46446(this.field_22789, this.field_22790 - this.headerHeight - this.footerHeight);
        } else {
            this.contentLayout.method_46446(this.field_22789, this.field_22790);
        }
        this.contentLayout.method_48222();
    }

    public static double calculateScaleFactor() {
        class_310 minecraft = class_310.method_1551();
        double scaleFactor = minecraft.method_22683().method_4495();
        int monitorWidth = minecraft.method_22683().method_20831().method_1617().method_1668();
        int windowWidth = minecraft.method_22683().method_4489();
        int screenWidth = minecraft.method_22683().method_4480();
        int scaledWidth = minecraft.method_22683().method_4486();
        if (class_310.field_1703 && windowWidth > monitorWidth) {
            scaleFactor = minecraft.method_22683().method_4495() / ((double)windowWidth / (double)screenWidth);
            if (screenWidth == monitorWidth) {
                scaleFactor = minecraft.method_22683().method_4495() / ((double)windowWidth / (double)monitorWidth);
            }
        }
        return scaleFactor;
    }

    public boolean method_25421() {
        return true;
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    public void method_25420(class_332 graphics, int i, int j, float f) {
        if (class_310.method_1551().field_1687 == null) {
            this.drawGradientRect(graphics, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680, 0);
        } else {
            super.method_25420(graphics, i, j, f);
        }
    }

    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        this.method_25420(graphics, x, y, partialTicks);
        if (this.hasHeaderAndFooter) {
            DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.field_22789, 36.0, 0, 0.9f);
            DrawUtil.drawRectangle(graphics, 0.0, this.field_22790 - 30, this.field_22789, this.field_22790, 0, 0.6f);
        }
        List<class_5481> tooltip = null;
        for (class_4068 renderable : this.getRenderables()) {
            Button button;
            renderable.method_25394(graphics, x, y, partialTicks);
            if (tooltip != null || !(renderable instanceof Button) || !(button = (Button)renderable).mouseOver(x, y)) continue;
            tooltip = button.getWrappedTooltip();
        }
        if (this.showLayoutDebug) {
            JmUI.debugLayoutRender(graphics, (class_8021)this.headerLayout);
            JmUI.debugLayoutRender(graphics, (class_8021)this.bottomHeader);
            JmUI.debugLayoutRender(graphics, (class_8021)this.contentLayout);
            JmUI.debugLayoutRender(graphics, (class_8021)this.footerLayout);
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            this.renderWrappedToolTip(graphics, tooltip, x, y, this.getFontRenderer());
        }
    }

    public void drawGradientRect(class_332 graphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        graphics.method_51740(class_1921.method_51785(), pX1, pY1, pX2, pY2, pColorFrom, pColorTo, pBlitOffset);
    }

    protected void closeAndReturn() {
        this.method_25419();
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public void closeWithKeyBind() {
        this.closeAndReturn();
    }

    public boolean method_25404(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.method_25404(key, value, modifier);
    }

    public void renderWrappedToolTip(class_332 graphics, List tooltip, int mouseX, int mouseY, class_327 fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof class_5481 && class_310.method_1551().field_1755 == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (class_5481 line : tooltip) {
                int lineWidth = fontRenderer.method_30880(line);
                if (fontRenderer.method_1726()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.field_22789) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.field_22790) {
                drawY = this.field_22790 - boxHeight - 6;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                class_5481 line = (class_5481)tooltip.get(i2);
                Matrix4f matrixPos = graphics.method_51448().method_23760().method_23761();
                if (fontRenderer.method_1726()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.method_30880(line) * 1.1);
                    fontRenderer.method_22942(line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1, true, matrixPos, (class_4597)graphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
                } else {
                    fontRenderer.method_22942(line, (float)drawX, (float)drawY, -1, true, matrixPos, (class_4597)graphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    public List<class_4068> getRenderables() {
        return this.field_33816;
    }

    private static void debugLayoutRender(class_332 graphics, class_8021 lElement) {
        int hash = lElement.hashCode();
        int color = Color.HSBtoRGB((float)(hash % 256) / 255.0f, (float)(hash % 128) / 127.0f + 128.0f, (float)(hash % 128) / 127.0f + 128.0f);
        DrawUtil.drawRectangle(graphics, lElement.method_46426(), lElement.method_46427(), lElement.method_25368(), 1.0, color, 0.8f);
        DrawUtil.drawRectangle(graphics, lElement.method_46426(), lElement.method_46427(), 1.0, lElement.method_25364(), color, 0.8f);
        DrawUtil.drawRectangle(graphics, lElement.method_46426(), lElement.method_46427() + lElement.method_25364() - 1, lElement.method_25368() - 1, 1.0, color, 0.8f);
        DrawUtil.drawRectangle(graphics, lElement.method_46426() + lElement.method_25368() - 1, lElement.method_46427() + 1, 1.0, lElement.method_25364() - 1, color, 0.8f);
        if (lElement instanceof class_8133) {
            class_8133 layout = (class_8133)lElement;
            layout.method_48227(l -> JmUI.debugLayoutRender(graphics, l));
        }
    }
}

